/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import eu.unicore.util.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class MulticastRegistryServer
extends Thread {
    private static final Logger logger = Log.getLogger((String)"unicore", MulticastRegistryServer.class);
    private final InetAddress bgroup;
    private final int port;
    private final Set<String> keys = new HashSet<String>();
    private final String server;
    public static final String MULTICAST_KEY = "UNICORE6Registry";
    private volatile boolean running = false;

    public MulticastRegistryServer(InetAddress bgroup, int port, String server, String ... keys) {
        this.bgroup = bgroup;
        this.port = port;
        this.keys.addAll(Arrays.asList(keys));
        this.server = server;
    }

    public MulticastRegistryServer(Kernel kernel) throws UnknownHostException {
        this(InetAddress.getByName("228.5.6.7"), 7700, MULTICAST_KEY, WSServerUtilities.makeAddress("Registry", "default_registry", kernel.getContainerProperties()));
    }

    @Override
    public void run() {
        logger.info((Object)"Starting MulticastRegistryServer.");
        try {
            MulticastSocket listenSocket = new MulticastSocket(this.port);
            listenSocket.joinGroup(this.bgroup);
            listenSocket.setSoTimeout(2000);
            byte[] buf = new byte[1000];
            DatagramPacket recv = new DatagramPacket(buf, buf.length);
            while (!this.isInterrupted()) {
                try {
                    this.running = true;
                    listenSocket.receive(recv);
                    String request = new String(recv.getData()).trim();
                    String requestKey = request.trim().split(":")[1];
                    logger.debug((Object)("Got request: " + request + " from " + recv.getAddress() + " key=" + requestKey));
                    if (this.keys.contains(requestKey)) {
                        Thread.sleep(500L);
                        this.sendResponse("Response:UNICORE6Registry:" + this.server);
                        continue;
                    }
                    logger.debug((Object)("Ignoring unknown request:" + request));
                }
                catch (IOException e) {}
            }
            this.running = false;
        }
        catch (Exception ex) {
            logger.warn((Object)"Error", (Throwable)ex);
        }
    }

    public void sendResponse(String response) throws IOException {
        MulticastSocket sendSocket = new MulticastSocket(this.port);
        sendSocket.joinGroup(this.bgroup);
        DatagramPacket hi = new DatagramPacket(response.getBytes(), response.length(), this.bgroup, this.port);
        sendSocket.send(hi);
        logger.info((Object)("Sent response back: " + response));
    }

    public boolean isRunning() {
        return this.running;
    }
}

