/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.registry;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.USEClientProperties;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xfire.ClientException;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.AddDocument;
import org.oasisOpen.docs.wsrf.sg2.AddResponseDocument;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.oasisOpen.docs.wsrf.sg2.EntryDocument;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.oasisOpen.docs.wsrf.sg2.ServiceGroupRPDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class LocalRegistryClient {
    public static final QName ENTRY_RP = EntryDocument.type.getDocumentElementName();
    private final EndpointReferenceType epr;
    private final String url;
    private Registry reg;
    private final Kernel kernel;

    public LocalRegistryClient(String resID, Kernel kernel) throws Exception {
        this.kernel = kernel;
        this.epr = EndpointReferenceType.Factory.newInstance();
        this.url = "xfire.local://Registry";
        this.epr.addNewAddress().setStringValue(this.url + "?res=" + resID);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)this.epr, (String)resID);
    }

    public LocalRegistryClient(Kernel kernel) throws Exception {
        this("default_registry", kernel);
    }

    protected synchronized Registry getRegistry() throws ClientException {
        if (this.reg == null) {
            USEClientProperties sec = this.kernel.getClientConfiguration();
            try {
                this.reg = (Registry)new WSRFClientFactory((IClientConfiguration)sec).createProxy(Registry.class, this.url, this.epr);
            }
            catch (Exception ex) {
                throw new ClientException((Throwable)ex);
            }
        }
        return this.reg;
    }

    public AddResponseDocument addRegistryEntry(AddDocument in) throws Exception {
        return this.getRegistry().Add(in);
    }

    public AddResponseDocument addRegistryEntry(EndpointReferenceType memberEpr, ContentType content) throws Exception {
        AddDocument in = AddDocument.Factory.newInstance();
        in.addNewAdd().setContent(content);
        in.getAdd().setMemberEPR(memberEpr);
        return this.addRegistryEntry(in);
    }

    public AddResponseDocument addRegistryEntry(EndpointReferenceType memberEpr) throws Exception {
        ContentType content = ContentType.Factory.newInstance();
        content.setNil();
        return this.addRegistryEntry(memberEpr, content);
    }

    public List<EntryType> listEntries() throws Exception {
        EntryType[] entries = this.getResourcePropertiesDocument().getServiceGroupRP().getEntryArray();
        return Arrays.asList(entries);
    }

    ServiceGroupRPDocument getResourcePropertiesDocument() throws Exception {
        GetResourcePropertyDocumentResponseDocument grprd = GetResourcePropertyDocumentResponseDocument.Factory.parse((String)this.getResourcePropertyDocument());
        ServiceGroupRPDocument doc = ServiceGroupRPDocument.Factory.parse((InputStream)grprd.getGetResourcePropertyDocumentResponse().newInputStream());
        return doc;
    }

    String getResourcePropertyDocument() throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, ClientException {
        GetResourcePropertyDocumentDocument1 req = GetResourcePropertyDocumentDocument1.Factory.newInstance();
        req.addNewGetResourcePropertyDocument();
        return String.valueOf(this.getRegistry().GetResourcePropertyDocument(req));
    }
}

