/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.impl;

import de.fzj.unicore.persist.impl.CustomObjectInputStream;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.ResourcePropertyBase;
import de.fzj.unicore.wsrflite.exceptions.InvalidModificationException;
import de.fzj.unicore.wsrflite.exceptions.UnableToSetTerminationTimeException;
import de.fzj.unicore.wsrflite.impl.ResourceImpl;
import de.fzj.unicore.wsrflite.persistence.Persist;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import de.fzj.unicore.wsrflite.xmlbeans.ModifiableResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.WSServerResource;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.InvalidResourcePropertyQNameFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceNotDestroyedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnavailableFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.ResourceUnknownFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.TerminationTimeChangeRejectedFault;
import de.fzj.unicore.wsrflite.xmlbeans.exceptions.UnableToSetTerminationTimeFault;
import de.fzj.unicore.wsrflite.xmlbeans.impl.CurrentTimeProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.SecurityInfoResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.TerminationTimeProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.VOMembershipResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSRFRepresentation;
import de.fzj.unicore.wsrflite.xmlbeans.registry.LocalRegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import eu.unicore.util.ConcurrentAccess;
import eu.unicore.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDateBuilder;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationSpecification;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.oasisOpen.docs.wsrf.rl2.DestroyDocument;
import org.oasisOpen.docs.wsrf.rl2.DestroyResponseDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeDocument;
import org.oasisOpen.docs.wsrf.rl2.SetTerminationTimeResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.DeleteType;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.GetMultipleResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.InsertType;
import org.oasisOpen.docs.wsrf.rp2.PutResourcePropertyDocumentDocument1;
import org.oasisOpen.docs.wsrf.rp2.PutResourcePropertyDocumentResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryExpressionType;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.QueryResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.SetResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.SetResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateResourcePropertiesResponseDocument;
import org.oasisOpen.docs.wsrf.rp2.UpdateType;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.unigrids.services.atomic.types.SecurityDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class WSResourceImpl
extends ResourceImpl
implements WSServerResource {
    protected static final Logger logger = Log.getLogger((String)"unicore.services", WSResourceImpl.class);
    public static final int INSERT = 1;
    public static final int DELETE = 2;
    public static final int UPDATE = 4;
    @Persist
    protected HashMap<QName, ResourceProperty> properties = new HashMap();
    private EndpointReferenceType myEPR;
    public static final QName RPSecurityInfoProperty = SecurityDocument.type.getDocumentElementName();
    public static final String INITPARAM_SHOW_SERVERCERT_IN_RP = WSResourceImpl.class.getName() + ".addServerCert";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlObject[] getResourcePropertyXML(QName qn) {
        block6: {
            try {
                ResourceProperty rp = this.properties.get(qn);
                if (rp != null) {
                    ResourceProperty resourceProperty = rp;
                    synchronized (resourceProperty) {
                        return rp.update().getXml();
                    }
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block6;
                logger.debug((Object)("Error retrieving rp " + qn), (Throwable)e);
            }
        }
        return null;
    }

    public ResourceProperty<?> getResourceProperty(QName qn) {
        return this.properties.get(qn);
    }

    public synchronized Object getResourcePropertyObject(QName qn) {
        block3: {
            try {
                ResourceProperty rp = this.properties.get(qn);
                if (rp != null) {
                    return rp.update().getProperty();
                }
            }
            catch (Exception e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace((Object)("Error retrieving rp " + qn), (Throwable)e);
            }
        }
        return null;
    }

    public QName[] getResourcePropertyQNames() {
        return this.properties.keySet().toArray(new QName[0]);
    }

    @ConcurrentAccess(allow=false)
    public DestroyResponseDocument Destroy(DestroyDocument in) throws ResourceNotDestroyedFault, ResourceUnknownFault, ResourceUnavailableFault {
        try {
            this.destroy();
            this.home.destroyWSRFServiceInstance(this.getUniqueID());
            DestroyResponseDocument drd = DestroyResponseDocument.Factory.newInstance();
            drd.addNewDestroyResponse();
            this.isDirty = false;
            return drd;
        }
        catch (Exception e) {
            Log.logException((String)"Error during resource destruction.", (Throwable)e, (Logger)logger);
            throw ResourceNotDestroyedFault.createFault((String)e.getMessage());
        }
    }

    @ConcurrentAccess(allow=false)
    public SetTerminationTimeResponseDocument SetTerminationTime(SetTerminationTimeDocument in) throws UnableToSetTerminationTimeFault, TerminationTimeChangeRejectedFault, ResourceUnknownFault, ResourceUnavailableFault {
        if (!in.getSetTerminationTime().isNilRequestedTerminationTime()) {
            Calendar c = in.getSetTerminationTime().getRequestedTerminationTime();
            GDuration d = in.getSetTerminationTime().getRequestedLifetimeDuration();
            if (d != null) {
                c = Calendar.getInstance();
                GDateBuilder b = new GDateBuilder(c);
                b.addGDuration((GDurationSpecification)d);
                GDate date = b.toGDate();
                c.setTime(date.getDate());
            }
            if (c != null) {
                try {
                    this.setTerminationTime(c);
                }
                catch (UnableToSetTerminationTimeException ex) {
                    throw UnableToSetTerminationTimeFault.createFault((String)ex.getMessage());
                }
            }
            throw UnableToSetTerminationTimeFault.createFault((String)"Illegal arguments to SetTerminationTime.");
        }
        try {
            this.setTerminationTime(null);
        }
        catch (UnableToSetTerminationTimeException ex) {
            throw UnableToSetTerminationTimeFault.createFault((String)ex.getMessage());
        }
        SetTerminationTimeResponseDocument response = SetTerminationTimeResponseDocument.Factory.newInstance();
        response.addNewSetTerminationTimeResponse().setNewTerminationTime((Calendar)this.getResourcePropertyObject(RPterminationTimeQName));
        response.getSetTerminationTimeResponse().setCurrentTime(Calendar.getInstance());
        this.setDirty();
        return response;
    }

    @ConcurrentAccess(allow=false)
    public DeleteResourcePropertiesResponseDocument DeleteResourceProperties(DeleteResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        try {
            DeleteType delete = in.getDeleteResourceProperties().getDelete();
            QName q = delete.getResourceProperty();
            ResourceProperty rp = this.properties.get(q);
            if (!this.isModifyable(rp, 2)) {
                throw BaseFault.createFault((String)("Unable to modify <" + q + ">"));
            }
            ((ModifiableResourceProperty)rp).delete();
            DeleteResourcePropertiesResponseDocument res = DeleteResourcePropertiesResponseDocument.Factory.newInstance();
            res.addNewDeleteResourcePropertiesResponse();
            return res;
        }
        catch (InvalidModificationException ime) {
            throw BaseFault.createFault((String)"Modifications are not valid.", (Throwable)ime, (boolean)true);
        }
    }

    @ConcurrentAccess(allow=false)
    public PutResourcePropertyDocumentResponseDocument PutResourcePropertyDocument(PutResourcePropertyDocumentDocument1 in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        throw BaseFault.createFault((String)"Not implemented.");
    }

    @ConcurrentAccess(allow=false)
    public InsertResourcePropertiesResponseDocument InsertResourceProperties(InsertResourcePropertiesDocument in) throws ResourceUnknownFault, ResourceUnavailableFault, BaseFault {
        try {
            InsertType insert = in.getInsertResourceProperties().getInsert();
            QName q = WSUtilities.findAnyElementQName((XmlObject)insert);
            XmlObject[] rpChange = WSUtilities.extractAnyElements((XmlObject)insert, (QName)q);
            ResourceProperty rp = this.properties.get(q);
            if (!this.isModifyable(rp, 1)) {
                throw BaseFault.createFault((String)("Unable to modify <" + q + ">"));
            }
            for (XmlObject o : rpChange) {
                ((ModifiableResourceProperty)rp).insert(o);
            }
            InsertResourcePropertiesResponseDocument res = InsertResourcePropertiesResponseDocument.Factory.newInstance();
            res.addNewInsertResourcePropertiesResponse();
            return res;
        }
        catch (InvalidModificationException ime) {
            throw BaseFault.createFault((String)"Modifications are not valid.", (Throwable)ime, (boolean)true);
        }
    }

    public XmlObject getResourcePropertyResponseDocument() throws Exception {
        return new WSRFRepresentation(this).getContentObject();
    }

    public abstract QName getResourcePropertyDocumentQName();

    @ConcurrentAccess
    public GetResourcePropertyDocumentResponseDocument GetResourcePropertyDocument(GetResourcePropertyDocumentDocument1 in) throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault {
        GetResourcePropertyDocumentResponseDocument resDoc = GetResourcePropertyDocumentResponseDocument.Factory.newInstance();
        try {
            GetResourcePropertyDocumentResponseDocument.GetResourcePropertyDocumentResponse res = resDoc.addNewGetResourcePropertyDocumentResponse();
            res.set(this.getResourcePropertyResponseDocument());
            return resDoc;
        }
        catch (Exception e) {
            Log.logException((String)"Could not build resourceproperty document.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Could not build resourceproperty document.", (Throwable)e, (boolean)true);
        }
    }

    @ConcurrentAccess(allow=false)
    public UpdateResourcePropertiesResponseDocument UpdateResourceProperties(UpdateResourcePropertiesDocument in) throws BaseFault {
        try {
            UpdateType update = in.getUpdateResourceProperties().getUpdate();
            QName q = WSUtilities.findAnyElementQName((XmlObject)update);
            if (q == null) {
                throw BaseFault.createFault((String)"Invalid update request, qname is null.");
            }
            XmlObject[] rpChange = WSUtilities.extractAnyElements((XmlObject)update, (QName)q);
            ArrayList rpChangeAsList = new ArrayList();
            Collections.addAll(rpChangeAsList, rpChange);
            ResourceProperty rp = this.properties.get(q);
            if (!this.isModifyable(rp, 4)) {
                throw BaseFault.createFault((String)("Unable to modify <" + q + "> as it is immutable."));
            }
            ((ModifiableResourceProperty)rp).update(rpChangeAsList);
            UpdateResourcePropertiesResponseDocument res = UpdateResourcePropertiesResponseDocument.Factory.newInstance();
            res.addNewUpdateResourcePropertiesResponse();
            return res;
        }
        catch (InvalidModificationException ime) {
            throw BaseFault.createFault((String)"Modifications are not valid.", (Throwable)ime, (boolean)true);
        }
    }

    @ConcurrentAccess
    public GetResourcePropertyResponseDocument GetResourceProperty(GetResourcePropertyDocument in) throws BaseFault, ResourceUnknownFault, ResourceUnavailableFault, InvalidResourcePropertyQNameFault {
        QName qn = in.getGetResourceProperty();
        if (qn == null) {
            throw InvalidResourcePropertyQNameFault.createFault((String)"Unknown resource property <null>");
        }
        GetResourcePropertyResponseDocument response = GetResourcePropertyResponseDocument.Factory.newInstance();
        XmlObject[] os = this.getResourcePropertyXML(qn);
        if (os == null) {
            throw InvalidResourcePropertyQNameFault.createFault((String)("Unknown resource property " + qn));
        }
        try {
            GetResourcePropertyResponseDocument.GetResourcePropertyResponse r = response.addNewGetResourcePropertyResponse();
            XmlCursor c = r.newCursor();
            c.toFirstContentToken();
            for (XmlObject o : os) {
                if (o == null) continue;
                XmlCursor c1 = o.newCursor();
                c1.toFirstContentToken();
                c1.copyXml(c);
            }
            return response;
        }
        catch (Exception e) {
            Log.logException((String)"Could not build resourceproperty document.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Could not build resourceproperty document.", (Throwable)e, (boolean)true);
        }
    }

    @ConcurrentAccess
    public GetMultipleResourcePropertiesResponseDocument GetMultipleResourceProperties(GetMultipleResourcePropertiesDocument in) throws BaseFault {
        GetMultipleResourcePropertiesResponseDocument res = GetMultipleResourcePropertiesResponseDocument.Factory.newInstance();
        GetMultipleResourcePropertiesResponseDocument.GetMultipleResourcePropertiesResponse response = res.addNewGetMultipleResourcePropertiesResponse();
        try {
            for (QName q : in.getGetMultipleResourceProperties().getResourcePropertyArray()) {
                XmlObject[] rp = this.getResourcePropertyXML(q);
                WSUtilities.append((XmlObject[])rp, (XmlObject)response);
            }
        }
        catch (Exception e) {
            Log.logException((String)"Could not fulfil GetMultipleResourceProperties request.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Could not fulfil GetMultipleResourceProperties request.", (Throwable)e, (boolean)true);
        }
        return res;
    }

    @ConcurrentAccess
    public QueryResourcePropertiesResponseDocument QueryResourceProperties(QueryResourcePropertiesDocument in) throws BaseFault {
        QueryExpressionType q = in.getQueryResourceProperties().getQueryExpression();
        String dialect = q.getDialect();
        if (!"http://www.w3.org/TR/1999/REC-xpath-19991116".equals(dialect)) {
            throw BaseFault.createFault((String)"Unsupported query dialect.");
        }
        try {
            String query = in.getQueryResourceProperties().getQueryExpression().newCursor().getTextValue();
            XmlObject doc = null;
            doc = this.getResourcePropertyResponseDocument();
            logger.debug((Object)("Executing XPath query: " + query + " against " + doc));
            XmlObject[] os = doc.selectPath(query);
            XmlObject obj = XmlObject.Factory.newInstance();
            if (os != null) {
                logger.debug((Object)("Found " + os.length + " results."));
                XmlCursor c = obj.newCursor();
                c.toNextToken();
                for (XmlObject o : os) {
                    logger.trace((Object)("Result: " + o));
                    XmlCursor c1 = o.newCursor();
                    c1.copyXml(c);
                    c1.dispose();
                }
            }
            QueryResourcePropertiesResponseDocument res = QueryResourcePropertiesResponseDocument.Factory.newInstance();
            if (os != null && os.length > 0) {
                res.addNewQueryResourcePropertiesResponse().set(obj);
            } else {
                res.addNewQueryResourcePropertiesResponse();
            }
            return res;
        }
        catch (Exception e) {
            Log.logException((String)"", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Error performing query", (Throwable)e, (boolean)true);
        }
    }

    @ConcurrentAccess(allow=false)
    public SetResourcePropertiesResponseDocument SetResourceProperties(SetResourcePropertiesDocument in) throws BaseFault {
        throw BaseFault.createFault((String)"Not implemented.");
    }

    public void initialise(String serviceName, Map<String, Object> initobjs) throws Exception {
        super.initialise(serviceName, initobjs);
        this.properties.put(RPcurrentTimeQName, new CurrentTimeProperty());
        this.properties.put(RPterminationTimeQName, new TerminationTimeProperty(this));
        boolean addServerCert = Boolean.TRUE.equals(initobjs.get(INITPARAM_SHOW_SERVERCERT_IN_RP));
        this.properties.put(RPSecurityInfoProperty, this.getSecurityInfoResourceProperty(addServerCert));
        this.properties.put(VOMembershipResourceProperty.QNAME, new VOMembershipResourceProperty(this));
        this.setDirty();
    }

    protected ResourceProperty<?> getSecurityInfoResourceProperty(boolean addServerCert) {
        return new SecurityInfoResourceProperty(this, addServerCert);
    }

    public void activate(Map<String, Serializable> state) {
        super.activate(state);
        Iterator<Map.Entry<QName, ResourceProperty>> entries = this.properties.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<QName, ResourceProperty> entry = entries.next();
            QName q = entry.getKey();
            ResourceProperty o = entry.getValue();
            if (o == null || o instanceof CustomObjectInputStream.PlaceHolder) {
                logger.debug((Object)("Obsolete value with qname: " + q + ", removing"));
                entries.remove();
                continue;
            }
            ResourcePropertyBase p = o;
            p.setResource((Resource)this);
        }
        if (this.properties.get(RPSecurityInfoProperty) == null) {
            this.properties.put(RPSecurityInfoProperty, this.getSecurityInfoResourceProperty(false));
        }
    }

    protected boolean isModifyable(ResourceProperty<?> rp, int operation) {
        if (!(rp instanceof ModifiableResourceProperty)) {
            return false;
        }
        return ((ModifiableResourceProperty)rp).checkPermissions(operation);
    }

    public void publish() {
        try {
            ContentType content = null;
            try {
                ArrayList<XmlObject> publish = new ArrayList<XmlObject>();
                for (QName q : this.publishedRPs()) {
                    for (XmlObject o : this.getResourcePropertyXML(q)) {
                        publish.add(o);
                    }
                }
                content = RegistryClient.makeContent(publish);
            }
            catch (Exception e) {
                // empty catch block
            }
            LocalRegistryClient c = ((RegistryHandler)this.kernel.getAttribute(RegistryHandler.class)).getRegistryClient();
            if (c != null) {
                c.addRegistryEntry(this.getEPR(), content);
                logger.info((Object)("Added registry entry for " + this.getServiceName() + "<" + this.getUniqueID() + ">"));
            } else {
                logger.info((Object)"Not publishing entry, no local registry is configured for this site.");
            }
        }
        catch (Exception e) {
            Log.logException((String)"Could not publish to registry", (Throwable)e, (Logger)logger);
        }
    }

    protected Set<QName> publishedRPs() {
        return new HashSet<QName>();
    }

    protected synchronized EndpointReferenceType getEPR() {
        if (this.myEPR == null) {
            this.myEPR = WSServerUtilities.newEPR(this.getKernel().getContainerSecurityConfiguration());
            this.myEPR.addNewAddress().setStringValue(WSServerUtilities.makeAddress(this.getServiceName(), this.getUniqueID(), this.getKernel().getContainerProperties()));
            QName pt = this.getPortType();
            if (pt != null) {
                WSServerUtilities.addPortType((EndpointReferenceType)this.myEPR, (QName)this.getPortType());
            }
        }
        return this.myEPR;
    }

    public QName getPortType() {
        return null;
    }
}

