/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.impl;

import de.fzj.unicore.wsrflite.xmlbeans.ResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import eu.unicore.util.Log;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class WSRFRepresentation {
    private static final Logger logger = Log.getLogger((String)"unicore.services", WSRFRepresentation.class);
    final WSResourceImpl resource;

    public WSRFRepresentation(WSResourceImpl resource) {
        this.resource = resource;
    }

    public XmlObject getContentObject() throws Exception {
        XmlObject reply = null;
        reply = this.resource.getResourcePropertyDocumentQName() != null ? this.createSchemaCompliantRPDocument() : this.createNoSchemaRPDocument();
        return reply;
    }

    private XmlObject createNoSchemaRPDocument() throws Exception {
        XmlObject obj = XmlObject.Factory.parse((String)"<unic:WSResourceImplResourceProperties xmlns:unic=\"http://www.unicore.eu/unicore6/wsrflite\"></unic:WSResourceImplResourceProperties>");
        XmlCursor c = obj.newCursor();
        while (!c.isStart()) {
            c.toNextToken();
        }
        while (!c.isEnd()) {
            c.toNextToken();
        }
        for (QName qn : this.resource.getResourcePropertyQNames()) {
            XmlObject[] os = this.resource.getResourcePropertyXML(qn);
            if (os == null) continue;
            for (XmlObject o : os) {
                XmlCursor c1 = o.newCursor();
                c1.toNextToken();
                c1.copyXml(c);
                c1.dispose();
            }
        }
        c.dispose();
        return obj;
    }

    private XmlObject createSchemaCompliantRPDocument() {
        try {
            HashSet<QName> remainingQNames = new HashSet<QName>();
            remainingQNames.addAll(this.resource.properties.keySet());
            ClassLoader cl = this.resource.getClass().getClassLoader();
            SchemaType st = XmlBeans.typeLoaderForClassLoader((ClassLoader)cl).findDocumentType(this.resource.getResourcePropertyDocumentQName());
            SchemaProperty[] sp = st.getElementProperties();
            String pName = sp[0].getJavaPropertyName();
            XmlObject pDoc = XmlObject.Factory.newInstance().changeType(st);
            Method adder = pDoc.getClass().getMethod("addNew" + pName, new Class[0]);
            XmlObject props = (XmlObject)adder.invoke((Object)pDoc, (Object[])null);
            XmlCursor c = props.newCursor();
            c.toFirstContentToken();
            sp = props.schemaType().getElementProperties();
            XmlObject lastRP = null;
            for (SchemaProperty p : sp) {
                try {
                    QName qname = p.getName();
                    remainingQNames.remove(qname);
                    XmlObject[] rps = this.resource.getResourcePropertyXML(qname);
                    if (rps == null) continue;
                    for (XmlObject o : rps) {
                        if (o != null) {
                            lastRP = o;
                            XmlCursor c2 = o.newCursor();
                            c2.toFirstChild();
                            c2.copyXml(c);
                            c2.dispose();
                            continue;
                        }
                        logger.debug((Object)("Null xml for property " + qname));
                    }
                }
                catch (Exception e) {
                    Log.logException((String)("Exception setting value for resource property" + p.getName()), (Throwable)e, (Logger)logger);
                }
                catch (Error err) {
                    logger.error((Object)("Error setting value for resource property " + p.getName()), (Throwable)err);
                    try {
                        logger.error((Object)("Value : " + lastRP));
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
            }
            c.dispose();
            this.appendAdditionalRPs(pDoc, remainingQNames);
            return pDoc;
        }
        catch (Exception e) {
            Log.logException((String)"Can't build rp document.", (Throwable)e, (Logger)logger);
            return null;
        }
    }

    protected void appendAdditionalRPs(XmlObject propertyDoc, Set<QName> remainingQNames) throws Exception {
        for (QName q : remainingQNames) {
            ResourceProperty prop = this.resource.properties.get(q);
            if (prop == null) continue;
            WSUtilities.append((XmlObject[])prop.getXml(), (XmlObject)propertyDoc);
        }
    }
}

