/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xmlbeans.impl;

import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Node;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.exceptions.InvalidModificationException;
import de.fzj.unicore.wsrflite.impl.SecuredResourceImpl;
import de.fzj.unicore.wsrflite.security.VODescription;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import de.fzj.unicore.wsrflite.xmlbeans.ModifiableResourceProperty;
import de.fzj.unicore.wsrflite.xmlbeans.impl.VODescriptionExt;
import de.fzj.unicore.wsrflite.xmlbeans.impl.WSResourceImpl;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryCreator;
import de.fzj.unicore.wsrflite.xmlbeans.registry.VORegistries;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.VOMembershipType;
import org.unigrids.services.atomic.types.VOMembershipsDocument;
import org.unigrids.services.atomic.types.VOMembershipsType;

public class VOMembershipResourceProperty
extends ModifiableResourceProperty<VOMembershipsDocument, Map<String, Set<OperationType>>> {
    private static final Logger logger = Log.getLogger((String)"unicore.services", VOMembershipResourceProperty.class);
    private static final long serialVersionUID = 1L;
    public static final QName QNAME = VOMembershipsDocument.type.getDocumentElementName();

    public VOMembershipResourceProperty(WSResourceImpl parent) {
        super(QNAME, parent, true, 0, 1);
    }

    @Override
    public synchronized void update(List<VOMembershipsDocument> o) throws InvalidModificationException {
        if (o.size() > 1) {
            throw new InvalidModificationException("Cardinality of VO membersip property must be 0 or 1");
        }
        Map<VODescriptionExt, Set<OperationType>> newValue = this.convert(o);
        this.changeVoMembership(newValue, o);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Recursively changed VO membership rules  of " + this.parentWSResource.getUniqueID() + " and its children to " + newValue));
        }
    }

    @Override
    public void insert(VOMembershipsDocument o) throws InvalidModificationException {
        if (((VOMembershipsDocument[])this.getXml()).length != 0) {
            throw new InvalidModificationException("Cardinality of VO membersip property must be 0 or 1");
        }
        this.update(Collections.singletonList(o));
    }

    @Override
    public void delete() throws InvalidModificationException {
        this.update((List<VOMembershipsDocument>)new ArrayList<VOMembershipsDocument>());
    }

    protected Map<VODescriptionExt, Set<OperationType>> convert(List<VOMembershipsDocument> o) throws InvalidModificationException {
        VOMembershipType[] vos;
        HashMap<VODescriptionExt, Set<OperationType>> ret = new HashMap<VODescriptionExt, Set<OperationType>>();
        if (o.size() == 0) {
            return ret;
        }
        VOMembershipsType req = o.get(0).getVOMemberships();
        for (VOMembershipType vo : vos = req.getMembershipArray()) {
            String[] accessTypes = vo.getAllowedAccessTypes().getAllowedAccessTypeArray();
            HashSet<OperationType> parsedTypes = new HashSet<OperationType>();
            for (String accessType : accessTypes) {
                try {
                    parsedTypes.add(OperationType.valueOf((String)accessType));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidModificationException("Illegal value of accessType '" + accessType + "'. Must be one of " + Arrays.toString(OperationType.values()));
                }
            }
            VODescriptionExt voDesc = new VODescriptionExt(vo.getVo().getVoName(), vo.getVo().getVoServer(), vo.getVo().getVoRegistry());
            ret.put(voDesc, parsedTypes);
        }
        return ret;
    }

    public synchronized void updateInternal(Map<VODescriptionExt, Set<OperationType>> newValue, List<VOMembershipsDocument> o) throws Exception {
        SecuredResourceImpl securedResource = (SecuredResourceImpl)this.parentWSResource;
        Map oldValue = securedResource.getExtendedVOMembership();
        HashMap<VODescriptionExt, Set<OperationType>> addedVos = new HashMap<VODescriptionExt, Set<OperationType>>();
        HashMap<VODescriptionExt, Set<OperationType>> modifiedVos = new HashMap<VODescriptionExt, Set<OperationType>>();
        HashMap<VODescription, Set<OperationType>> removedVos = new HashMap<VODescription, Set<OperationType>>();
        for (VODescriptionExt newKey : newValue.keySet()) {
            Set existingSharing;
            Object existingSharingKey = this.findVoDesc(oldValue, newKey.getVoName());
            Set set = existingSharing = existingSharingKey == null ? null : (Set)oldValue.get(existingSharingKey);
            if (existingSharing == null) {
                addedVos.put(newKey, newValue.get((Object)newKey));
                continue;
            }
            if (((Object)existingSharing).equals(newValue.get((Object)newKey))) continue;
            modifiedVos.put(newKey, newValue.get((Object)newKey));
        }
        for (VODescription oldKey : oldValue.keySet()) {
            VODescriptionExt newSharingKey = this.findVoDesc(newValue, oldKey.getVoName());
            if (newSharingKey != null) continue;
            removedVos.put(oldKey, (Set<OperationType>)oldValue.get(oldKey));
        }
        if (addedVos.size() + modifiedVos.size() + removedVos.size() > 1) {
            throw new InvalidModificationException("It is not allowed to perform more then one VO membership change operation at once.");
        }
        Map.Entry used = null;
        if (addedVos.size() > 0) {
            used = addedVos.entrySet().iterator().next();
        }
        if (modifiedVos.size() > 0) {
            used = modifiedVos.entrySet().iterator().next();
        }
        if (removedVos.size() > 0) {
            used = removedVos.entrySet().iterator().next();
        }
        if (used == null) {
            return;
        }
        Client client = AuthZAttributeStore.getClient();
        String currentVO = client.getVo();
        if (currentVO == null) {
            throw new InvalidModificationException("It is not allowed to perform VO membership change operation without an effective VO set for the request.");
        }
        if (!currentVO.equals(((VODescription)used.getKey()).getVoName())) {
            throw new InvalidModificationException("It is not allowed to perform VO membership change operation with a different effective VO set for the request then the one being used for membership change. Effective VO is " + currentVO + ", used VO is: " + ((VODescription)used.getKey()).getVoName());
        }
        if (logger.isDebugEnabled()) {
            if (addedVos.size() > 0) {
                logger.debug((Object)("Adding the resource " + this.parentWSResource + " to VOs: " + ((Object)addedVos).toString()));
            }
            if (modifiedVos.size() > 0) {
                logger.debug((Object)("Changing sharing of the resource " + this.parentWSResource + " with VOs: " + ((Object)modifiedVos).toString()));
            }
            if (removedVos.size() > 0) {
                logger.debug((Object)("Unsharing the resource " + this.parentWSResource + " with VOs: " + ((Object)removedVos).toString()));
            }
        }
        securedResource.updateVoMembership(addedVos, modifiedVos, removedVos, newValue);
        securedResource.setVOMembership(newValue);
        super.update(o);
        try {
            this.updateRegistry(this.parentWSResource.getKernel(), addedVos, modifiedVos, removedVos);
        }
        catch (Exception e) {
            throw new InvalidModificationException("Resource was successfully shared, but registration in the in the VO registry failed: " + e.toString(), (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Changed VO membership rules  of " + this.parentWSResource.getUniqueID() + " to " + newValue));
        }
    }

    private <T extends VODescription> T findVoDesc(Map<T, Set<OperationType>> vos, String searched) {
        for (VODescription key : vos.keySet()) {
            if (!key.getVoName().equals(searched)) continue;
            return (T)key;
        }
        return null;
    }

    private void updateRegistry(Kernel kernel, Map<VODescriptionExt, Set<OperationType>> addedVos, Map<VODescriptionExt, Set<OperationType>> modifiedVos, Map<VODescription, Set<OperationType>> removedVos) throws Exception {
        Set<OperationType> type;
        RegistryCreator rc = (RegistryCreator)kernel.getAttribute(RegistryCreator.class);
        if (rc.isGlobalRegistry()) {
            throw new ConfigurationException("It is not possible to share resources when there is no local registry deployed.");
        }
        VORegistries registries = (VORegistries)kernel.getAttribute(VORegistries.class);
        for (VODescriptionExt added : addedVos.keySet()) {
            type = addedVos.get((Object)added);
            registries.addSharedResource(added, this.parentWSResource, type);
        }
        for (VODescriptionExt modified : modifiedVos.keySet()) {
            type = modifiedVos.get((Object)modified);
            registries.addSharedResource(modified, this.parentWSResource, type);
        }
        for (VODescription removed : removedVos.keySet()) {
            String address = VORegistries.getEPRAddress(kernel, this.parentWSResource);
            registries.removeSharedResource(removed.getVoName(), address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeVoMembership(Map<VODescriptionExt, Set<OperationType>> newVoMembership, List<VOMembershipsDocument> o) throws InvalidModificationException {
        try {
            this.updateInternal(newVoMembership, o);
        }
        catch (InvalidModificationException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn((Object)("Change of VO membership was not successful on " + this.parentWSResource.getServiceName() + "-" + this.parentWSResource.getUniqueID() + ". Reason: " + e));
            throw new InvalidModificationException("Change of VO membership failed", (Throwable)e);
        }
        Set children = this.parentWSResource.getNode().getChildren();
        Kernel kernel = this.parentWSResource.getKernel();
        StringBuilder failed = new StringBuilder();
        if (children != null) {
            for (Node child : children) {
                Home home = kernel.getHome(child.getServiceName());
                if (home == null) continue;
                WSResourceImpl securedChild = null;
                try {
                    try {
                        VOMembershipResourceProperty rp;
                        securedChild = (WSResourceImpl)home.getForUpdate(child.getUniqueID());
                        if (!securedChild.isRecursiveVOMembershipChangeHonored() || (rp = (VOMembershipResourceProperty)securedChild.getResourceProperty(QNAME)) == null) continue;
                        rp.updateInternal(newVoMembership, o);
                    }
                    finally {
                        if (securedChild != null) {
                            home.persist((Resource)securedChild);
                        }
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Change of VO membership was not successful on " + securedChild.getServiceName() + "-" + securedChild.getUniqueID() + ". Reason: " + e));
                    failed.append(securedChild.getServiceName() + "-" + securedChild.getUniqueID() + ": " + e.toString() + "\n");
                }
            }
        }
        if (failed.length() > 0) {
            throw new InvalidModificationException("The VO membership change was SUCCESSFUL for this resource,  but some of the child resources failed to update their mebership. The problematic resources are:\n" + failed);
        }
    }
}

