/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire.utils;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.http.HtmlServiceWriter;
import org.codehaus.xfire.util.STAXUtils;

public class WSRFHtmlServiceWriter
extends HtmlServiceWriter {
    private static final String XHTML_STRICT_DTD = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    private final String baseUrl;

    public WSRFHtmlServiceWriter(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public WSRFHtmlServiceWriter(HttpServletRequest request, String baseUrl) {
        super(request);
        this.baseUrl = baseUrl;
    }

    public void write(OutputStream out, Collection services) throws XMLStreamException {
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter((OutputStream)out, null, null);
        writer.writeStartDocument();
        this.writePreamble(writer, "UNICORE Services");
        writer.writeStartElement("body");
        writer.writeStartElement("p");
        writer.writeEndElement();
        if (!services.isEmpty()) {
            writer.writeStartElement("p");
            writer.writeCharacters("Available services at this UNICORE Site:");
            writer.writeEndElement();
            writer.writeStartElement("ul");
            ArrayList servicesList = new ArrayList();
            servicesList.addAll(services);
            Collections.sort(servicesList, new ServiceComparator());
            services = servicesList;
            for (Service service : services) {
                String url = this.baseUrl + "/" + service.getSimpleName() + "?wsdl";
                writer.writeStartElement("li");
                writer.writeCharacters(service.getSimpleName());
                Object obj = service.getProperty("wsdl.generation.disabled");
                if (obj == null || "false".equals(obj.toString().toLowerCase())) {
                    writer.writeCharacters(" ");
                    writer.writeStartElement("a");
                    writer.writeAttribute("href", url);
                    writer.writeCharacters("[wsdl]");
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeComment("Just filling space according to http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807");
        writer.writeComment("Just filling space according to http://support.microsoft.com/default.aspx?scid=kb;en-us;Q294807");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeEmptyElement("br");
        writer.writeCharacters("       Generated by UNICORE ( http://www.unicore.eu ) ");
        writer.writeEmptyElement("hr");
        writer.writeEndDocument();
        writer.flush();
    }

    private void writePreamble(XMLStreamWriter writer, String title) throws XMLStreamException {
        writer.writeDTD(XHTML_STRICT_DTD);
        writer.writeStartElement("html");
        writer.writeStartElement("head");
        writer.writeStartElement("title");
        writer.writeCharacters(title);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    static class ServiceComparator
    implements Comparator {
        ServiceComparator() {
        }

        public int compare(Object service1, Object service2) {
            return ((Service)service1).getSimpleName().compareToIgnoreCase(((Service)service2).getSimpleName());
        }
    }
}

