/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire.utils;

import de.fzj.unicore.wsrflite.utils.deployment.ServiceClassLoader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.stream.XMLStreamReader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.util.stax.FragmentStreamReader;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.xmlbeans.XmlBeansType;
import org.codehaus.xfire.xmlbeans.XmlBeansWSDLBuilder;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class CustomWSDLBuilder
extends XmlBeansWSDLBuilder {
    private static final StaxBuilder builder = new StaxBuilder();
    private static final Map<String, Element> schemas = new HashMap<String, Element>();
    private final ClassLoader classLoader;
    private final List<Element> importedSchemas = new ArrayList<Element>();

    public CustomWSDLBuilder(Service service, TransportManager transportManager, ClassLoader cl) throws WSDLException {
        super(service, transportManager);
        this.classLoader = cl != null ? cl : new ServiceClassLoader();
    }

    public void addDependency(SchemaType type) {
        if (!this.hasDependency(type) && type instanceof XmlBeansType) {
            XmlBeansType xbeanType = (XmlBeansType)type;
            Element schema = this.getSchema(xbeanType);
            String ns = xbeanType.getSchemaType().getNamespaceURI();
            if (!this.importedSchemas.contains(schema)) {
                schema.detach();
                this.setSchema(ns, schema);
                this.importedSchemas.add(schema);
            }
        }
        super.addDependency(type);
    }

    public Element getSchema(XmlBeansType xbeanType) {
        org.apache.xmlbeans.SchemaType type = XmlBeans.typeForClass((Class)xbeanType.getTypeClass());
        String name = type.getSourceName();
        if (name == null) {
            return null;
        }
        Element schema = schemas.get(name);
        if (schema != null) {
            return schema;
        }
        try {
            XmlObject obj = XmlObject.Factory.parse((InputStream)this.classLoader.getResourceAsStream("schemaorg_apache_xmlbeans/src/" + name));
            schema = builder.build((XMLStreamReader)new FragmentStreamReader(obj.newXMLStreamReader())).getRootElement();
            String ns = xbeanType.getSchemaType().getNamespaceURI();
            String expr = "//xsd:schema[@targetNamespace='" + ns + "']";
            List<?> nodes = this.getMatches(schema, expr);
            if (nodes.size() == 0) {
                return null;
            }
            schema = (Element)nodes.get(0);
            schemas.put(name, schema);
            return schema;
        }
        catch (Exception e) {
            throw new XFireRuntimeException("Couldn't load schema.", (Throwable)e);
        }
    }

    private List<?> getMatches(Object doc, String xpath) {
        try {
            XPath path = XPath.newInstance((String)xpath);
            path.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            path.addNamespace("s", "http://www.w3.org/2001/XMLSchema");
            List result = path.selectNodes(doc);
            return result;
        }
        catch (JDOMException e) {
            throw new XFireRuntimeException("Error evaluating xpath " + xpath, (Throwable)e);
        }
    }
}

