/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire.utils;

import de.fzj.unicore.wsrflite.xfire.JettyTestCase;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocumentDocument1;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class AbstractLoadTester
extends JettyTestCase {
    public int max_num_client_threads = 2;
    public int requests_per_client = 30;
    public int calls_per_task = 5;
    protected static Writer statsWriter;
    public static boolean haveInit;
    private static GetResourcePropertyDocumentDocument1 getRpdReq;
    protected static int running;
    private ArrayList<Long> responseTimes;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.responseTimes = new ArrayList(this.requests_per_client * this.max_num_client_threads);
        statsWriter = this.makeOutputWriter();
        if (haveInit) {
            return;
        }
        getRpdReq = GetResourcePropertyDocumentDocument1.Factory.newInstance();
        getRpdReq.addNewGetResourcePropertyDocument();
        AbstractLoadTester.printStats(new Date() + ": gathering statistics started.");
        haveInit = true;
    }

    protected Writer makeOutputWriter() throws IOException {
        String statsFile = "./loadtest_" + this.max_num_client_threads + "_" + this.requests_per_client;
        while (new File(statsFile).exists()) {
            statsFile = statsFile + "_1";
        }
        return new FileWriter(statsFile);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.server.stop();
    }

    protected abstract Runnable getTask();

    protected Runnable runOneClient() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    String tName = Thread.currentThread().getName();
                    System.out.println(tName + " starting");
                    for (int i = 0; i < AbstractLoadTester.this.requests_per_client; ++i) {
                        AbstractLoadTester.this.runTimed("[" + tName + "] Run single task ", AbstractLoadTester.this.getTask());
                    }
                    AbstractLoadTester.printStats("[" + Thread.currentThread().getName() + "] ended.");
                    --running;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected void runTimed(String msg, Runnable r) throws Exception {
        long s = System.currentTimeMillis();
        r.run();
        long e = System.currentTimeMillis();
        long t = (e - s) / (long)this.calls_per_task;
        AbstractLoadTester.printStats(msg + " [" + t + " ms], running threads=" + running);
        this.responseTimes.add(t);
    }

    protected static synchronized void printStats(String s) throws Exception {
        statsWriter.append(s + "\n");
        statsWriter.flush();
    }

    protected Object makeProxy(Class<?> iFaceclass, String serviceName) throws Exception {
        EndpointReferenceType epr1 = EndpointReferenceType.Factory.newInstance();
        epr1.addNewAddress().setStringValue(this.getBaseurl() + "/" + serviceName);
        return new WSRFClientFactory().createProxy(iFaceclass, this.getBaseurl() + "/" + serviceName, epr1);
    }

    public void test() throws Exception {
        System.out.println("Running load test.");
        System.out.println("Client Threads=" + this.max_num_client_threads);
        System.out.println("Tasks per client=" + this.requests_per_client);
        System.out.println("Requests per Task=" + this.calls_per_task);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.max_num_client_threads; ++i) {
            Thread t = new Thread(this.runOneClient());
            t.setName("LoadTesterThread-" + i);
            t.start();
            ++running;
        }
        while (running > 0) {
            System.out.println("running=" + running);
            Thread.sleep(1500L);
        }
        System.out.println("running=" + running);
        Long a = 0L;
        Long total = 0L;
        for (Long l : this.responseTimes) {
            total = total + l;
        }
        a = total / (long)this.responseTimes.size();
        long t = System.currentTimeMillis() - start;
        long tx = this.calls_per_task * this.max_num_client_threads * this.requests_per_client;
        AbstractLoadTester.printStats("Summary:");
        AbstractLoadTester.printStats("Ran " + tx + " requests (" + this.max_num_client_threads + " client threads, " + this.calls_per_task * this.requests_per_client + " requests each.)");
        AbstractLoadTester.printStats("Average response time: " + a + "ms.");
        AbstractLoadTester.printStats("Total time: " + t + "ms.");
        AbstractLoadTester.printStats("Transactions per sec: " + tx * 1000L / t);
        AbstractLoadTester.printStats(new Date() + ": Collecting stats ended.");
    }

    static {
        haveInit = false;
        running = 0;
    }
}

