/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.XmlBinding;
import de.fzj.unicore.wsrflite.security.DSignCheck;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.UASSelfCallChecker;
import de.fzj.unicore.wsrflite.security.UserAttributeCallback;
import de.fzj.unicore.wsrflite.utils.deployment.ServiceClassLoader;
import de.fzj.unicore.wsrflite.xfire.MTOMInHandler;
import de.fzj.unicore.wsrflite.xfire.MTOMOutHandler;
import de.fzj.unicore.wsrflite.xfire.PlainInvoker;
import de.fzj.unicore.wsrflite.xfire.USEBindingProvider;
import de.fzj.unicore.wsrflite.xfire.WSRFAddressingOutHandler;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xfire.WSRFFaultHandler;
import de.fzj.unicore.wsrflite.xfire.WSRFHandler;
import de.fzj.unicore.wsrflite.xfire.WSRFInvoker;
import de.fzj.unicore.wsrflite.xfire.security.AccessControlHandler;
import de.fzj.unicore.wsrflite.xfire.security.UASDSigDecider2;
import de.fzj.unicore.wsrflite.xfire.utils.CachingWSDLWriter;
import de.fzj.unicore.wsrflite.xfire.utils.CustomWSDLBuilder;
import de.fzj.unicore.wsrflite.xfire.utils.FinishTimeHandler;
import de.fzj.unicore.wsrflite.xfire.utils.StartTimeHandler;
import eu.unicore.security.SelfCallChecker;
import eu.unicore.security.UserAttributeHandler;
import eu.unicore.security.xfireutil.AuthInHandler;
import eu.unicore.security.xfireutil.DSigDecider;
import eu.unicore.security.xfireutil.DSigParseInHandler;
import eu.unicore.security.xfireutil.DSigSecurityInHandler;
import eu.unicore.security.xfireutil.ETDInHandler;
import eu.unicore.security.xfireutil.RequiresSignature;
import eu.unicore.security.xfireutil.client.CheckUnderstoodHeadersHandler;
import eu.unicore.security.xfireutil.client.JSR181ServiceFactory;
import eu.unicore.util.Log;
import java.lang.reflect.Method;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.addressing.AddressingInHandler;
import org.codehaus.xfire.aegis.type.TypeMappingRegistry;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.service.invoker.Invoker;
import org.codehaus.xfire.transport.DefaultTransportManager;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.codehaus.xfire.xmlbeans.XmlBeansServiceFactory;
import org.codehaus.xfire.xmlbeans.XmlBeansTypeRegistry;

public class XFireKernel {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", XFireKernel.class);
    public static final String WSRFSERVICE = "unicore.wsrflite.isWSRFservice";
    public static final String BINDING_JAXB = "jaxb";
    public static final String BINDING_XMLBEANS = "xmlbeans";
    private final Map<String, Service> services = Collections.synchronizedMap(new HashMap());
    private static final ServiceFactory defaultFactory = new JSR181ServiceFactory();
    private QName[] understoodHeaders = new QName[0];
    private boolean globalHandlersInitialized = false;
    private final List<Handler> globalInHandlers = new ArrayList<Handler>();
    private final List<Handler> globalOutHandlers = new ArrayList<Handler>();
    private final Kernel kernel;

    private XFireKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public static synchronized XFireKernel get(Kernel k) {
        XFireKernel xf = (XFireKernel)k.getAttribute(XFireKernel.class);
        if (xf == null) {
            xf = new XFireKernel(k);
            k.setAttribute(XFireKernel.class, (Object)xf);
        }
        return xf;
    }

    public synchronized Service exposeAsService(String name, Class<?> spec, Class<?> impl, ServiceFactory factory, boolean isWSRF, boolean isPersistent) throws Exception {
        ServiceFactory useFactory;
        if (isWSRF) {
            this.kernel.getContainerProperties().setProperty("unicore.wsrflite.isPersistent", isPersistent + "");
        }
        if (factory == null && (factory = XFireKernel.getFactoryFromAnnotation(impl)) == null) {
            factory = defaultFactory;
        }
        if ((useFactory = factory) instanceof XmlBeansServiceFactory) {
            ((XmlBeansServiceFactory)useFactory).setBindingProvider((BindingProvider)new USEBindingProvider((TypeMappingRegistry)new XmlBeansTypeRegistry()));
        }
        Service service = useFactory.create(spec, name, null, null);
        if (isWSRF) {
            service.setInvoker((Invoker)new WSRFInvoker(this.kernel));
            service.addInHandler((Handler)new WSRFHandler(this.kernel));
            service.setProperty(WSRFSERVICE, (Object)"true");
            service.setProperty("unicore.wsrflite.isPersistent", (Object)Boolean.toString(isPersistent));
            service.addFaultHandler((Handler)new WSRFFaultHandler());
        } else {
            service.setInvoker((Invoker)new PlainInvoker(this.kernel));
        }
        service.addFaultHandler((Handler)new WSRFAddressingOutHandler());
        service.setProperty("xfire.serviceImplClass", impl);
        this.initializeGlobalHandlers();
        this.addHandlers(service);
        service.setProperty("xmlbeans-namespace-hack", (Object)"true");
        Object tm = null;
        tm = useFactory instanceof JSR181ServiceFactory ? ((JSR181ServiceFactory)useFactory).getTransportManager() : new DefaultTransportManager();
        ServiceClassLoader scl = this.kernel.getService(name) != null ? this.kernel.getService(name).getClassLoader() : new ServiceClassLoader();
        String baseUrl = this.kernel.getContainerProperties().getValue("baseurl");
        CachingWSDLWriter wsdlWriter = new CachingWSDLWriter((WSDLWriter)new CustomWSDLBuilder(service, (TransportManager)tm, (ClassLoader)scl), baseUrl);
        service.setWSDLWriter((WSDLWriter)wsdlWriter);
        this.services.put(name, service);
        Set actions = WSRFClientFactory.getOperationsToSign(spec);
        actions.addAll(XFireKernel.getMethodsToSign(name, spec));
        this.kernel.getSecurityManager().getSignatureChecker().addSOAPActionsRequiringSignatures(actions.toArray(new String[actions.size()]));
        Map operationTypes = WSRFClientFactory.getOperationTypes(spec);
        this.kernel.getSecurityManager().getOperationTypesUtil().addService(name, operationTypes);
        XFireFactory.newInstance().getXFire().getServiceRegistry().register(service);
        return service;
    }

    public Service exposeAsService(String name, Class<?> spec, Class<?> impl, ServiceFactory factory, boolean isWSRF) throws Exception {
        return this.exposeAsService(name, spec, impl, factory, isWSRF, true);
    }

    public Service exposeAsService(String name, Class<?> spec, Class<?> impl, ServiceFactory factory) throws Exception {
        return this.exposeAsService(name, spec, impl, factory, true);
    }

    public Service exposeAsService(String name, Class<?> spec, Class<?> impl) throws Exception {
        return this.exposeAsService(name, spec, impl, null, true);
    }

    public Service exposeAsService(String name, Class<?> spec, Class<?> impl, boolean isWsrf) throws Exception {
        return this.exposeAsService(name, spec, impl, null, isWsrf);
    }

    public Service exposeAsService(String name, Class<?> spec, Class<?> impl, boolean isWsrf, boolean isPersistent) throws Exception {
        return this.exposeAsService(name, spec, impl, null, isWsrf, isPersistent);
    }

    public boolean unregisterService(String serviceName) {
        Service xfireService = this.services.remove(serviceName);
        ServiceRegistry reg = XFireFactory.newInstance().getXFire().getServiceRegistry();
        reg.unregister(xfireService);
        return !this.services.containsKey(serviceName);
    }

    public Collection<Service> getServices() {
        return this.services.values();
    }

    public Service getService(String name) {
        return this.services.get(name);
    }

    public QName[] getUnderstoodHeaders() {
        return this.understoodHeaders;
    }

    public synchronized void addUnderstoodHeaders(QName[] qn) {
        QName[] qs = new QName[this.understoodHeaders.length + qn.length];
        for (int i = 0; i < this.understoodHeaders.length; ++i) {
            qs[i] = this.understoodHeaders[i];
        }
        for (int l = 0; l < qn.length; ++l) {
            qs[this.understoodHeaders.length + l] = qn[l];
        }
        this.understoodHeaders = qs;
    }

    protected static ServiceFactory getFactoryFromAnnotation(Class<?> clazz) {
        XmlBinding annot = clazz.getAnnotation(XmlBinding.class);
        if (annot == null) {
            return null;
        }
        logger.debug((Object)("Using Xml-Java binding '" + annot.name() + "' for " + clazz.getName()));
        ServiceFactory result = null;
        if (BINDING_JAXB.equalsIgnoreCase(annot.name())) {
            try {
                result = (ServiceFactory)Class.forName("de.fzj.unicore.wsrflite.jaxb.ServiceFactory").newInstance();
            }
            catch (Exception e) {
                Log.logException((String)"Can't create service factory.", (Throwable)e, (Logger)logger);
                return null;
            }
        } else if (BINDING_XMLBEANS.equalsIgnoreCase(annot.name())) {
            result = new JSR181ServiceFactory();
        } else {
            logger.debug((Object)"No matching binding found, fallback to default xmlbeans.");
            result = new JSR181ServiceFactory();
        }
        return result;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.globalHandlersInitialized) {
            return;
        }
        this.globalHandlersInitialized = true;
        this.globalInHandlers.add((Handler)new AddressingInHandler());
        this.globalInHandlers.add((Handler)new CheckUnderstoodHeadersHandler());
        this.globalInHandlers.add((Handler)new StartTimeHandler());
        this.globalOutHandlers.add((Handler)new WSRFAddressingOutHandler());
        this.globalOutHandlers.add((Handler)new MTOMOutHandler());
        boolean checkSignatures = this.kernel.getContainerSecurityConfiguration().isSigningRequired();
        DSignCheck dsigEngine = this.kernel.getSecurityManager().getSignatureChecker();
        this.globalInHandlers.add((Handler)new DSigParseInHandler((DSigDecider)new UASDSigDecider2(dsigEngine, !checkSignatures)));
        this.globalInHandlers.add((Handler)this.createAuthInHandler());
        this.globalInHandlers.add((Handler)new DSigSecurityInHandler(null));
        this.globalInHandlers.add((Handler)new ETDInHandler((SelfCallChecker)new UASSelfCallChecker(this.kernel.getSecurityManager()), true, this.kernel.getContainerSecurityConfiguration().getETDValidator()));
        this.globalInHandlers.add((Handler)new MTOMInHandler());
        this.globalInHandlers.add((Handler)new AccessControlHandler(this.kernel));
    }

    private synchronized void addHandlers(Service service) {
        for (Handler handler : this.globalOutHandlers) {
            service.addOutHandler(handler);
        }
        service.addOutHandler((Handler)new FinishTimeHandler(service.getSimpleName()));
        for (Handler handler : this.globalInHandlers) {
            service.addInHandler(handler);
        }
    }

    private AuthInHandler createAuthInHandler() {
        IContainerSecurityConfiguration secCfg = this.kernel.getContainerSecurityConfiguration();
        boolean useGwAssertions = secCfg.isGatewayAuthnEnabled();
        boolean verifyConsignor = false;
        X509Certificate gatewayCert = null;
        if (useGwAssertions && (verifyConsignor = secCfg.isGatewaySignatureCheckingEnabled())) {
            gatewayCert = secCfg.getGatewayCertificate();
        }
        if (!verifyConsignor) {
            gatewayCert = null;
        }
        AuthInHandler h = new AuthInHandler(useGwAssertions, true, false, gatewayCert);
        h.addUserAttributeHandler((UserAttributeHandler)new UserAttributeCallback());
        return h;
    }

    public synchronized void addGlobalInHandler(Handler handler) {
        this.addGlobalInHandler(handler, false);
    }

    public synchronized void addGlobalInHandler(Handler handler, boolean onlyIfNew) {
        if (onlyIfNew) {
            for (Handler h : this.globalInHandlers) {
                if (!handler.getClass().equals(h.getClass())) continue;
                return;
            }
        }
        this.globalInHandlers.add(handler);
        Collection<Service> servicesCollection = this.services.values();
        for (Service service : servicesCollection) {
            service.addInHandler(handler);
        }
    }

    public synchronized void addGlobalOutHandler(Handler handler) {
        this.addGlobalInHandler(handler, false);
    }

    public synchronized void addGlobalOutHandler(Handler handler, boolean onlyIfNew) {
        if (onlyIfNew) {
            for (Handler h : this.globalOutHandlers) {
                if (!handler.getClass().equals(h.getClass())) continue;
                return;
            }
        }
        this.globalOutHandlers.add(handler);
        Collection<Service> servicesCollection = this.services.values();
        for (Service service : servicesCollection) {
            service.addOutHandler(handler);
        }
    }

    private static <T> Set<String> getMethodsToSign(String serviceName, Class<T> iFace) {
        Method[] methods;
        HashSet<String> opsToSign = new HashSet<String>();
        for (Method m : methods = iFace.getMethods()) {
            if (m.getAnnotation(RequiresSignature.class) == null) continue;
            opsToSign.add(serviceName + "." + m.getName());
        }
        return opsToSign;
    }
}

