/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import de.fzj.unicore.metrix.IMetric;
import de.fzj.unicore.metrix.MetricRegistry;
import de.fzj.unicore.metrix.exceptions.MetricIDAlreadyExistsException;
import de.fzj.unicore.metrix.metrics.MeanFloatValue;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.messaging.MessagingException;
import de.fzj.unicore.wsrflite.messaging.PullPoint;
import de.fzj.unicore.wsrflite.security.SecurityManager;
import de.fzj.unicore.wsrflite.security.util.AuthZAttributeStore;
import eu.unicore.util.Log;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.invoker.AbstractInvoker;
import org.codehaus.xfire.transport.http.XFireServletController;

public class WSRFInvoker
extends AbstractInvoker {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite", WSRFInvoker.class);
    public static final String KEY = WSRFInvoker.class.getName() + "KEY";
    private static final String METHODKEY = WSRFInvoker.class.getName() + "METHOD";
    public static final String LOCKEDKEY = WSRFInvoker.class.getName() + "LOCKED";
    private static final String CLEANUPKEY = WSRFInvoker.class.getName() + "CLEANUP";
    private final MeanFloatValue meanProcessingTime;
    private final Kernel kernel;

    public WSRFInvoker(Kernel kernel) {
        this.kernel = kernel;
        this.meanProcessingTime = new MeanFloatValue("wsrf.service.processingtime", "ms.", new String[]{"performance", "webservices"});
        try {
            MetricRegistry.getInstance().registerMetric((IMetric)this.meanProcessingTime);
        }
        catch (MetricIDAlreadyExistsException me) {
            throw new IllegalStateException(me);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getServiceObject(MessageContext context) throws XFireFault {
        Resource serviceObject = (Resource)context.getProperty(KEY);
        serviceObject.postActivate();
        boolean hasMessages = false;
        String id = serviceObject.getUniqueID();
        try {
            hasMessages = this.kernel.getMessaging().hasMessages(id);
        }
        catch (MessagingException e) {
            Log.logException((String)("Error getting messages for " + id), (Throwable)e, (Logger)logger);
        }
        if (hasMessages) {
            PullPoint pp = null;
            try {
                pp = this.kernel.getMessaging().getPullPoint(id);
                serviceObject.processMessages(pp);
            }
            catch (Exception e) {
            }
            finally {
                if (pp != null) {
                    pp.dispose();
                }
            }
        }
        return serviceObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Method method, Object[] params, MessageContext ctx) throws XFireFault {
        Object object;
        block10: {
            long start = System.currentTimeMillis();
            ctx.setProperty(METHODKEY, (Object)method.getName());
            try {
                boolean local;
                boolean bl = local = XFireServletController.getRequest() == null;
                if (local) {
                    SecurityManager.setLocalCall();
                }
                object = super.invoke(method, params, ctx);
                this.cleanUp(ctx);
                if (this.isLocalCall(ctx)) break block10;
            }
            catch (Throwable throwable) {
                this.cleanUp(ctx);
                if (!this.isLocalCall(ctx)) {
                    long duration = System.currentTimeMillis() - start;
                    WSRFInvoker wSRFInvoker = this;
                    synchronized (wSRFInvoker) {
                        this.meanProcessingTime.push((Object[])new Float[]{Float.valueOf(duration)});
                    }
                }
                throw throwable;
            }
            long duration = System.currentTimeMillis() - start;
            WSRFInvoker wSRFInvoker = this;
            synchronized (wSRFInvoker) {
                this.meanProcessingTime.push((Object[])new Float[]{Float.valueOf(duration)});
            }
        }
        return object;
    }

    private boolean isLocalCall(MessageContext ctx) {
        String s = ctx.getInMessage().getChannel().getUri();
        return s != null && s.startsWith("xfire.local");
    }

    public void cleanUp(MessageContext ctx) {
        if (ctx.getProperty(CLEANUPKEY) != null) {
            return;
        }
        SecurityManager.clearLocalCall();
        boolean locked = Boolean.TRUE.equals(ctx.getProperty(LOCKEDKEY));
        Log.cleanLogContext();
        Resource serviceInstance = (Resource)ctx.getProperty(KEY);
        AuthZAttributeStore.clear();
        if (serviceInstance != null) {
            try {
                if (locked) {
                    if (serviceInstance.isDestroyed()) {
                        String serviceName = serviceInstance.getServiceName();
                        this.kernel.getPersistenceManager().getPersist(serviceName).unlock(serviceInstance);
                    } else {
                        this.kernel.getPersistenceManager().persist(serviceInstance);
                    }
                    ctx.setProperty(LOCKEDKEY, (Object)Boolean.FALSE);
                }
            }
            catch (Exception e) {
                Log.logException((String)("Could not persist service instance {" + serviceInstance.getServiceName() + "}" + serviceInstance.getUniqueID()), (Throwable)e, (Logger)logger);
            }
            ctx.setProperty(CLEANUPKEY, (Object)Boolean.TRUE);
        }
    }
}

