/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.Resource;
import de.fzj.unicore.wsrflite.Service;
import de.fzj.unicore.wsrflite.admin.ResourceAvailability;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnavailableException;
import de.fzj.unicore.wsrflite.exceptions.ResourceUnknownException;
import de.fzj.unicore.wsrflite.persistence.PersistenceSettings;
import de.fzj.unicore.wsrflite.xfire.WSRFInvoker;
import de.fzj.unicore.wsrflite.xfire.security.AccessControlHandler;
import java.lang.reflect.Method;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;

public class WSRFHandler
extends AbstractHandler {
    private final Kernel kernel;

    public WSRFHandler(Kernel kernel) {
        this.kernel = kernel;
        this.setPhase("pre-invoke");
        this.before(AccessControlHandler.class.getName());
    }

    public void invoke(MessageContext ctx) throws Exception {
        org.codehaus.xfire.service.Service xfireService = ctx.getService();
        String serviceName = xfireService.getName().getLocalPart();
        Service service = this.kernel.getService(serviceName);
        if (service == null) {
            throw new XFireFault((Throwable)new ResourceUnknownException("The requested service '" + serviceName + "' does not exist."));
        }
        Object serviceObject = this.setupServiceObject(ctx);
        ctx.setProperty(WSRFInvoker.KEY, serviceObject);
    }

    public Object setupServiceObject(MessageContext context) throws XFireFault {
        Resource serviceObject;
        org.codehaus.xfire.service.Service service = context.getService();
        String serviceName = service.getName().getLocalPart();
        Home homeObject = this.kernel.getHome(serviceName);
        if (homeObject == null) {
            throw new XFireFault((Throwable)new ResourceUnknownException("The requested service '" + serviceName + "' does not exist."));
        }
        String id = null;
        try {
            id = homeObject.extractServiceReference((Object)context);
            serviceObject = homeObject.get(id);
            serviceObject.setKernel(this.kernel);
            if (ResourceAvailability.isUnavailable((String)id)) {
                throw new ResourceUnavailableException("Resource <" + id + "> has been temporarily disabled by an administrator.");
            }
            Method method = context.getExchange().getOperation().getMethod();
            PersistenceSettings ps = this.kernel.getPersistenceManager().getPersistenceSettings(serviceObject.getClass());
            if (!ps.isConcurrentMethod(method)) {
                context.setProperty(WSRFInvoker.LOCKEDKEY, (Object)Boolean.TRUE);
                serviceObject = homeObject.getForUpdate(id);
            }
        }
        catch (ResourceUnknownException ruf) {
            throw new XFireFault((Throwable)homeObject.getFaultConverter().convert((Exception)((Object)ruf)));
        }
        catch (ResourceUnavailableException rua) {
            throw new XFireFault((Throwable)homeObject.getFaultConverter().convert((Exception)((Object)rua)));
        }
        catch (PersistenceException pe) {
            throw new XFireFault((Throwable)homeObject.getFaultConverter().convert((Exception)((Object)new ResourceUnavailableException("Internal server problem, please consult the system adminstrator", (Throwable)pe))));
        }
        return serviceObject;
    }
}

