/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.xfire;

import de.fzj.unicore.wsrflite.security.TestConfigUtil;
import de.fzj.unicore.wsrflite.server.JettyServer;
import de.fzj.unicore.wsrflite.xfire.LocalTestCase;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Properties;

public abstract class JettyTestCase
extends LocalTestCase {
    protected JettyServer server;

    @Override
    protected void setUp() throws Exception {
        Properties properties = this.getServerSideSecurityProperties();
        properties.setProperty("persistence.directory", "target/data-" + System.currentTimeMillis());
        properties.setProperty("container.host", "localhost");
        properties.setProperty("container.port", "" + this.getPort());
        if (this.getBaseurl() != null) {
            properties.setProperty("container.baseurl", this.getBaseurl());
        }
        super.init(properties);
        this.server = this.kernel.getServer();
        this.kernel.startSynchronous();
    }

    protected int getPort() {
        return 65321;
    }

    protected IClientConfiguration getClientSideSecurityProperties() throws Exception {
        return new DefaultClientConfiguration();
    }

    protected Properties getServerSideSecurityProperties() throws Exception {
        return TestConfigUtil.getInsecureProperties();
    }

    @Override
    protected String getBaseurl() {
        return "http://localhost:" + this.getPort() + "/services";
    }

    protected void tearDown() throws Exception {
        this.kernel.shutdown();
    }
}

