/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite.utils;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import javax.xml.namespace.QName;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class WSServerUtilities
extends WSUtilities {
    private WSServerUtilities() {
    }

    public static EndpointReferenceType newEPR(IContainerSecurityConfiguration secCfg) {
        return WSServerUtilities.newEPR(true, secCfg);
    }

    public static EndpointReferenceType newEPR(boolean addServerID, IContainerSecurityConfiguration secCfg) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        if (addServerID && secCfg.isSslEnabled()) {
            try {
                String serverDN = secCfg.getCredential().getCertificate().getSubjectX500Principal().getName();
                WSServerUtilities.addServerIdentity((EndpointReferenceType)epr, (String)serverDN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return epr;
    }

    public static String makeAddress(String serviceName, String resourceID, ContainerProperties cfg) {
        return WSServerUtilities.makeServiceAddress((String)WSServerUtilities.makeAddress(serviceName, cfg), (String)resourceID);
    }

    public static String makeAddress(String serviceName, ContainerProperties cfg) {
        return cfg.getBaseUrl() + "/" + serviceName;
    }

    public static EndpointReferenceType makeEPR(String serviceName, String resourceID, Kernel kernel) {
        EndpointReferenceType epr = WSServerUtilities.newEPR(kernel.getContainerSecurityConfiguration());
        epr.addNewAddress().setStringValue(WSServerUtilities.makeAddress(serviceName, resourceID, kernel.getContainerProperties()));
        return epr;
    }

    public static EndpointReferenceType makeEPR(String serviceName, Kernel kernel) {
        return WSServerUtilities.makeEPR(serviceName, true, kernel);
    }

    public static EndpointReferenceType makeEPR(String serviceName, boolean addServerID, Kernel kernel) {
        EndpointReferenceType epr = WSServerUtilities.newEPR(addServerID, kernel.getContainerSecurityConfiguration());
        epr.addNewAddress().setStringValue(WSServerUtilities.makeAddress(serviceName, kernel.getContainerProperties()));
        return epr;
    }

    public static EndpointReferenceType makeEPR(String serviceName, String resourceID, QName portType, Kernel kernel) {
        EndpointReferenceType epr = WSServerUtilities.makeEPR(serviceName, resourceID, kernel);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr, (String)resourceID);
        WSServerUtilities.addPortType((EndpointReferenceType)epr, (QName)portType);
        return epr;
    }

    public static EndpointReferenceType makeEPR(String serviceName, String resourceID, QName portType, boolean addServerID, Kernel kernel) {
        EndpointReferenceType epr = WSServerUtilities.newEPR(addServerID, kernel.getContainerSecurityConfiguration());
        epr.addNewAddress().setStringValue(WSServerUtilities.makeAddress(serviceName, resourceID, kernel.getContainerProperties()));
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr, (String)resourceID);
        WSServerUtilities.addPortType((EndpointReferenceType)epr, (QName)portType);
        return epr;
    }

    public static EndpointReferenceType makeEPR(String serviceName, QName portType, Kernel kernel) {
        EndpointReferenceType epr = WSServerUtilities.makeEPR(serviceName, kernel);
        WSServerUtilities.addPortType((EndpointReferenceType)epr, (QName)portType);
        return epr;
    }
}

