/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.wsrflite;

import de.fzj.unicore.wsrflite.AbstractStartupTask;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Home;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.admin.WSRFAdmin;
import de.fzj.unicore.wsrflite.impl.DefaultHome;
import de.fzj.unicore.wsrflite.xmlbeans.registry.MulticastRegistryAdvertiser;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryCreator;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import de.fzj.unicore.wsrflite.xmlbeans.registry.VORegistries;
import eu.unicore.util.Log;
import org.apache.log4j.Logger;

public class WSRFStartupTask
extends AbstractStartupTask {
    private static final Logger logger = Log.getLogger((String)"unicore", WSRFStartupTask.class);

    public void run() throws Exception {
        Kernel kernel = this.getKernel();
        RegistryCreator registryCreator = new RegistryCreator(kernel);
        kernel.setAttribute(RegistryCreator.class, (Object)registryCreator);
        registryCreator.createRegistry();
        RegistryHandler registryHandler = new RegistryHandler(kernel);
        kernel.setAttribute(RegistryHandler.class, (Object)registryHandler);
        VORegistries extraRegistries = new VORegistries(kernel);
        kernel.setAttribute(VORegistries.class, (Object)extraRegistries);
        ContainerProperties conf = this.getKernel().getContainerProperties();
        if (registryCreator.isGlobalRegistry() && conf.getBooleanValue("registry.globalAdvertise").booleanValue()) {
            logger.info((Object)"Advertising global registry via multicast!");
            MulticastRegistryAdvertiser rma = new MulticastRegistryAdvertiser(this.getKernel());
            rma.run();
        }
        if (!registryCreator.isGlobalRegistry()) {
            this.forceRefreshRegistryEntries();
        }
        WSRFAdmin jmx = new WSRFAdmin(kernel);
        Kernel.addMBean((Object)jmx, (String)("UNICORE WSRF Services Environment " + kernel.hashCode()));
    }

    private void forceRefreshRegistryEntries() {
        try {
            Home home = this.getKernel().getHome("ServiceGroupEntry");
            if (home != null && home instanceof DefaultHome) {
                ((DefaultHome)home).runExpiryCheckNow();
            }
        }
        catch (Exception ex) {
            Log.logException((String)"Error running expiry checks for <ServiceGroupEntry>", (Throwable)ex, (Logger)logger);
        }
    }
}

