/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.emir.unicore;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import de.fzj.unicore.cisprovider.CISInfoProvider;
import de.fzj.unicore.uas.StorageManagement;
import de.fzj.unicore.uas.TargetSystemFactory;
import eu.emi.emir.client.EMIRClient;
import eu.emi.emir.client.glue2.XmlbeansToJson;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.oasisOpen.docs.wsrf.sg2.ContentType;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class EMIRegistryAddClient {
    private static final Logger logger = Log.getLogger((String)"EMIR-UNICORE", EMIRegistryAddClient.class);
    private final EMIRClient client;
    private final WebResource clientRes;
    private static final StringBuilder query = new StringBuilder();
    private static final Map<QName, String> serviceCapabilities;
    private static final String unknown = "[unknown]";

    public EMIRegistryAddClient(EndpointReferenceType epr, IClientConfiguration securityConfig) {
        if (securityConfig == null) {
            NullPointerException npe = new NullPointerException();
            Log.logException((String)"Failed to instantiate EMIRegistryClient: Security configuration cannot be NULL", (Throwable)npe);
            throw npe;
        }
        this.client = new EMIRClient(epr.getAddress().getStringValue(), securityConfig);
        this.clientRes = this.client.getClientResource();
    }

    public EMIRegistryAddClient(EndpointReferenceType epr) {
        this.client = new EMIRClient(epr.getAddress().getStringValue());
        this.clientRes = this.client.getClientResource();
    }

    public static String getServiceCapabilities(QName iName) {
        String jsonCapabilities = serviceCapabilities.get(iName);
        if (jsonCapabilities == null) {
            jsonCapabilities = unknown;
        }
        return jsonCapabilities;
    }

    public void addRegistryEntry(ServiceT service) {
        if (service == null) {
            throw new IllegalArgumentException("Null Glue 2.0 service parameter");
        }
        JSONArray jarr = null;
        try {
            jarr = XmlbeansToJson.convert((ServiceT)service);
        }
        catch (JSONException e1) {
            Log.logException((String)("Error converting JSON from Glue service: " + service.toString()), (Throwable)e1, (Logger)logger);
        }
        this.addRegistryEntry(jarr);
    }

    public void addRegistryEntry(JSONArray json) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Publishing unicore/x entries to EMIR: " + json.toString()));
        }
        try {
            WebResource serviceAdmin = this.clientRes.path("/serviceadmin");
            ClientResponse res = (ClientResponse)serviceAdmin.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(ClientResponse.class, (Object)json);
            JSONArray resJson = (JSONArray)res.getEntity(JSONArray.class);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Succesfully published unicore/x entries to EMIR: " + resJson.toString(2)));
            }
        }
        catch (Exception e) {
            Log.logException((String)"registration to EMIR failed", (Throwable)e, (Logger)logger);
        }
    }

    static {
        query.append("declare namespace spec='" + ServiceT.type.getName().getNamespaceURI() + "';");
        query.append("declare namespace sg='" + ContentType.type.getName().getNamespaceURI() + "';");
        query.append("//spec:Service");
        serviceCapabilities = new HashMap<QName, String>();
        serviceCapabilities.put(TargetSystemFactory.TSF_PORT, "[executionmanagement.executionservicecreation]");
        serviceCapabilities.put(StorageManagement.SMS_PORT, "[storage.dataaccess]");
        serviceCapabilities.put(new QName("http://schemas.ggf.org/bes/2006/08/bes-factory", "BESFactoryPortType"), "[executionmanagement.jobdescription,executionmanagement.jobexecution,executionmanagement.jobmanager]");
        serviceCapabilities.put(CISInfoProvider.PORTTYPE, "[information.discovery.resource]");
    }
}

