/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.request.profile;

import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.pdp.request.creator.XACMLAttributeMeta;
import eu.unicore.uas.pdp.request.profile.XACMLProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class XACMLProfileBase
implements XACMLProfile {
    protected Map<String, XACMLAttributeMeta> attributes;
    protected Set<String> reservedAttrName;
    protected String siteUrl;

    public XACMLProfileBase(String siteUrl) {
        this.siteUrl = siteUrl;
        this.attributes = new HashMap<String, XACMLAttributeMeta>();
        this.reservedAttrName = new HashSet<String>();
        this.addAttributeDef(new XACMLAttributeMeta(XACMLAttribute.Name.XACML_SUBJECT_ID_ATTR.toString(), XACMLAttribute.Type.X500NAME.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Subject));
        this.addAttributeDef(new XACMLAttributeMeta(XACMLAttribute.Name.XACML_ACTION_ID_ATTR.toString(), XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Action));
    }

    @Override
    public boolean checkAttr(String attrName) {
        return !this.attributes.keySet().contains(attrName);
    }

    @Override
    public List<XACMLAttributeMeta> getByCategory(XACMLAttributeMeta.XACMLAttributeCategory c) {
        ArrayList<XACMLAttributeMeta> res = new ArrayList<XACMLAttributeMeta>();
        for (XACMLAttributeMeta a : this.attributes.values()) {
            if (!a.getCategory().equals((Object)c)) continue;
            res.add(a);
        }
        Collections.sort(res);
        return res;
    }

    public void initReservedAttr() {
        for (XACMLAttributeMeta a : this.attributes.values()) {
            this.reservedAttrName.add(a.getName());
        }
    }

    protected void addAttributeDef(XACMLAttributeMeta attributeMetadata) {
        XACMLAttributeMeta old = this.attributes.put(attributeMetadata.getName(), attributeMetadata);
        if (old != null) {
            throw new RuntimeException("BUG! Adding attribute type twice with the same name: " + attributeMetadata);
        }
    }

    @Override
    public String getServiceUrl() {
        return this.siteUrl;
    }
}

