/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.request.profile;

import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import eu.unicore.security.Client;
import eu.unicore.security.OperationType;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.pdp.request.creator.XACMLAttributeMeta;
import eu.unicore.uas.pdp.request.profile.XACMLProfileBase;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnicoreInternalProfile
extends XACMLProfileBase {
    public static final String ATTR_SUBJECT_CONSIGNOR_XACML_ID = "consignor";
    public static final String ATTR_VO_XACML_ID = "vo";
    public static final String ATTR_ROLE_XACML_ID = "role";
    public static final String ATTR_RESOURCE_OWNER_XACML_ID = "owner";
    public static final String ATTR_WSR_XACML_ID = "urn:unicore:wsresource";
    public static final String ATTR_SELECTED_VO_XACML_ID = "selectedVo";
    public static final String ATTR_ACTION_TYPE_ID = "actionType";
    public static final String ATTR_VO_MEMBERSHIP_PFX_XACML_ID = "voMembership-";
    public static final String VOLESS_USER_VALUE = "NOT_A_VO_BOUND_REQUEST";

    public UnicoreInternalProfile(String serviceUrl) {
        super(serviceUrl);
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_SUBJECT_CONSIGNOR_XACML_ID, XACMLAttribute.Type.X500NAME.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Subject));
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_VO_XACML_ID, XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Subject));
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_SELECTED_VO_XACML_ID, XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Subject));
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_ROLE_XACML_ID, XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Subject));
        this.addAttributeDef(new XACMLAttributeMeta(XACMLAttribute.Name.XACML_RESOURCE_ID_ATTR.toString(), XACMLAttribute.Type.ANYURI.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Resource));
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_RESOURCE_OWNER_XACML_ID, XACMLAttribute.Type.X500NAME.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Resource));
        for (OperationType type : OperationType.values()) {
            this.addAttributeDef(new XACMLAttributeMeta(ATTR_VO_MEMBERSHIP_PFX_XACML_ID + type.toString(), XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Resource));
        }
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_WSR_XACML_ID, XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Resource));
        this.addAttributeDef(new XACMLAttributeMeta(ATTR_ACTION_TYPE_ID, XACMLAttribute.Type.STRING.toString(), XACMLAttributeMeta.XACMLAttributeCategory.Action));
    }

    @Override
    public List<String> getValue(XACMLAttributeMeta attribute, Client c, ActionDescriptor action, ResourceDescriptor des) {
        ArrayList<String> res = new ArrayList<String>();
        String attrName = attribute.getName();
        if (attrName.equals(ATTR_SUBJECT_CONSIGNOR_XACML_ID)) {
            X509Certificate consignorCert = c.getSecurityTokens().getConsignorCertificate();
            if (consignorCert != null) {
                res.add(consignorCert.getSubjectX500Principal().getName());
            }
        } else if (attrName.equals(ATTR_VO_XACML_ID)) {
            String[] vos = c.getVos();
            if (vos != null) {
                for (String v : vos) {
                    res.add(v);
                }
            }
        } else if (attrName.equals(ATTR_SELECTED_VO_XACML_ID)) {
            String vo = c.getVo();
            if (vo != null) {
                res.add(vo);
            } else {
                res.add(VOLESS_USER_VALUE);
            }
        } else if (attrName.equals(ATTR_ROLE_XACML_ID)) {
            String role = c.getRole().getName();
            if (role != null) {
                res.add(c.getRole().getName());
            }
        } else if (attrName.equals(XACMLAttribute.Name.XACML_RESOURCE_ID_ATTR.toString())) {
            String s = des.getServiceName();
            if (s != null) {
                res.add(des.getServiceName());
            }
        } else if (attrName.equals(ATTR_RESOURCE_OWNER_XACML_ID)) {
            String n = des.getOwner();
            if (n != null) {
                res.add(n);
            }
        } else if (attrName.startsWith(ATTR_VO_MEMBERSHIP_PFX_XACML_ID)) {
            String typeS = attrName.substring(ATTR_VO_MEMBERSHIP_PFX_XACML_ID.length());
            OperationType type = OperationType.valueOf((String)typeS);
            Map voMembership = des.getVoMembership();
            for (String key : voMembership.keySet()) {
                if (!((Set)voMembership.get(key)).contains(type)) continue;
                res.add(key);
            }
        } else if (attrName.equals(ATTR_WSR_XACML_ID)) {
            String r = des.getResourceID();
            if (r != null) {
                res.add(r);
            }
        } else if (attrName.equals(XACMLAttribute.Name.XACML_SUBJECT_ID_ATTR.toString())) {
            String name = c.getDistinguishedName();
            if (name != null) {
                res.add(name);
            }
        } else if (attrName.equals(XACMLAttribute.Name.XACML_ACTION_ID_ATTR.toString())) {
            if (action != null && action.getAction() != null) {
                res.add(action.getAction());
            } else {
                res.add("___ANY_ACTION___");
            }
        } else if (attrName.equals(ATTR_ACTION_TYPE_ID)) {
            if (action != null) {
                res.add(action.getActionType() != null ? action.getActionType().toString() : OperationType.modify.toString());
            }
        } else {
            throw new RuntimeException("BUG! got request about attribute for which we don't have value generator: " + attribute);
        }
        return res;
    }
}

