/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.request.creator;

import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StandardAttributeFactory;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import eu.unicore.security.Client;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.pdp.request.creator.RequestCreatorBase;
import eu.unicore.uas.pdp.request.creator.XACMLAttributeMeta;
import eu.unicore.uas.pdp.request.profile.XACMLProfile;
import eu.unicore.util.Log;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class SunXacml1RequestCreator
extends RequestCreatorBase {
    private static final Logger log = Log.getLogger((String)"unicore.security", SunXacml1RequestCreator.class);

    public SunXacml1RequestCreator(XACMLProfile p) {
        super(p);
    }

    public RequestCtx createRequest(Client c, ActionDescriptor action, ResourceDescriptor des) throws Exception {
        this.validateClient(c);
        HashSet<Subject> subjects = new HashSet<Subject>();
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        this.addAttr(attributes, XACMLAttributeMeta.XACMLAttributeCategory.Subject, c, action, des);
        this.addAttributesFromPips(attributes, c);
        subjects.add(new Subject(attributes));
        HashSet<Attribute> act = new HashSet<Attribute>();
        this.addAttr(act, XACMLAttributeMeta.XACMLAttributeCategory.Action, c, action, des);
        HashSet<Attribute> resource = new HashSet<Attribute>();
        this.addAttr(resource, XACMLAttributeMeta.XACMLAttributeCategory.Resource, c, action, des);
        return new RequestCtx(subjects, resource, act, new HashSet());
    }

    private synchronized void addAttributesFromPips(HashSet<Attribute> attributes, Client client) {
        StandardAttributeFactory attrFactory = StandardAttributeFactory.getFactory();
        for (XACMLAttribute a : client.getSubjectAttributes().getXacmlAttributes()) {
            if (!this.profile.checkAttr(a.getName())) {
                log.warn((Object)("Among clients GENERIC XACML attributes retrieved from the configured attribute sources, the special attribute " + a.getName() + " was found. Ignoring it."));
                continue;
            }
            try {
                AttributeValue val = attrFactory.createValue(new URI(a.getType().toString()), a.getValue());
                Attribute toAdd = new Attribute(new URI(a.getName()), null, null, val);
                attributes.add(toAdd);
            }
            catch (Exception e) {
                log.warn((Object)"Can't convert supplied XACML attribtue into Sun's XACML attribtue, skipping it", (Throwable)e);
            }
        }
    }

    private void addAttr(HashSet<Attribute> attributes, XACMLAttributeMeta.XACMLAttributeCategory cat, Client c, ActionDescriptor action, ResourceDescriptor des) throws URISyntaxException, UnknownIdentifierException, ParsingException {
        StandardAttributeFactory attrFactory = StandardAttributeFactory.getFactory();
        for (XACMLAttributeMeta a : this.profile.getByCategory(cat)) {
            for (String v : this.profile.getValue(a, c, action, des)) {
                AttributeValue val = attrFactory.createValue(new URI(a.getType().toString()), v);
                Attribute toAdd = new Attribute(new URI(a.getName()), null, null, val);
                attributes.add(toAdd);
            }
        }
    }
}

