/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.request.creator;

import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import eu.unicore.security.Client;
import eu.unicore.security.XACMLAttribute;
import eu.unicore.uas.pdp.request.creator.RequestCreatorBase;
import eu.unicore.uas.pdp.request.creator.XACMLAttributeMeta;
import eu.unicore.uas.pdp.request.profile.XACMLProfile;
import eu.unicore.util.Log;
import java.util.List;
import org.apache.log4j.Logger;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.impl.ActionType;
import org.herasaf.xacml.core.context.impl.AttributeType;
import org.herasaf.xacml.core.context.impl.AttributeValueType;
import org.herasaf.xacml.core.context.impl.EnvironmentType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.context.impl.ResourceType;
import org.herasaf.xacml.core.context.impl.SubjectType;
import org.herasaf.xacml.core.converter.URNToDataTypeConverter;

public class HerasafXacml2RequestCreator
extends RequestCreatorBase {
    private static final Logger log = Log.getLogger((String)"unicore.security", HerasafXacml2RequestCreator.class);

    public HerasafXacml2RequestCreator(XACMLProfile p) {
        super(p);
    }

    public RequestCtx createRequest(Client c, ActionDescriptor action, ResourceDescriptor des) {
        this.validateClient(c);
        RequestType req = new RequestType();
        List subjects = req.getSubjects();
        SubjectType subject = new SubjectType();
        subjects.add(subject);
        List subjectAttrs = subject.getAttributes();
        this.setAttrList(subjectAttrs, XACMLAttributeMeta.XACMLAttributeCategory.Subject, c, action, des);
        String warn = this.addHeresafAttributesFromAIPs(c, subjectAttrs);
        if (warn.length() != 0) {
            log.warn((Object)warn);
        }
        List resources = req.getResources();
        ResourceType resource = new ResourceType();
        resources.add(resource);
        List resourceAttrs = resource.getAttributes();
        this.setAttrList(resourceAttrs, XACMLAttributeMeta.XACMLAttributeCategory.Resource, c, action, des);
        ActionType xacmlAction = new ActionType();
        List actionAttrs = xacmlAction.getAttributes();
        this.setAttrList(actionAttrs, XACMLAttributeMeta.XACMLAttributeCategory.Action, c, action, des);
        req.setAction(xacmlAction);
        EnvironmentType env = new EnvironmentType();
        List envAttrs = env.getAttributes();
        this.setAttrList(envAttrs, XACMLAttributeMeta.XACMLAttributeCategory.Environment, c, action, des);
        req.setEnvironment(env);
        RequestCtx ret = new RequestCtx(req);
        return ret;
    }

    public void setAttrList(List<AttributeType> attrs, XACMLAttributeMeta.XACMLAttributeCategory cat, Client c, ActionDescriptor action, ResourceDescriptor des) {
        for (XACMLAttributeMeta a : this.profile.getByCategory(cat)) {
            for (String v : this.profile.getValue(a, c, action, des)) {
                attrs.add(this.getHerasafAttribute(a, v));
            }
        }
    }

    public AttributeType getHerasafAttribute(XACMLAttributeMeta xacmlAttribute, String value) {
        AttributeType attribute = new AttributeType();
        URNToDataTypeConverter converter = new URNToDataTypeConverter();
        attribute.setAttributeId(xacmlAttribute.getName());
        attribute.setDataType(converter.unmarshal(xacmlAttribute.getType()));
        AttributeValueType avalue = new AttributeValueType();
        avalue.getContent().add(value);
        attribute.getAttributeValues().add(avalue);
        return attribute;
    }

    public String addHeresafAttributesFromAIPs(Client client, List<AttributeType> subjectAttrs) {
        StringBuilder warn = new StringBuilder();
        for (XACMLAttribute attr : client.getSubjectAttributes().getXacmlAttributes()) {
            if (!this.profile.checkAttr(attr.getName())) {
                warn.append("Among clients GENERIC XACML attributes retrieved from the configured attribute sources, the special attribute " + attr.getName() + " was found. Ignoring it.\n");
                continue;
            }
            AttributeType herasfAttribute = this.getHerasafAttribute(new XACMLAttributeMeta(attr.getName(), attr.getType().toString(), XACMLAttributeMeta.XACMLAttributeCategory.Subject), attr.getValue());
            subjectAttrs.add(herasfAttribute);
        }
        return warn.toString();
    }
}

