/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.localsun;

import com.sun.xacml.ConfigurationStore;
import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.ThreadingServices;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.pdp.PDPResult;
import de.fzj.unicore.wsrflite.security.pdp.UnicoreXPDP;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import de.fzj.unicore.wsrflite.utils.FileWatcher;
import eu.unicore.security.Client;
import eu.unicore.uas.pdp.request.creator.SunXacml1RequestCreator;
import eu.unicore.uas.pdp.request.profile.UnicoreInternalProfile;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public class LocalSunPDP
implements UnicoreXPDP {
    private static final Logger log = Log.getLogger((String)"unicore.security", LocalSunPDP.class);
    private String configurationFile;
    private long lastModified = 0L;
    private PDP pdp;
    private SunXacml1RequestCreator requestBuilder;
    private ReentrantReadWriteLock policyLock;
    private ThreadingServices threadingSrv;

    public void initialize(String configuration, ContainerProperties baseSettings, IContainerSecurityConfiguration securityConfiguration, IClientConfiguration clientConfiguration) throws Exception {
        if (configuration == null) {
            throw new ConfigurationException("For " + LocalSunPDP.class.getName() + " PDP a configuration file must be defined.");
        }
        String baseURL = baseSettings.getValue("baseurl");
        ThreadingServices ts = baseSettings.getThreadingServices();
        this.initialize(configuration, baseURL, ts, 5000);
    }

    public void initialize(String configuration, String baseURL, ThreadingServices ts, int scanTime) throws IOException, ParsingException, UnknownIdentifierException {
        this.configurationFile = configuration;
        this.threadingSrv = ts;
        log.info((Object)("Initialising Local Sun XACML 1.1 PDP using config file " + this.configurationFile));
        this.policyLock = new ReentrantReadWriteLock();
        this.load();
        this.requestBuilder = new SunXacml1RequestCreator(new UnicoreInternalProfile(baseURL));
        this.startConfigWatcher(scanTime);
    }

    public PDPResult checkAuthorisation(Client c, ActionDescriptor action, ResourceDescriptor d) throws Exception {
        Set results;
        ByteArrayOutputStream bos;
        RequestCtx request = this.requestBuilder.createRequest(c, action, d);
        if (log.isDebugEnabled()) {
            bos = new ByteArrayOutputStream();
            request.encode((OutputStream)bos, new Indenter());
            log.debug((Object)("XACML request:\n" + bos.toString()));
        }
        this.policyLock.readLock().lock();
        ResponseCtx response = this.pdp.evaluate(request);
        this.policyLock.readLock().unlock();
        if (log.isDebugEnabled()) {
            bos = new ByteArrayOutputStream();
            response.encode((OutputStream)bos, new Indenter());
            log.debug((Object)("XACML response:\n" + bos.toString()));
        }
        if ((results = response.getResults()).size() != 1) {
            throw new Exception("XACML PDP returned more than one result.");
        }
        Result r = (Result)results.iterator().next();
        return this.convertResult(r);
    }

    private PDPResult convertResult(Result orig) {
        PDPResult.Decision decision;
        String desc = "Access denied";
        if (orig.getDecision() == 1) {
            decision = PDPResult.Decision.DENY;
        } else if (orig.getDecision() == 0) {
            decision = PDPResult.Decision.PERMIT;
            desc = "OK";
        } else {
            decision = PDPResult.Decision.UNCLEAR;
            desc = "Probelm in policy evaluation";
        }
        return new PDPResult(decision, desc);
    }

    protected void load() throws IOException, ParsingException, UnknownIdentifierException {
        File f = new File(this.configurationFile);
        if (!f.exists()) {
            throw new FileNotFoundException("Does not exist: <" + this.configurationFile + ">");
        }
        if (this.lastModified == f.lastModified()) {
            return;
        }
        log.info((Object)("XACML configuration " + f.getAbsolutePath() + " modified, re-reading..."));
        this.lastModified = f.lastModified();
        ConfigurationStore store = new ConfigurationStore(f);
        store.useDefaultFactories();
        this.policyLock.writeLock().lock();
        this.pdp = new PDP(store.getDefaultPDPConfig());
        this.policyLock.writeLock().unlock();
    }

    private void startConfigWatcher(int interval) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                log.info((Object)"Local XACML PDP configuration file was modified, re-configuring.");
                try {
                    LocalSunPDP.this.load();
                }
                catch (IOException e) {
                    log.error((Object)("Error reading XAML PDP configuration (file " + LocalSunPDP.this.configurationFile + "): " + e.toString()));
                }
                catch (ParsingException e) {
                    log.error((Object)("Error parsing XAML policies: " + e.toString()), (Throwable)e);
                }
                catch (UnknownIdentifierException e) {
                    log.error((Object)("Error parsing XAML policies: " + e.toString()), (Throwable)e);
                }
            }
        };
        try {
            File confFile = new File(this.configurationFile);
            FileWatcher fw = new FileWatcher(confFile, r);
            this.threadingSrv.getScheduledExecutorService().scheduleWithFixedDelay((Runnable)fw, interval, interval, TimeUnit.MILLISECONDS);
        }
        catch (FileNotFoundException fex) {
            log.error((Object)("Sun XAML PDP configuration file <" + this.configurationFile + "> not found."));
        }
    }
}

