/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.local;

import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.security.pdp.ActionDescriptor;
import de.fzj.unicore.wsrflite.security.pdp.PDPResult;
import de.fzj.unicore.wsrflite.security.pdp.UnicoreXPDP;
import de.fzj.unicore.wsrflite.security.util.ResourceDescriptor;
import eu.unicore.security.Client;
import eu.unicore.uas.pdp.local.LocalPolicyStore;
import eu.unicore.uas.pdp.local.PolicyListener;
import eu.unicore.uas.pdp.request.creator.HerasafXacml2RequestCreator;
import eu.unicore.uas.pdp.request.profile.UnicoreInternalProfile;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.context.RequestCtx;
import org.herasaf.xacml.core.context.ResponseCtx;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.MissingAttributeDetailType;
import org.herasaf.xacml.core.context.impl.ResultType;
import org.herasaf.xacml.core.context.impl.StatusDetailType;
import org.herasaf.xacml.core.context.impl.StatusType;
import org.herasaf.xacml.core.converter.URNToPolicyCombiningAlgorithmConverter;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.simplePDP.OrderedMapBasedSimplePolicyRepository;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.SimplePDPFactory;

public class LocalHerasafPDP
implements UnicoreXPDP,
PolicyListener {
    private static final Logger log = Log.getLogger((String)"unicore.security", LocalHerasafPDP.class);
    private PDP engine;
    protected HerasafXacml2RequestCreator requestMaker;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public void initialize(String configuration, ContainerProperties baseSettings, IContainerSecurityConfiguration securityConfiguration, IClientConfiguration clientConfiguration) throws Exception {
        if (configuration == null) {
            throw new ConfigurationException("For " + LocalHerasafPDP.class.getName() + " PDP a configuration file must be defined.");
        }
        String baseUrl = baseSettings.getValue("baseurl");
        this.requestMaker = new HerasafXacml2RequestCreator(new UnicoreInternalProfile(baseUrl));
        new LocalPolicyStore(this, configuration, baseSettings.getThreadingServices());
    }

    public void initialize(HerasafXacml2RequestCreator requestCreator) {
        this.requestMaker = requestCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(List<Evaluatable> policies, String algorithm) {
        SimplePDPConfiguration config = new SimplePDPConfiguration();
        URNToPolicyCombiningAlgorithmConverter policyCnv = new URNToPolicyCombiningAlgorithmConverter();
        OrderedMapBasedSimplePolicyRepository repo = new OrderedMapBasedSimplePolicyRepository();
        repo.deploy(policies);
        config.setRootCombiningAlgorithm(policyCnv.unmarshal(algorithm));
        config.setPolicyRetrievalPoint((PolicyRetrievalPoint)repo);
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.engine = SimplePDPFactory.getSimplePDP((SimplePDPConfiguration)config);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseCtx authorize(RequestCtx request) {
        ResponseCtx resp;
        Lock l = this.lock.readLock();
        l.lock();
        try {
            resp = this.engine.evaluate(request);
        }
        finally {
            l.unlock();
        }
        return resp;
    }

    public PDPResult checkAuthorisation(Client c, ActionDescriptor action, ResourceDescriptor d) throws Exception {
        List results;
        RequestCtx request = this.requestMaker.createRequest(c, action, d);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.marshal((OutputStream)baos);
            log.debug((Object)("XACML request:" + baos.toString()));
        }
        ResponseCtx response = this.authorize(request);
        if (log.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            response.marshal((OutputStream)baos);
            log.debug((Object)("XACML response:" + baos.toString()));
        }
        if ((results = response.getResponse().getResults()).size() != 1) {
            throw new Exception("XACML herasAF PDP BUG: got " + results.size() + " results after asking about one resource. Should get 1.");
        }
        ResultType result = (ResultType)results.get(0);
        return new PDPResult(LocalHerasafPDP.getDecision(result), LocalHerasafPDP.getComment(result));
    }

    private static PDPResult.Decision getDecision(ResultType result) {
        if (result.getDecision().equals((Object)DecisionType.DENY)) {
            return PDPResult.Decision.DENY;
        }
        if (result.getDecision().equals((Object)DecisionType.PERMIT)) {
            return PDPResult.Decision.PERMIT;
        }
        return PDPResult.Decision.UNCLEAR;
    }

    private static String getComment(ResultType result) {
        List mas;
        StatusDetailType detail;
        String m;
        StatusType status = result.getStatus();
        if (status == null) {
            return "";
        }
        StringBuilder msg = new StringBuilder();
        if (status.getStatusCode() != null) {
            msg.append("Decission status code: [");
            msg.append(status.getStatusCode().getValue()).append("]\n");
        }
        if ((m = status.getStatusMessage()) != null) {
            msg.append("Message: [").append(m).append("]\n");
        }
        if ((detail = status.getStatusDetail()) != null && (mas = detail.getMissingAttributeDetails()) != null) {
            msg.append("The following attributes are missing: [");
            for (MissingAttributeDetailType ma : mas) {
                msg.append(" ").append(ma.getAttributeId());
            }
            msg.append(" ]");
        }
        return msg.toString().trim();
    }
}

