/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.argus;

import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import eu.unicore.uas.pdp.argus.SAMLXACMLProvisioningInterface;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.xfire.XFireRuntimeException;
import xmlbeans.oasis.xacml.x2.x0.saml.assertion.XACMLPolicyQueryDocument;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;

public class ArgusPAPClient {
    private SAMLXACMLProvisioningInterface samlProxy;

    public ArgusPAPClient(URL address, int timeout, IClientConfiguration sec) {
        String url = address.toString();
        try {
            sec.getExtraSettings().setProperty("http.connection.timeout", "" + timeout);
            sec.getExtraSettings().setProperty("http.socket.timeout", "" + timeout);
            WSRFClientFactory factory = new WSRFClientFactory(sec);
            this.samlProxy = (SAMLXACMLProvisioningInterface)factory.createPlainWSProxy(SAMLXACMLProvisioningInterface.class, url);
        }
        catch (MalformedURLException m) {
            throw new IllegalArgumentException(m);
        }
    }

    public ResponseDocument sendRequest(XACMLPolicyQueryDocument req) throws IOException {
        try {
            ResponseDocument resp = this.samlProxy.policyRequest(req);
            if (resp == null) {
                throw new IOException("Error during communication with Argus PAP server: didn't received SOAP answer (seems as Argus BUG)!");
            }
            return resp;
        }
        catch (XFireRuntimeException e) {
            throw new IOException("Error during communication with Argus PAP server: ", e);
        }
    }
}

