/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.uas.pdp.argus;

import de.fzj.unicore.wsrflite.ThreadingServices;
import eu.unicore.uas.pdp.local.LocalPolicyStore;
import eu.unicore.uas.pdp.local.PolicyListener;
import eu.unicore.util.Log;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.herasaf.xacml.core.SyntaxException;
import org.xml.sax.SAXException;

public class ArgusHerasafPolicyStore
extends LocalPolicyStore {
    public static final Logger log = Log.getLogger((String)"unicore.security", ArgusHerasafPolicyStore.class);

    public ArgusHerasafPolicyStore(PolicyListener pdp, String configurationFile, Object notification, ThreadingServices threadingSrv) throws IOException, SyntaxException, JAXBException, SAXException {
        super(pdp, configurationFile, -1, threadingSrv);
        this.waitAndReload(notification);
    }

    private void waitAndReload(final Object notification) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Object object = notification;
                synchronized (object) {
                    while (true) {
                        try {
                            notification.wait();
                        }
                        catch (InterruptedException e) {
                            log.error((Object)"Error waiting to notification: ", (Throwable)e);
                        }
                        log.info((Object)"Local Argus XACML was modified, re-configuring.");
                        try {
                            ArgusHerasafPolicyStore.this.reload();
                        }
                        catch (IOException e) {
                            log.error((Object)"Error reading policy dir  ", (Throwable)e);
                        }
                        catch (SyntaxException e) {
                            log.error((Object)("Error parsing XAML policies: " + e.toString() + " " + e.getCause().toString()), (Throwable)e);
                        }
                    }
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
    }
}

