/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.bes.security;

import eu.unicore.security.xfireutil.client.Configurable;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.handler.AbstractHandler;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class UsernameOutHandler
extends AbstractHandler
implements Configurable {
    protected IClientConfiguration sec;
    private static final Logger logger = Log.getLogger((String)"unicore.security", UsernameOutHandler.class);
    public static final String WSS = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSS_SECURITY = "Security";
    private String username;
    private String password;
    private boolean activateUsernameProfile = false;

    public UsernameOutHandler() {
        this.setPhase("policy");
    }

    public void configure(IClientConfiguration sec) {
        this.sec = sec;
        this.username = sec.getExtraSettings().getProperty("wsUserName");
        this.password = sec.getExtraSettings().getProperty("wsPassword");
        boolean activateDefault = this.username != null;
        this.activateUsernameProfile = Boolean.valueOf(sec.getExtraSettings().getProperty("wsActivateUsernameProfile", String.valueOf(activateDefault)));
        if (this.password == null) {
            this.password = "";
        }
        if (this.activateUsernameProfile && this.username == null) {
            throw new IllegalArgumentException("Username/password handler enabled, but username was null.");
        }
    }

    public void invoke(MessageContext ctx) throws Exception {
        if (!this.activateUsernameProfile) {
            return;
        }
        Element h = ctx.getOutMessage().getOrCreateHeader();
        h.addContent((Content)this.getUsernameTokenHeader());
        if (logger.isDebugEnabled()) {
            XMLOutputter o = new XMLOutputter();
            o.setFormat(Format.getPrettyFormat());
            logger.trace((Object)("Sending username/password: " + o.outputString(h)));
        }
    }

    public Element getUsernameTokenHeader() {
        Element my = new Element(WSS_SECURITY);
        my.setNamespace(Namespace.getNamespace((String)"wsse", (String)WSS));
        my.setAttribute("mustUnderstand", "1");
        Element unameTokenElement = new Element("UsernameToken", Namespace.getNamespace((String)"wsse", (String)WSS));
        Element unameElement = new Element("Username", Namespace.getNamespace((String)"wsse", (String)WSS));
        unameElement.addContent(this.username);
        Element pwdElement = new Element("Password", Namespace.getNamespace((String)"wsse", (String)WSS));
        pwdElement.addContent(this.password);
        unameTokenElement.addContent((Content)unameElement);
        unameTokenElement.addContent((Content)pwdElement);
        my.addContent((Content)unameTokenElement);
        return my;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String userName) {
        this.username = userName;
    }

    public boolean isActivateUsernameProfile() {
        return this.activateUsernameProfile;
    }

    public void setActivateUsernameProfile(boolean activateUsernameProfile) {
        this.activateUsernameProfile = activateUsernameProfile;
    }
}

