/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSConnection;
import fr.maatg.glite.dm.ns.ExpiringObect;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CNSUser
extends ExpiringObect {
    private static final int USERS_MAP_MAX_SIZE = 1000;
    private static final Map<String, CNSUser> usersMappings = new HashMap<String, CNSUser>();
    private final int uid;
    private final String certificateHeader;

    private CNSUser(int uid, String certificateHeader) {
        this.uid = uid;
        this.certificateHeader = certificateHeader;
    }

    protected static CNSUser getInstance(CNSConnection connection, int uid) throws IOException, ReceiveException {
        String mappings_key = connection.getHost() + connection.getPort() + uid;
        CNSUser cnsUser = usersMappings.get(mappings_key);
        if (cnsUser != null && cnsUser.isStillValid()) {
            return cnsUser;
        }
        cnsUser = new CNSUser(uid, connection.cns_getusrnam(uid));
        if (usersMappings.size() >= 1000) {
            Iterator<Map.Entry<String, CNSUser>> iterator = usersMappings.entrySet().iterator();
            for (int index = 0; iterator.hasNext() && index != 50; ++index) {
                iterator.remove();
            }
        }
        usersMappings.put(mappings_key, cnsUser);
        return cnsUser;
    }

    public int getUid() {
        return this.uid;
    }

    public String getCertificateHeader() {
        return this.certificateHeader;
    }

    public String toString() {
        return this.certificateHeader + "(uid=" + this.uid + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CNSUser)) {
            return false;
        }
        if (this.uid != ((CNSUser)obj).uid) {
            return false;
        }
        return this.certificateHeader == ((CNSUser)obj).certificateHeader;
    }
}

