/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.DMObject;
import fr.maatg.glite.dm.ns.CNSConnection;
import fr.maatg.glite.dm.ns.emuns.CNSFileType;
import java.io.IOException;
import java.nio.ByteBuffer;

public class CNSReplica
extends DMObject {
    private String poolName;
    private String guid;
    private String host;
    private String fs;
    private String sfn;
    private long aDate;
    private long pDate;
    private long fileId;
    private long nbaccesses;
    private byte status;
    private CNSFileType f_type;

    CNSReplica(ByteBuffer byteBuffer) throws IOException {
        this.fillObject(byteBuffer);
    }

    protected void fillObject(ByteBuffer byteBuffer) throws IOException {
        this.fileId = byteBuffer.getLong();
        this.nbaccesses = byteBuffer.getLong();
        this.aDate = byteBuffer.getLong() * 1000L;
        this.pDate = byteBuffer.getLong() * 1000L;
        this.status = byteBuffer.get();
        this.f_type = CNSFileType.fromByte(byteBuffer.get());
        this.poolName = CNSConnection.getString(byteBuffer);
        this.host = CNSConnection.getString(byteBuffer);
        this.fs = CNSConnection.getString(byteBuffer);
        this.sfn = CNSConnection.getString(byteBuffer);
    }

    public String getGuid() {
        return this.guid;
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getADate() {
        return this.aDate;
    }

    public long getPDate() {
        return this.pDate;
    }

    public byte getStatus() {
        return this.status;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getHost() {
        return this.host;
    }

    public String getFs() {
        return this.fs;
    }

    public String getSfn() {
        return this.sfn;
    }

    public long getNbaccesses() {
        return this.nbaccesses;
    }

    public CNSFileType getF_type() {
        return this.f_type;
    }

    public String toString() {
        String replica = "";
        replica = replica + "fileId: " + this.fileId;
        replica = replica + " - nbaccesses: " + this.nbaccesses;
        replica = replica + " - aDate: " + this.aDate;
        replica = replica + " - pDate: " + this.pDate;
        replica = replica + " - status: " + this.status;
        replica = replica + " - f_type: " + (Object)((Object)this.f_type);
        replica = replica + " - poolName: " + this.poolName;
        replica = replica + " - host: " + this.host;
        replica = replica + " - fs: " + this.fs;
        replica = replica + " - sfn: " + this.sfn;
        return replica;
    }
}

