/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSConnection;
import fr.maatg.glite.dm.ns.ExpiringObect;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CNSGroup
extends ExpiringObect {
    private static final int GROUPS_MAP_MAX_SIZE = 1000;
    private static final Map<String, CNSGroup> groupsMappings = new HashMap<String, CNSGroup>();
    private final int gid;
    private final String name;

    private CNSGroup(int gid, String name) {
        this.gid = gid;
        this.name = name;
    }

    protected static CNSGroup getInstance(CNSConnection connection, int gid) throws IOException, ReceiveException {
        String mappings_key = connection.getHost() + connection.getPort() + gid;
        CNSGroup cnsGroup = groupsMappings.get(mappings_key);
        if (cnsGroup != null && cnsGroup.isStillValid()) {
            return cnsGroup;
        }
        cnsGroup = new CNSGroup(gid, connection.cns_getgrpnam(gid));
        if (groupsMappings.size() >= 1000) {
            Iterator<Map.Entry<String, CNSGroup>> iterator = groupsMappings.entrySet().iterator();
            for (int index = 0; iterator.hasNext() && index != 50; ++index) {
                iterator.remove();
            }
        }
        groupsMappings.put(mappings_key, cnsGroup);
        return cnsGroup;
    }

    public int getGid() {
        return this.gid;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (gid=" + this.gid + ")";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CNSGroup)) {
            return false;
        }
        if (this.gid != ((CNSGroup)obj).gid) {
            return false;
        }
        return this.name == ((CNSGroup)obj).name;
    }
}

