/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.Connection;
import fr.maatg.glite.dm.connection.DMObject;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSConnection;
import fr.maatg.glite.dm.ns.CNSGroup;
import fr.maatg.glite.dm.ns.CNSUser;
import fr.maatg.glite.dm.ns.emuns.CNSChecksumType;
import fr.maatg.glite.dm.ns.emuns.CNSFileStatus;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class CNSFile
extends DMObject {
    private final boolean readName;
    private final boolean readGuid;
    private final boolean readCheckSum;
    private final boolean readComment;
    protected String guid;
    protected String fileName;
    protected String comment;
    protected CNSChecksumType chksumType;
    protected String chksumValue;
    protected long aDate;
    protected long mDate;
    protected long cDate;
    protected long fileId;
    protected int nLink;
    protected int uid;
    protected int gid;
    protected long fileSize;
    protected short fileMode;
    protected short fileClass;
    protected CNSFileStatus status;
    protected String path;

    protected CNSFile(String path, ByteBuffer byteBuffer, boolean readName, boolean readGuid, boolean readCheckSum, boolean readComment) throws IOException {
        this.path = path;
        this.readName = readName;
        this.readGuid = readGuid;
        this.readCheckSum = readCheckSum;
        this.readComment = readComment;
        this.fillObject(byteBuffer);
    }

    protected void fillObject(ByteBuffer byteBuffer) throws IOException {
        this.fileId = byteBuffer.getLong();
        if (this.readGuid) {
            this.guid = Connection.getString(byteBuffer);
        }
        this.fileMode = byteBuffer.getShort();
        this.nLink = byteBuffer.getInt();
        this.uid = byteBuffer.getInt();
        this.gid = byteBuffer.getInt();
        this.fileSize = byteBuffer.getLong();
        this.aDate = byteBuffer.getLong() * 1000L;
        this.mDate = byteBuffer.getLong() * 1000L;
        this.cDate = byteBuffer.getLong() * 1000L;
        this.fileClass = byteBuffer.getShort();
        this.status = CNSFileStatus.fromByte(byteBuffer.get());
        if (this.readCheckSum) {
            this.chksumType = CNSChecksumType.fromString(CNSConnection.getString(byteBuffer));
            this.chksumValue = CNSConnection.getString(byteBuffer);
        }
        if (this.readName) {
            this.fileName = CNSConnection.getString(byteBuffer);
            if (this.path != null) {
                if (!this.path.endsWith("/")) {
                    this.path = this.path + "/";
                }
                this.path = this.path + this.fileName;
            }
        }
        if (this.readComment) {
            this.comment = CNSConnection.getString(byteBuffer);
        }
    }

    public long getFileId() {
        return this.fileId;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public short getFileMode() {
        return this.fileMode;
    }

    public short getFileClass() {
        return this.fileClass;
    }

    public CNSFileStatus getStatus() {
        return this.status;
    }

    public CNSGroup group(CNSConnection connection) throws IOException, ReceiveException {
        return CNSGroup.getInstance(connection, this.gid);
    }

    public CNSUser owner(CNSConnection connection) throws IOException, ReceiveException {
        return CNSUser.getInstance(connection, this.uid);
    }

    public long creationTime() {
        return this.mDate;
    }

    public boolean isOther() {
        return !this.isRegularFile() && !this.isDirectory() && !this.isSymbolicLink();
    }

    public boolean isRegularFile() {
        return (this.fileMode & 0xF000) == 32768;
    }

    public boolean isDirectory() {
        return (this.fileMode & 0xF000) == 16384;
    }

    public boolean isSymbolicLink() {
        return (this.fileMode & 0xF000) == 40960;
    }

    public long lastAccessTime() {
        return this.aDate;
    }

    public long lastModifiedTime() {
        return this.cDate;
    }

    public int linkCount() {
        return this.nLink;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        String tostring = "";
        if (this.fileName != null) {
            tostring = tostring + "Name: " + this.fileName;
        }
        if (this.guid != null) {
            tostring = tostring + (tostring.equals("") ? "" : " - ") + "guid: " + this.guid;
        }
        if (this.comment != null) {
            tostring = tostring + (tostring.equals("") ? "" : " - ") + "comment: " + this.comment;
        }
        if (this.chksumType != null) {
            tostring = tostring + (tostring.equals("") ? "" : " - ") + "chksumType: " + (Object)((Object)this.chksumType);
            tostring = tostring + " - chksumValue: " + this.chksumValue;
        }
        tostring = tostring + (tostring.equals("") ? "" : " - ") + "aDate: " + this.aDate;
        tostring = tostring + " - mDate: " + this.mDate;
        tostring = tostring + " - cDate: " + this.cDate;
        tostring = tostring + " - fileUniqueId: " + this.fileId;
        tostring = tostring + " - fileSize: " + this.fileSize;
        tostring = tostring + " - nLink: " + this.nLink;
        tostring = tostring + " - uid: " + this.uid;
        tostring = tostring + " - gid: " + this.gid;
        tostring = tostring + " - fileMode: " + this.fileMode;
        tostring = tostring + " - fileClass: " + this.fileClass;
        tostring = tostring + " - status: " + (Object)((Object)this.status);
        return tostring;
    }
}

