/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.Connection;
import fr.maatg.glite.dm.connection.DMError;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CNSConnectionTimeout
extends CNSConnection {
    protected static Logger s_logger = LoggerFactory.getLogger(CNSConnectionTimeout.class);
    private ByteBuffer reqBuffer2 = ByteBuffer.allocateDirect(10240);

    CNSConnectionTimeout(CNSConnection cnsConnection) {
        super(cnsConnection);
    }

    protected Connection.DMResponse sendAndReceive(boolean includeHeaderInLength) throws IOException, ReceiveException {
        int posNow = -1;
        int posMark = -1;
        try {
            posNow = this.sendBuf.position();
            this.sendBuf.reset();
            posMark = this.sendBuf.position();
            this.sendBuf.position(posNow);
        }
        catch (Exception e) {
            s_logger.error("Unable to save the send buffer", (Throwable)e);
            throw new RuntimeException("Unable to save the send buffer", e);
        }
        boolean reconnected = false;
        boolean max_retry = true;
        for (int i = 0; i < 2; ++i) {
            try {
                if (reconnected && this.isSessionOpened() && this.sendBuf.getInt(4) != 60 && this.sendBuf.getInt(4) != 59) {
                    s_logger.debug("Starting a new session as it was started before reconnection.");
                    this.cns_startsess(null);
                    s_logger.debug("New session started.");
                } else if (reconnected) {
                    s_logger.debug("No session to restart.");
                }
                if (i > 0) {
                    s_logger.debug("Replaying the previous command...");
                }
                Connection.DMResponse response = super.sendAndReceive(includeHeaderInLength);
                if (i > 0) {
                    s_logger.debug("Previous command replayed successfully...");
                }
                return response;
            }
            catch (ReceiveException e) {
                if (e.getDMError().equals((Object)DMError.SETIMEDOUT)) {
                    if (i >= 1) {
                        s_logger.error("Unable to stop the timeout exception!", (Throwable)e);
                        throw e;
                    }
                    if (this.isTransactionOpened()) {
                        try {
                            s_logger.warn("TIMEOUT detected (server: " + this.host + ":" + this.port + ", user: " + ((Object)this.gssCredential.getName()).toString() + ") but transaction opened... will not replay");
                        }
                        catch (GSSException e1) {
                            s_logger.warn("TIMEOUT detected (server: " + this.host + ":" + this.port + ") but transaction opened... will not replay");
                        }
                        throw e;
                    }
                    try {
                        s_logger.warn("TIMEOUT detected (server: " + this.host + ":" + this.port + ", user: " + ((Object)this.gssCredential.getName()).toString() + ") and no opened transaction... opening a new connection and trying to replay the command");
                    }
                    catch (GSSException e1) {
                        s_logger.warn("TIMEOUT detected (server: " + this.host + ":" + this.port + ") and no opened transaction... opening a new connection and trying to replay the command");
                    }
                } else {
                    throw e;
                }
                this.reconnect();
                reconnected = true;
                this.sendBuf.position(posMark);
                this.sendBuf.mark();
                this.sendBuf.position(posNow);
                continue;
            }
        }
        s_logger.error("BUG: Must not be here !");
        throw new RuntimeException("BUG: Must not be here !");
    }

    private void reconnect() throws IOException, ReceiveException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.channel = SocketChannel.open(new InetSocketAddress(this.host, this.port));
        s_logger.debug("Reconnecting connection with server " + this.host + ":" + this.port);
        try {
            this.authenticate(this.reqBuffer2);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("authenticate()");
            throw e;
        }
        s_logger.debug("Reconnection done with server " + this.host + ":" + this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cns_startsess(String comment) throws IOException, ReceiveException {
        Object object = this.sessionSynchro;
        synchronized (object) {
            this.preparePacket(this.reqBuffer2, 51254017, 59);
            this.addIDs(this.reqBuffer2);
            this.reqBuffer2.putLong(0L);
            this.putString(this.reqBuffer2, comment);
            this.send(this.reqBuffer2, true);
            this.receive();
            this.openedSession = true;
        }
    }
}

