/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.Connection;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.AbstractCNSConnection;
import fr.maatg.glite.dm.ns.CNSAccessType;
import fr.maatg.glite.dm.ns.CNSDir;
import fr.maatg.glite.dm.ns.CNSDuInfos;
import fr.maatg.glite.dm.ns.CNSFileReaddir;
import fr.maatg.glite.dm.ns.CNSFileStat;
import fr.maatg.glite.dm.ns.CNSFileStatg;
import fr.maatg.glite.dm.ns.CNSLinkInfo;
import fr.maatg.glite.dm.ns.CNSReplica;
import fr.maatg.glite.dm.ns.CNSStatus;
import fr.maatg.glite.dm.ns.CNSStatusesException;
import fr.maatg.glite.dm.ns.emuns.CNSChecksumType;
import fr.maatg.glite.dm.ns.emuns.CNSFileType;
import fr.maatg.glite.dm.ns.emuns.CNSReplicaStatus;
import fr.maatg.glite.dm.ns.emuns.CNSReplicaType;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.ietf.jgss.GSSCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNSConnection
extends AbstractCNSConnection {
    protected boolean openedTransaction = false;
    protected Object transactionSynchro = new Object();
    protected boolean openedSession = false;
    protected Object sessionSynchro = new Object();
    protected static final long CWD = 0L;

    public CNSConnection(String host, int port, GSSCredential gssCredential) throws IOException, ReceiveException {
        super(host, port, gssCredential);
    }

    protected CNSConnection(CNSConnection cnsConnection) {
        super(cnsConnection);
        if (cnsConnection.isSessionOpened()) {
            this.openedSession = true;
        }
        if (cnsConnection.isTransactionOpened()) {
            this.openedTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cns_startsess(String comment) throws IOException, ReceiveException {
        Object object = this.sessionSynchro;
        synchronized (object) {
            this.preparePacket(51254017, 59);
            this.addIDs();
            this.sendBuf.putLong(0L);
            this.putString(comment);
            this.sendAndReceive(true);
            this.openedSession = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cns_endsess() throws IOException, ReceiveException {
        Object object = this.sessionSynchro;
        synchronized (object) {
            this.preparePacket(51254017, 60);
            this.addIDs();
            this.sendBuf.putLong(0L);
            this.sendAndReceive(true);
            this.openedSession = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSessionOpened() {
        Object object = this.sessionSynchro;
        synchronized (object) {
            return this.openedSession;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cns_starttrans(String comment) throws IOException, ReceiveException {
        Object object = this.transactionSynchro;
        synchronized (object) {
            if (this.openedTransaction) {
                throw new RuntimeException("Multiple transactions cannot be openned on a single connection.");
            }
            this.preparePacket(comment != null ? 51254018 : 51254017, 46);
            this.addIDs();
            this.putString(comment);
            this.sendAndReceive(true);
            this.openedTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cns_endtrans() throws IOException, ReceiveException {
        Object object = this.transactionSynchro;
        synchronized (object) {
            if (!this.openedTransaction) {
                throw new RuntimeException("There is no started transaction.");
            }
            this.preparePacket(51254017, 47);
            this.addIDs();
            this.sendAndReceive(true);
            this.openedTransaction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cns_aborttrans() throws IOException, ReceiveException {
        Object object = this.transactionSynchro;
        synchronized (object) {
            this.preparePacket(51254017, 48);
            this.addIDs();
            this.sendAndReceive(true);
            this.openedTransaction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTransactionOpened() {
        Object object = this.transactionSynchro;
        synchronized (object) {
            return this.openedTransaction;
        }
    }

    @Override
    public String cns_ping() throws IOException, ReceiveException {
        this.preparePacket(51254017, 82);
        this.addIDs();
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        String version = CNSConnection.getString(respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_PING: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return version;
    }

    @Override
    public CNSFileStat cns_stat(String path, long file_uniqueid) throws IOException, ReceiveException {
        this.preparePacket(51254017, 8);
        this.addIDs();
        this.sendBuf.putLong(0L);
        if (file_uniqueid > 0L) {
            this.sendBuf.putLong(file_uniqueid);
            this.putString(null);
        } else {
            this.sendBuf.putLong(0L);
            this.putString(path);
        }
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        CNSFileStat file = new CNSFileStat(path, respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_STAT: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return file;
    }

    @Override
    public CNSFileStat cns_lstat(String path, long file_uniqueid) throws IOException, ReceiveException {
        this.preparePacket(51254017, 40);
        this.addIDs();
        this.sendBuf.putLong(0L);
        if (file_uniqueid > 0L) {
            this.sendBuf.putLong(file_uniqueid);
            this.putString(null);
        } else {
            this.sendBuf.putLong(0L);
            this.putString(path);
        }
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        CNSFileStat file = new CNSFileStat(path, respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_LSTAT: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return file;
    }

    @Override
    public CNSFileStatg cns_statg(String path, String guid) throws IOException, ReceiveException {
        this.preparePacket(51254017, 51);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.putString(guid);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        CNSFileStatg file = new CNSFileStatg(path, respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_STATG: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return file;
    }

    @Override
    public CNSFileStatg cns_statr(String sfn) throws IOException, ReceiveException {
        this.preparePacket(51254017, 52);
        this.addIDs();
        this.putString(sfn);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        CNSFileStatg file = new CNSFileStatg(sfn, respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_STATR: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return file;
    }

    @Override
    public String cns_readlink(String link) throws IOException, ReceiveException {
        this.preparePacket(51254017, 41);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(link);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        String path = CNSConnection.getString(respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_READLINK: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return path;
    }

    @Override
    public void cns_symlink(String path, String target) throws IOException, ReceiveException {
        this.preparePacket(51254017, 42);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.putString(target);
        this.sendAndReceive(true);
    }

    @Override
    public int cns_getgrpid(String groupname) throws IOException, ReceiveException {
        if ("root".equals(groupname)) {
            return 0;
        }
        this.preparePacket(51254017, 62);
        this.putString(groupname);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        int s = respBuffer.getInt();
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_GETGRPID: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return s;
    }

    @Override
    public String cns_getgrpnam(int gid) throws IOException, ReceiveException {
        if (gid == 0) {
            return "root";
        }
        this.preparePacket(51254017, 63);
        this.sendBuf.putShort((short)0);
        this.sendBuf.putShort((short)gid);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        String group = CNSConnection.getString(respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_GETGRPNAM: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return group;
    }

    @Override
    public Collection<String> cns_getgrpnames(int[] gids) throws IOException, ReceiveException {
        int i;
        ArrayList<Integer> rootGIDIndexes = new ArrayList<Integer>();
        ArrayList<Integer> newGids = new ArrayList<Integer>();
        for (i = 0; i < gids.length; ++i) {
            if (gids[i] == 0) {
                rootGIDIndexes.add(i);
                continue;
            }
            newGids.add(gids[i]);
        }
        gids = new int[newGids.size()];
        for (i = 0; i < newGids.size(); ++i) {
            gids[i] = (Integer)newGids.get(i);
        }
        this.preparePacket(51254017, 81);
        this.sendBuf.putShort((short)0);
        this.sendBuf.putShort((short)gids.length);
        for (i = 0; i < gids.length; ++i) {
            this.sendBuf.putInt(gids[i]);
        }
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        ArrayList<String> grpNames = new ArrayList<String>(gids.length);
        for (int i2 = 0; i2 < gids.length; ++i2) {
            if (rootGIDIndexes.contains(i2)) {
                grpNames.add("root");
                continue;
            }
            grpNames.add(CNSConnection.getString(respBuffer));
        }
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_GETGRPNAMES: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return grpNames;
    }

    @Override
    public int cns_getusrid(String username) throws IOException, ReceiveException {
        if ("root".equals(username)) {
            return 0;
        }
        this.preparePacket(51254017, 65);
        this.putString(username);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        int s = respBuffer.getInt();
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_GETUSRID: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return s;
    }

    @Override
    public String cns_getusrnam(int uid) throws IOException, ReceiveException {
        if (uid == 0) {
            return "root";
        }
        this.preparePacket(51254017, 66);
        this.sendBuf.putShort((short)0);
        this.sendBuf.putShort((short)uid);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        String user = CNSConnection.getString(respBuffer);
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_GETUSRNAM: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return user;
    }

    @Override
    public void cns_access(String path, CNSAccessType accessType) throws IOException, ReceiveException {
        this.preparePacket(51254017, 0);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putInt(accessType.getValue());
        this.sendAndReceive(true);
    }

    @Override
    public CNSDir cns_opendirg(String path, String guid) throws IOException, ReceiveException {
        if (guid == null) {
            this.preparePacket(51254017, 10);
        } else {
            this.preparePacket(51254018, 10);
        }
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.putString(guid);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        long fileId = respBuffer.getLong();
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_OPENDIRG: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return new CNSDir(fileId, path);
    }

    @Override
    public void cns_closedir() throws IOException, ReceiveException {
        this.preparePacket(51254017, 12);
        this.sendAndReceive(true);
    }

    @Override
    public Collection<CNSFileReaddir> cns_readdir(CNSDir cnsDir) throws IOException, ReceiveException {
        this.preparePacket(51254017, 11);
        this.addIDs();
        this.sendBuf.putShort((short)1);
        this.sendBuf.putShort((short)0);
        this.sendBuf.putLong(cnsDir.getFileID());
        this.sendBuf.putShort(cnsDir.getBod());
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        short count = respBuffer.getShort();
        ArrayList<CNSFileReaddir> cnsFiles = new ArrayList<CNSFileReaddir>(count);
        for (short i = 0; i < count; i = (short)(i + 1)) {
            CNSFileReaddir file = new CNSFileReaddir(cnsDir.getPath(), respBuffer);
            cnsFiles.add(file);
        }
        cnsDir.setEod(respBuffer.getShort());
        if (respBuffer.hasRemaining()) {
            throw new IOException("CNS_READDIR: Something remains to be read (" + respBuffer.remaining() + " byte(s))");
        }
        return cnsFiles;
    }

    @Override
    public void cns_delete(String path) throws IOException, ReceiveException {
        this.preparePacket(51254017, 23);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_undelete(String path) throws IOException, ReceiveException {
        this.preparePacket(51254017, 24);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_unlink(String path) throws IOException, ReceiveException {
        this.preparePacket(51254017, 9);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_setfsize(String path, long file_uniqueid, long fileSize, CNSChecksumType checksumType, String checksumValue) throws IOException, ReceiveException {
        this.preparePacket(51254018, 16);
        this.addIDs();
        this.sendBuf.putLong(0L);
        if (file_uniqueid > 0L) {
            this.sendBuf.putLong(file_uniqueid);
            this.putString(null);
        } else {
            this.sendBuf.putLong(0L);
            this.putString(path);
        }
        this.sendBuf.putLong(fileSize);
        this.putString(checksumType == null ? null : checksumType.toString());
        this.putString(checksumValue);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_rename(String oldPath, String newPath) throws IOException, ReceiveException {
        this.preparePacket(51254017, 6);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(oldPath);
        this.putString(newPath);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_chmod(String path, int mode) throws IOException, ReceiveException {
        this.preparePacket(51254017, 2);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putInt(mode &= 0xFFF);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_chown(String path, int owner, int group) throws IOException, ReceiveException {
        this.preparePacket(51254017, 3);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putInt(owner);
        this.sendBuf.putInt(group);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_lchown(String path, int owner, int group) throws IOException, ReceiveException {
        this.preparePacket(51254017, 39);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putInt(owner);
        this.sendBuf.putInt(group);
        this.sendAndReceive(true);
    }

    @Override
    public Collection<CNSReplica> cns_listreplica(String path, String guid, short flag, short[] eol) throws IOException, ReceiveException {
        this.preparePacket(51254018, flag == 2 ? 21 : 45);
        this.addIDs();
        this.sendBuf.putShort((short)0);
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.putString(guid);
        short bol = 0;
        if (flag == 0) {
            bol = 1;
        }
        this.sendBuf.putShort(bol);
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        short count = respBuffer.getShort();
        ArrayList<CNSReplica> replicas = new ArrayList<CNSReplica>(count);
        for (short i = 0; i < count; i = (short)(i + 1)) {
            CNSReplica replica = new CNSReplica(respBuffer);
            replicas.add(replica);
        }
        eol[0] = respBuffer.getShort();
        if (respBuffer.hasRemaining()) {
            throw new IOException(flag + ": Something remains to be read (" + respBuffer.remaining() + ")");
        }
        return replicas;
    }

    @Override
    protected void cns_delfiles(short argtype, String[] guidsOrFilenames, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        if (this.openedTransaction) {
            throw new RuntimeException("CNS_DELFILES cannot be used inside a transaction");
        }
        this.preparePacket(51254017, 83);
        this.addIDs();
        short sforce = force ? (short)1 : 0;
        this.sendBuf.putShort(argtype);
        this.sendBuf.putShort(sforce);
        if (argtype == 1) {
            this.sendBuf.putLong(0L);
        }
        this.sendBuf.putInt(guidsOrFilenames.length);
        for (int i = 0; i < guidsOrFilenames.length; ++i) {
            this.putString(guidsOrFilenames[i]);
        }
        Connection.DMResponse response = this.sendAndReceive(true);
        if (response.dmObjectsHaveErrors()) {
            throw new CNSStatusesException("At least one error occurs during the CNS_DELFILES operation", (CNSStatus[])response.getDMObjects());
        }
    }

    @Override
    public void cns_rmdir(String path) throws IOException, ReceiveException {
        this.preparePacket(51254017, 7);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendAndReceive(true);
    }

    @Override
    public long cns_creat(String path, String guid, int mode) throws IOException, ReceiveException {
        short mask = 0;
        this.preparePacket(guid != null ? 51254018 : 51254017, 4);
        this.addIDs();
        this.sendBuf.putShort(mask);
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putInt(mode);
        if (guid != null) {
            this.putString(guid);
        }
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        return respBuffer.getLong();
    }

    @Override
    public void cns_mkdir(String path, String guid, int mode) throws IOException, ReceiveException {
        short mask = 0;
        this.preparePacket(guid != null ? 51254018 : 51254017, 5);
        this.addIDs();
        mode &= 0xFFF;
        this.sendBuf.putShort(mask);
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putInt(mode);
        if (guid != null) {
            this.putString(guid);
        }
        this.sendAndReceive(true);
    }

    @Override
    public void cns_delreplica(long file_uniqueid, String guid, String replicaUri) throws IOException, ReceiveException, RuntimeException {
        if (this.openedTransaction) {
            throw new RuntimeException("CNS_DELREPLICA cannot be used inside a transaction");
        }
        this.preparePacket(51254017, 44);
        this.addIDs();
        if (file_uniqueid > 0L) {
            this.sendBuf.putLong(file_uniqueid);
            this.putString(null);
        } else if (guid != null) {
            this.sendBuf.putLong(0L);
            this.putString(guid);
        } else {
            this.sendBuf.putLong(0L);
            this.putString(null);
        }
        this.putString(replicaUri);
        this.sendAndReceive(true);
    }

    @Override
    public void cns_addreplica(long file_uniqueid, String guid, URI sfn, CNSReplicaStatus status, CNSFileType cnsFileType, String poolname, String fs, CNSReplicaType cnsReplicaType, String setname) throws IOException, ReceiveException {
        this.preparePacket(51254020, 43);
        this.addIDs();
        if (file_uniqueid > 0L) {
            this.sendBuf.putLong(file_uniqueid);
            this.putString(null);
        } else {
            this.sendBuf.putLong(0L);
            this.putString(guid);
        }
        this.putString(sfn.getHost() == null ? "UNKNOWN" : sfn.getHost());
        this.putString(sfn.toString());
        this.sendBuf.put(status.getByteValue());
        this.sendBuf.put(cnsFileType.getByteValue());
        this.putString(poolname);
        this.putString(fs);
        this.sendBuf.put(cnsReplicaType.getByteValue());
        this.putString(setname);
        this.sendAndReceive(true);
    }

    @Override
    public CNSLinkInfo[] cns_getlinks(String path, String guid) throws IOException, ReceiveException {
        this.preparePacket(51254017, 71);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.putString(guid);
        CNSLinkInfo[] cnsLinkInfos = (CNSLinkInfo[])this.sendAndReceive(true).getDMObjects();
        return cnsLinkInfos;
    }

    @Override
    public CNSDuInfos cns_du(String path, boolean detailed) throws IOException, ReceiveException {
        this.preparePacket(51254017, 61);
        this.addIDs();
        this.sendBuf.putLong(0L);
        this.putString(path);
        this.sendBuf.putShort((short)(detailed ? 1 : 0));
        ByteBuffer respBuffer = this.sendAndReceive(true).getMsgDataRespBuffer();
        return new CNSDuInfos(respBuffer.getLong(), respBuffer.getLong());
    }
}

