/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.ns;

import fr.maatg.glite.dm.connection.Connection;
import fr.maatg.glite.dm.connection.DMError;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSAccessType;
import fr.maatg.glite.dm.ns.CNSDir;
import fr.maatg.glite.dm.ns.CNSDuInfos;
import fr.maatg.glite.dm.ns.CNSFileReaddir;
import fr.maatg.glite.dm.ns.CNSFileStat;
import fr.maatg.glite.dm.ns.CNSFileStatg;
import fr.maatg.glite.dm.ns.CNSLinkInfo;
import fr.maatg.glite.dm.ns.CNSReplica;
import fr.maatg.glite.dm.ns.CNSStatus;
import fr.maatg.glite.dm.ns.CNSStatusesException;
import fr.maatg.glite.dm.ns.emuns.CNSChecksumType;
import fr.maatg.glite.dm.ns.emuns.CNSFileType;
import fr.maatg.glite.dm.ns.emuns.CNSReplicaStatus;
import fr.maatg.glite.dm.ns.emuns.CNSReplicaType;
import java.io.IOException;
import java.net.URI;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.ietf.jgss.GSSCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCNSConnection
extends Connection {
    protected AbstractCNSConnection(String host, int port, GSSCredential gssCredential) throws IOException, ReceiveException {
        super(host, port, gssCredential);
    }

    protected AbstractCNSConnection(AbstractCNSConnection abstractCNSConnection) {
        super(abstractCNSConnection);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final Connection.DMResponse receive() throws IOException, ReceiveException {
        try {
            block30: {
                respBuffer = null;
                cnsObjects = null;
                cnsObjectsHaveErrors = null;
                block4: while (true) {
                    this.recvBuf.clear();
                    this.recvBuf.limit(12);
                    ret = this.channel.read(this.recvBuf);
                    if (ret == -1) {
                        throw new IOException("The socket connection with the CNS server was closed unexpectedly.");
                    }
                    timeout = 5;
                    delay = 100;
                    while (this.recvBuf.position() < 12 && timeout-- > 0) {
                        try {
                            ret = this.channel.read(this.recvBuf);
                            if (ret == -1) {
                                throw new IOException("The socket connection with the CNS server was closed unexpectedly.");
                            }
                            AbstractCNSConnection.s_logger.debug("\t HEAD: waiting " + delay + " [ms]... AVAIL=" + this.recvBuf.position() + ", EXP=" + 12);
                            Thread.sleep(delay);
                            delay *= 2;
                        }
                        catch (InterruptedException exc) {
                            AbstractCNSConnection.s_logger.error("", (Throwable)exc);
                        }
                    }
                    if (this.recvBuf.position() < 12) {
                        throw new IOException("Connection timeout during header reception.");
                    }
                    this.recvBuf.flip();
                    magic = this.recvBuf.getInt();
                    rep_type = this.recvBuf.getInt();
                    sizeOrError = this.recvBuf.getInt();
                    AbstractCNSConnection.s_logger.debug("Received M/T/S: " + magic + " " + rep_type + " " + sizeOrError);
                    this.recvBuf.mark();
                    this.recvBuf.limit(this.recvBuf.capacity());
                    if (magic == 51715) {
                        if (rep_type != 2 && rep_type != 3 && rep_type != 5) {
                            throw new ReceiveException(sizeOrError, "Received invalid CSEC Type: " + rep_type);
                        }
                        handshakeBuffer = this.recvBuf;
                        if (sizeOrError > 4100) {
                            AbstractCNSConnection.s_logger.debug("Handshake response too large for the default buffer: creating new one (size=" + sizeOrError + ")");
                            handshakeBuffer = ByteBuffer.allocateDirect(sizeOrError);
                            handshakeBuffer.mark();
                        }
                        this.readChannelData(handshakeBuffer, sizeOrError);
                        handshakeBuffer.reset();
                        return new Connection.DMResponse(sizeOrError, handshakeBuffer, null, null);
                    }
                    if (magic != 51254017 && magic != 51254018 && magic != 51254019 && magic != 51254020) break block30;
                    if (sizeOrError > 4100) {
                        throw new ReceiveException(DMError.SEINTERNAL.getErrorNum(), "reply too large: Received M/T/S: " + magic + " " + rep_type + " " + sizeOrError);
                    }
                    if (rep_type == 4 || rep_type == 3) {
                        if (sizeOrError == 0) {
                            return new Connection.DMResponse(0, respBuffer, cnsObjects, cnsObjectsHaveErrors);
                        }
                        dMError = DMError.fromError(sizeOrError);
                        if (dMError == null) {
                            errorMessage = "Unknown CNS error value: " + sizeOrError;
                            throw new ReceiveException(sizeOrError, errorMessage);
                        }
                        throw new ReceiveException(dMError);
                    }
                    if (rep_type == 1) {
                        errorMessage = AbstractCNSConnection.getString(this.recvBuf);
                        throw new ReceiveException(sizeOrError, errorMessage);
                    }
                    if (rep_type == 2) {
                        respBuffer = ByteBuffer.allocateDirect(sizeOrError);
                        this.readChannelData(respBuffer, sizeOrError);
                        respBuffer.flip();
                        continue;
                    }
                    if (rep_type == 5) {
                        respBuffer2 = ByteBuffer.allocateDirect(sizeOrError);
                        this.readChannelData(respBuffer2, sizeOrError);
                        respBuffer2.flip();
                        cnsLinkInfos = new ArrayList<CNSLinkInfo>();
                        while (respBuffer2.hasRemaining()) {
                            cnsLinkInfos.add(new CNSLinkInfo(respBuffer2));
                        }
                        cnsObjectsHaveErrors = Boolean.FALSE;
                        cnsObjects = new CNSLinkInfo[cnsLinkInfos.size()];
                        cnsObjects = cnsLinkInfos.toArray(cnsObjects);
                        cnsLinkInfos = null;
                        continue;
                    }
                    if (rep_type == 6) {
                        throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_REPLIC Not implemented yet");
                    }
                    if (rep_type == 7) {
                        throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_REPLICP Not implemented yet");
                    }
                    if (rep_type == 8) {
                        throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_REPLICX Not implemented yet");
                    }
                    if (rep_type == 9) {
                        throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_REPLICS Not implemented yet");
                    }
                    if (rep_type == 10) {
                        throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_GROUPS Not implemented yet");
                    }
                    if (rep_type != 11) break;
                    respBuffer2 = ByteBuffer.allocateDirect(sizeOrError);
                    this.readChannelData(respBuffer2, sizeOrError);
                    respBuffer2.flip();
                    nbrOfData = respBuffer2.remaining() / 4;
                    cnsObjects = new CNSStatus[nbrOfData];
                    cnsObjectsHaveErrors = Boolean.FALSE;
                    i = 0;
                    while (true) {
                        if (i < nbrOfData) ** break;
                        continue block4;
                        status = respBuffer2.getInt();
                        if (status != 0) {
                            cnsObjectsHaveErrors = Boolean.TRUE;
                        }
                        cnsObjects[i] = new CNSStatus(status);
                        ++i;
                    }
                    break;
                }
                if (rep_type == 12) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_FILEST Not implemented yet");
                }
                if (rep_type == 13) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_GRPINFO Not implemented yet");
                }
                if (rep_type == 14) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_USRINFO Not implemented yet");
                }
                throw new ReceiveException(sizeOrError, "Received invalid MSG Type: " + rep_type);
            }
            throw new ReceiveException(sizeOrError, "Recieved invalid Magic/Type: " + magic + "/" + rep_type);
        }
        catch (BufferUnderflowException e) {
            throw new ReceiveException(-9999, e.toString());
        }
    }

    public abstract void cns_startsess(String var1) throws IOException, ReceiveException;

    public abstract void cns_endsess() throws IOException, ReceiveException;

    public abstract boolean isSessionOpened();

    public abstract void cns_starttrans(String var1) throws IOException, ReceiveException;

    public abstract void cns_endtrans() throws IOException, ReceiveException;

    public abstract void cns_aborttrans() throws IOException, ReceiveException;

    public abstract boolean isTransactionOpened();

    public abstract String cns_ping() throws IOException, ReceiveException;

    public abstract CNSFileStat cns_stat(String var1, long var2) throws IOException, ReceiveException;

    public abstract CNSFileStat cns_lstat(String var1, long var2) throws IOException, ReceiveException;

    public abstract CNSFileStatg cns_statg(String var1, String var2) throws IOException, ReceiveException;

    public abstract CNSFileStatg cns_statr(String var1) throws IOException, ReceiveException;

    public abstract String cns_readlink(String var1) throws IOException, ReceiveException;

    public abstract void cns_symlink(String var1, String var2) throws IOException, ReceiveException;

    public abstract int cns_getgrpid(String var1) throws IOException, ReceiveException;

    public abstract String cns_getgrpnam(int var1) throws IOException, ReceiveException;

    public abstract Collection<String> cns_getgrpnames(int[] var1) throws IOException, ReceiveException;

    public abstract int cns_getusrid(String var1) throws IOException, ReceiveException;

    public abstract String cns_getusrnam(int var1) throws IOException, ReceiveException;

    public abstract void cns_access(String var1, CNSAccessType var2) throws IOException, ReceiveException;

    public abstract CNSDir cns_opendirg(String var1, String var2) throws IOException, ReceiveException;

    public CNSDir cns_opendir(String path) throws IOException, ReceiveException {
        return this.cns_opendirg(path, null);
    }

    public abstract void cns_closedir() throws IOException, ReceiveException;

    public abstract Collection<CNSFileReaddir> cns_readdir(CNSDir var1) throws IOException, ReceiveException;

    public abstract void cns_delete(String var1) throws IOException, ReceiveException;

    public abstract void cns_undelete(String var1) throws IOException, ReceiveException;

    public abstract void cns_unlink(String var1) throws IOException, ReceiveException;

    public abstract void cns_setfsize(String var1, long var2, long var4, CNSChecksumType var6, String var7) throws IOException, ReceiveException;

    public abstract void cns_rename(String var1, String var2) throws IOException, ReceiveException;

    public abstract void cns_chmod(String var1, int var2) throws IOException, ReceiveException;

    public abstract void cns_chown(String var1, int var2, int var3) throws IOException, ReceiveException;

    public abstract void cns_lchown(String var1, int var2, int var3) throws IOException, ReceiveException;

    public abstract Collection<CNSReplica> cns_listreplica(String var1, String var2, short var3, short[] var4) throws IOException, ReceiveException;

    public void cns_delfilesbyguid(String[] guids, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        this.cns_delfiles((short)0, guids, force);
    }

    public void cns_delfilesbyname(String[] filenames, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        this.cns_delfiles((short)1, filenames, force);
    }

    protected abstract void cns_delfiles(short var1, String[] var2, boolean var3) throws IOException, ReceiveException, CNSStatusesException, RuntimeException;

    public abstract void cns_rmdir(String var1) throws IOException, ReceiveException;

    public abstract long cns_creat(String var1, String var2, int var3) throws IOException, ReceiveException;

    public abstract void cns_mkdir(String var1, String var2, int var3) throws IOException, ReceiveException;

    public abstract void cns_delreplica(long var1, String var3, String var4) throws IOException, ReceiveException, RuntimeException;

    public abstract void cns_addreplica(long var1, String var3, URI var4, CNSReplicaStatus var5, CNSFileType var6, String var7, String var8, CNSReplicaType var9, String var10) throws IOException, ReceiveException;

    public abstract CNSLinkInfo[] cns_getlinks(String var1, String var2) throws IOException, ReceiveException;

    public abstract CNSDuInfos cns_du(String var1, boolean var2) throws IOException, ReceiveException;
}

