/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.dpm;

import fr.maatg.glite.dm.connection.Connection;
import fr.maatg.glite.dm.connection.DMError;
import fr.maatg.glite.dm.connection.DMObject;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.dpm.DPMFs;
import fr.maatg.glite.dm.dpm.DPMPool;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.ietf.jgss.GSSCredential;

public class DPMConnection
extends Connection {
    public DPMConnection(String host, int port, GSSCredential gssCredential) throws IOException, ReceiveException {
        super(host, port, gssCredential);
    }

    protected final Connection.DMResponse receive() throws IOException, ReceiveException {
        try {
            int sizeOrError;
            int rep_type;
            int magic;
            block29: {
                block30: {
                    ByteBuffer respBuffer2;
                    ByteBuffer respBuffer = null;
                    DMObject[] dpmObjects = null;
                    Boolean dpmObjectsHaveErrors = null;
                    while (true) {
                        int i;
                        int nbstruct;
                        this.recvBuf.clear();
                        this.recvBuf.limit(12);
                        int ret = this.channel.read(this.recvBuf);
                        if (ret == -1) {
                            throw new IOException("The socket connection with the DPM server was closed unexpectedly.");
                        }
                        int timeout = 5;
                        int delay = 100;
                        while (this.recvBuf.position() < 12 && timeout-- > 0) {
                            try {
                                ret = this.channel.read(this.recvBuf);
                                if (ret == -1) {
                                    throw new IOException("The socket connection with the DPM server was closed unexpectedly.");
                                }
                                s_logger.debug("\t HEAD: waiting " + delay + " [ms]... AVAIL=" + this.recvBuf.position() + ", EXP=" + 12);
                                Thread.sleep(delay);
                                delay *= 2;
                            }
                            catch (InterruptedException exc) {
                                s_logger.error("", (Throwable)exc);
                            }
                        }
                        if (this.recvBuf.position() < 12) {
                            throw new IOException("Connection timeout during header reception.");
                        }
                        this.recvBuf.flip();
                        magic = this.recvBuf.getInt();
                        rep_type = this.recvBuf.getInt();
                        sizeOrError = this.recvBuf.getInt();
                        s_logger.debug("Received M/T/S: " + magic + " " + rep_type + " " + sizeOrError);
                        this.recvBuf.mark();
                        this.recvBuf.limit(this.recvBuf.capacity());
                        if (magic == 51715) {
                            if (rep_type != 2 && rep_type != 3 && rep_type != 5) {
                                throw new ReceiveException(sizeOrError, "Received invalid CSEC Type: " + rep_type);
                            }
                            ByteBuffer handshakeBuffer = this.recvBuf;
                            if (sizeOrError > 4100) {
                                s_logger.debug("Handshake response too large for the default buffer: creating new one (size=" + sizeOrError + ")");
                                handshakeBuffer = ByteBuffer.allocateDirect(sizeOrError);
                                handshakeBuffer.mark();
                            }
                            this.readChannelData(handshakeBuffer, sizeOrError);
                            handshakeBuffer.reset();
                            return new Connection.DMResponse(sizeOrError, handshakeBuffer, null, null);
                        }
                        if (magic != 68160769 && magic != 68160770 && magic != 68160771) break block29;
                        if (sizeOrError > 4100) {
                            throw new ReceiveException(DMError.SEINTERNAL.getErrorNum(), "reply too large: Received M/T/S: " + magic + " " + rep_type + " " + sizeOrError);
                        }
                        if (rep_type == 4 || rep_type == 3) {
                            if (sizeOrError == 0) {
                                return new Connection.DMResponse(0, respBuffer, dpmObjects, dpmObjectsHaveErrors);
                            }
                            DMError dpmError = DMError.fromError(sizeOrError);
                            if (dpmError == null) {
                                String errorMessage = "Unknown DPM error value: " + sizeOrError;
                                throw new ReceiveException(sizeOrError, errorMessage);
                            }
                            throw new ReceiveException(dpmError);
                        }
                        if (rep_type == 1) {
                            String errorMessage = DPMConnection.getString(this.recvBuf);
                            throw new ReceiveException(sizeOrError, errorMessage);
                        }
                        if (rep_type == 2) {
                            respBuffer = ByteBuffer.allocateDirect(sizeOrError);
                            this.readChannelData(respBuffer, sizeOrError);
                            respBuffer.flip();
                            continue;
                        }
                        if (rep_type == 7) {
                            throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_COPY Not implemented yet");
                        }
                        if (rep_type == 9) {
                            respBuffer2 = ByteBuffer.allocateDirect(sizeOrError);
                            this.readChannelData(respBuffer2, sizeOrError);
                            respBuffer2.flip();
                            nbstruct = respBuffer2.getInt();
                            dpmObjects = new DPMFs[nbstruct];
                            dpmObjectsHaveErrors = Boolean.FALSE;
                            for (i = 0; i < nbstruct; ++i) {
                                dpmObjects[i] = new DPMFs(respBuffer2);
                            }
                            if (!respBuffer2.hasRemaining()) continue;
                            throw new IOException("MSG_FS: Something remains to be read (" + respBuffer2.remaining() + " byte(s))");
                        }
                        if (rep_type == 5) {
                            throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_GET Not implemented yet");
                        }
                        if (rep_type != 10) break block30;
                        respBuffer2 = ByteBuffer.allocateDirect(sizeOrError);
                        this.readChannelData(respBuffer2, sizeOrError);
                        respBuffer2.flip();
                        nbstruct = respBuffer2.getInt();
                        dpmObjects = new DPMPool[nbstruct];
                        dpmObjectsHaveErrors = Boolean.FALSE;
                        for (i = 0; i < nbstruct; ++i) {
                            dpmObjects[i] = new DPMPool(respBuffer2);
                        }
                        if (respBuffer2.hasRemaining()) break;
                    }
                    throw new IOException("MSG_POOL: Something remains to be read (" + respBuffer2.remaining() + " byte(s))");
                }
                if (rep_type == 6) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_PUT Not implemented yet");
                }
                if (rep_type == 12) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_REQIDS Not implemented yet");
                }
                if (rep_type == 13) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_SPCMD Not implemented yet");
                }
                if (rep_type == 14) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_SPCTKN Not implemented yet");
                }
                if (rep_type == 11) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_SUMMARY Not implemented yet");
                }
                if (rep_type == 8) {
                    throw new ReceiveException(DMError.UNKOWN_ERROR.getErrorNum(), "MSG_SURLST Not implemented yet");
                }
                throw new ReceiveException(sizeOrError, "Received invalid MSG Type: " + rep_type);
            }
            throw new ReceiveException(sizeOrError, "Recieved invalid Magic/Type: " + magic + "/" + rep_type);
        }
        catch (BufferUnderflowException e) {
            throw new ReceiveException(-9999, e.toString());
        }
    }

    public DPMPool[] dpm_getpools() throws IOException, ReceiveException {
        this.preparePacket(68160771, 1);
        this.addIDs();
        DPMPool[] dpmPools = (DPMPool[])this.sendAndReceive(true).getDMObjects();
        return dpmPools;
    }

    public DPMFs dpm_getpoolfs(String poolName) throws IOException, ReceiveException {
        this.preparePacket(68160769, 5);
        this.addIDs();
        this.putString(poolName);
        DPMFs[] dpmFss = (DPMFs[])this.sendAndReceive(true).getDMObjects();
        if (dpmFss.length > 1) {
            throw new RuntimeException("dpm_getpoolfs returned more than 1 DPMFs objects!");
        }
        if (dpmFss.length == 0) {
            return null;
        }
        return dpmFss[0];
    }
}

