/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DMError {
    ENOENT(2, "No such file or directory"),
    E2BIG(7, "Argument list too long"),
    EBADF(9, "Bad file number"),
    ENOMEM(12, "Out of memory"),
    EACCES(13, "Permission denied"),
    EFAULT(14, "Bad address"),
    EEXIST(17, "File exists"),
    ENOTDIR(20, "Not a directory"),
    EISDIR(21, "Is a directory"),
    EINVAL(22, "Invalid argument"),
    EFBIG(27, "File too large"),
    ENOSPC(28, "No space left on device"),
    ERANGE(34, "Math result not representable"),
    ENAMETOOLONG(36, "File name too long"),
    ETIMEDOUT(110, "Connection timed out"),
    ENOTSUP(524, "Not supported"),
    SENOSHOST(1001, "Host unknown"),
    SENOSSERV(1002, "Service unknown"),
    SENOTRFILE(1003, "Not a remote file"),
    SETIMEDOUT(1004, "Has timed out"),
    SEBADFFORM(1005, "Bad fortran format specifier"),
    SEBADFOPT(1006, "Bad fortran option specifier"),
    SEINCFOPT(1007, "Incompatible fortran options"),
    SENAMETOOLONG(1008, "File name too long"),
    SENOCONFIG(1009, "Can't open configuration file"),
    SEBADVERSION(1010, "Version ID mismatch"),
    SEUBUF2SMALL(1011, "User buffer too small"),
    SEMSGINVRNO(1012, "Invalid reply number"),
    SEUMSG2LONG(1013, "User message too long"),
    SEENTRYNFND(1014, "Entry not found"),
    SEINTERNAL(1015, "Internal error"),
    SECONNDROP(1016, "Connection closed by rem. end"),
    SEBADIFNAM(1017, "Can't get interface name"),
    SECOMERR(1018, "Communication error"),
    SENOMAPDB(1019, "Can't open mapping database"),
    SENOMAPFND(1020, "No user mapping"),
    SERTYEXHAUST(1021, "Retry count exhausted"),
    SEOPNOTSUP(1022, "Operation not supported"),
    SEWOULDBLOCK(1023, "Resource temporarily unavailable"),
    SEINPROGRESS(1024, "Operation now in progress"),
    SECTHREADINIT(1025, "Cthread initialization error"),
    SECTHREADERR(1026, "Thread interface call error"),
    SESYSERR(1027, "System error"),
    SEADNSINIT(1028, "adns_init() error"),
    SEADNSSUBMIT(1029, "adns_submit() error"),
    SEADNS(1030, "adns resolving error"),
    SEADNSTOOMANY(1031, "adns returned more than one entry"),
    SENOTADMIN(1032, "requestor is not administrator"),
    SEUSERUNKN(1033, "User unknown"),
    SEDUPKEY(1034, "Duplicate key value"),
    SEENTRYEXISTS(1035, "The entry already exists"),
    SEGROUPUNKN(1036, "Group Unknown"),
    SECHECKSUM(1037, "Bad checksum"),
    SELOOP(1038, "Too many symbolic links encountered"),
    EDB_A_ESESSION(1201, "Cdb api: invalid session"),
    EDB_A_EDB(1202, "Cdb api: invalid db"),
    EDB_A_EINVAL(1203, "Cdb api: invalid value"),
    EDB_A_RESHOST(1204, "Cdb api: host res error"),
    EDB_A_TOOMUCH(1205, "Cdb api: data size rejected"),
    EDB_AS_SOCKET(1206, "Cdb api system: socket() error"),
    EDB_AS_SOCKOPT(1207, "Cdb api system: [set/get]sockopt() error"),
    EDB_AS_MALLOC(1208, "Cdb api system: malloc() error"),
    EDB_A_NOERROR(1209, "Cdb api: no last error"),
    EDB_A_IEINVAL(1200, "Cdb api: interface invalid value"),
    EDB_AS_BIND(1201, "Cdb api: bind() error"),
    EDB_AS_LISTEN(1202, "Cdb api: listen() error"),
    EDB_AS_GETSOCKNAME(1203, "Cdb api: getsockname() error"),
    EDB_AS_ACCEPT(1204, "Cdb api: accept() error"),
    EDB_AS_GETPEERNAME(1205, "Cdb api: getpeername() error"),
    EDB_A_WHOISIT(1206, "Cdb api: Connection from bad host"),
    EDB_D_EINVAL(1220, "Cdb daemon: invalid value"),
    EDB_D_EAGAIN(1221, "Cdb daemon: yet done"),
    EDB_D_AUTH(1222, "Cdb daemon: unauthorized"),
    EDB_D_LOGIN(1223, "Cdb daemon: login refused"),
    EDB_D_PWDCORR(1224, "Cdb daemon: pwd file corrupted"),
    EDB_D_ANA(1225, "Cdb daemon: db analysis error"),
    EDB_D_HASHSIZE(1226, "Cdb daemon: bad hash size"),
    EDB_D_UNKNOWN(1227, "Cdb daemon: unkn. db/table/key"),
    EDB_D_NOLOCK(1228, "Cdb daemon: lock is required"),
    EDB_D_CORRUPT(1229, "Cdb daemon: probably corrupted"),
    EDB_D_TOOMUCH(1230, "Cdb daemon: data size rejected"),
    EDB_D_ENOENT(1231, "Cdb daemon: no entry"),
    EDB_D_ETYPE(1232, "Cdb daemon: unknown member type"),
    EDB_D_EVALUE(1233, "Cdb daemon: unknown member val"),
    EDB_D_NULLVALUE(1234, "Cdb daemon: null member value"),
    EDB_D_LOCK(1235, "Cdb daemon: cannot gain lock"),
    EDB_D_FREE(1236, "Cdb daemon: unsafe free attempt"),
    EDB_D_SHUTDOWN(1237, "Cdb daemon: shutdown in progress"),
    EDB_D_DEADLOCK(1238, "Cdb daemon: shutdown in progress"),
    EDB_D_EXIST(1239, "Cdb daemon: yet exists"),
    EDB_D_NOSPC(1240, "Cdb daemon: no more space"),
    EDB_D_DUMPEND(1241, "Cdb daemon: end of dump"),
    EDB_D_UNIQUE(1242, "Cdb daemon: uniqued key yet exist"),
    EDB_D_LISTEND(1243, "Cdb daemon: end of list"),
    EDB_D_NOTDUMP(1244, "Cdb daemon: not in dump mode"),
    EDB_D_DNSCHECK(1245, "Cdb daemon: double DNS check error"),
    EDB_D_REJECTED(1246, "Cdb daemon: Connection rejected (not authorised)"),
    EDB_D_INIT(1247, "Cdb daemon: init in progress"),
    EDB_D_INCONST(1248, "Cdb daemon: Cdb daemon: inconsistent request (unstop and no previous stop, unfreeze and no previous freeze)"),
    EDB_D_FREEHASHSIZE(1249, "Cdb daemon: bad free hash size"),
    EDB_DS_MALLOC(1250, "Cdb daemon system: malloc() error"),
    EDB_DS_CALLOC(1251, "Cdb daemon system: calloc() error"),
    EDB_DS_REALLOC(1252, "Cdb daemon system: realloc() error"),
    EDB_DS_OPEN(1253, "Cdb daemon system: open() error"),
    EDB_DS_FSTAT(1254, "Cdb daemon system: fstat() error"),
    EDB_DS_LSEEK(1255, "Cdb daemon system: lseek() error"),
    EDB_DS_READ(1256, "Cdb daemon system: read() error"),
    EDB_DS_WRITE(1257, "Cdb daemon system: write() error"),
    EDB_DS_RENAME(1258, "Cdb daemon system: rename() error"),
    EDB_DS_FTRUNC(1259, "Cdb daemon system: ftruncate() error"),
    EDB_DS_TMPNAM(1260, "Cdb daemon system: tmpnam() error"),
    EDB_DS_FCNTL(1261, "Cdb daemon system: fcntl() error"),
    EDB_DS_MKDIR(1262, "Cdb daemon system: mkdir() error"),
    EDB_DS_TIMES(1263, "Cdb daemon system: times() error"),
    EDB_DS_SYSCONF(1264, "Cdb daemon system: sysconf() err/unav"),
    EDB_DS_GETHOSTNAME(1265, "Cdb daemon system: gethostname() error"),
    EDB_DS_GETPEERNAME(1266, "Cdb daemon system: getpeername() error"),
    EDB_DS_INET_NTOA(1267, "Cdb daemon system: getpeername() error"),
    EDB_DS_REMOVE(1268, "Cdb daemon system: remove() error"),
    EDB_DS_SIGACTION(1269, "Cdb daemon system: sigaction() error"),
    EDB_DS_GETSOCKNAME(1270, "Cdb daemon system: getsockname() error"),
    EDB_DS_BIND(1271, "Cdb daemon system: bind() error"),
    EDB_DS_LISTEN(1272, "Cdb daemon system: listen() error"),
    EDB_DS_CONNECT(1273, "Cdb daemon system: connect() error"),
    EDB_DS_SOCKET(1274, "Cdb daemon system: socket() error"),
    EDB_DS_SOCKOPT(1275, "Cdb daemon system: [set/get]sockopt() error"),
    EDB_D_RESHOST(1276, "Cdb daemon: host res error"),
    EDB_D_REQSIZE(1277, "Cdb daemon: request too big"),
    EDB_C_EINVAL(1280, "Cdb config: invalid value"),
    EDB_C_ENOENT(1281, "Cdb config: configuration error"),
    EDB_C_TOOMUCH(1282, "Cdb config: conf. size rejected"),
    EDB_CS_GETHOSTNAME(1283, "Cdb config system: gethostname() error"),
    EDB_NOMOREDB(1290, "Cdb: nomoredb (the API retries automatically in such a case so you should never see this error number)"),
    EMSMSGU2REP(1301, "msg daemon unable to reply"),
    EMSMSGSYERR(1302, "msg daemon system error"),
    EMSNOPERM(1303, "Permission denied"),
    ENSNACT(1401, "name server not active or service being drained"),
    ERFNORCODE(1501, "RFIO communication error"),
    ERFHOSTREFUSED(1502, "RFIO rejected connect attempt"),
    ERFXHOST(1503, "Cross-host link (rename())"),
    ERFPROTONOTSUP(1504, "RFIO protocol not supported"),
    ERTTMSERR(1601, "TMS call failed"),
    ERTBLKSKPD(1602, "Blocks were skipped in file"),
    ERTTPE_LSZ(1603, "Blocks skipped and file truncated"),
    ERTMNYPARY(1604, "Too many skipped blocks"),
    ERTLIMBYSZ(1605, "File limited by size"),
    ERTUSINTR(1606, "Request interrupted by user"),
    ERTOPINTR(1607, "Request interrupted by operator"),
    ERTNOTCLIST(1608, "Request list is not circular"),
    ERTBADREQ(1609, "Bad request structure"),
    ESTCLEARED(1701, "aborted by stageclr"),
    ESTENOUGHF(1702, "Not enough free space"),
    ESTLNKNCR(1703, "symbolic link not created"),
    ESTLNKNSUP(1704, "symbolic link not supported"),
    ESTNACT(1705, "Stager not active"),
    ESTGROUP(1706, "Your group is invalid"),
    ESTGRPUSER(1707, "No GRPUSER in configuration"),
    ESTUSER(1708, "Invalid user"),
    ESTHSMHOST(1709, "HSM HOST not specified"),
    ESTTMSCHECK(1710, "tmscheck error"),
    ESTLINKNAME(1711, "User link name processing error"),
    ESTWRITABLE(1712, "User path in a non-writable directory"),
    ESTKILLED(1713, "aborted by kill"),
    ESTMEM(1714, "request too long (api)"),
    ESTCONF(1715, "stage configuration error"),
    ESQTMSNOTACT(1801, "TMS not active"),
    ETDNP(1901, "daemon not available"),
    ETSYS(1902, "system error"),
    ETPRM(1903, "bad parameter"),
    ETRSV(1904, "reserv already issued"),
    ETNDV(1905, "too many drives requested"),
    ETIDG(1906, "invalid device group name"),
    ETNRS(1907, "reserv not done"),
    ETIDN(1908, "no drive with requested characteristics"),
    ETLBL(1909, "bad label structure"),
    ETFSQ(1910, "bad file sequence number"),
    ETINTR(1911, "interrupted by user"),
    ETEOV(1912, "EOV found in multivolume set"),
    ETRLSP(1913, "release pending"),
    ETBLANK(1914, "blank tape"),
    ETCOMPA(1915, "compatibility problem"),
    ETHWERR(1916, "device malfunction"),
    ETPARIT(1917, "parity error"),
    ETUNREC(1918, "unrecoverable media error"),
    ETNOSNS(1919, "no sense"),
    ETRSLT(1920, "reselect server"),
    ETVBSY(1921, "volume busy or inaccessible"),
    ETDCA(1922, "drive currently assigned"),
    ETNRDY(1923, "drive not ready"),
    ETABSENT(1924, "volume absent"),
    ETARCH(1925, "volume archived"),
    ETHELD(1926, "volume held or disabled"),
    ETNXPD(1927, "file not expired"),
    ETOPAB(1928, "operator cancel"),
    ETVUNKN(1929, "volume unknown"),
    ETWLBL(1930, "wrong label type"),
    ETWPROT(1931, "cartridge write protected"),
    ETWVSN(1932, "wrong vsn"),
    ETBADMIR(1933, "Tape has a bad MIR"),
    EVMGRNACT(2001, "volume manager not active or service being drained"),
    EVQSYERR(2101, "Failed system call"),
    EVQINCONSIST(2102, "Internal DB inconsistency"),
    EVQREPLICA(2103, "DB replication failed"),
    EVQNOVOL(2104, "No volume request queued"),
    EVQNODRV(2105, "No free drive available"),
    EVQNOSVOL(2106, "Specified vol. req. not found"),
    EVQNOSDRV(2107, "Specified drv. req. not found"),
    EVQALREADY(2108, "Specified vol. req. already exists"),
    EVQUNNOTUP(2109, "Unit not up"),
    EVQBADSTAT(2110, "Bad unit status request"),
    EVQBADID(2111, "Incorrect vol.req or job ID"),
    EVQBADJOBID(2112, "Incorrect job ID"),
    EVQNOTASS(2113, "Unit not assigned"),
    EVQBADVOLID(2114, "Attempt to mount with wrong VOLID"),
    EVQREQASS(2115, "Attempt to delete an assigned req"),
    EVQDGNINVL(2116, "Vol. req. for non-existing DGN"),
    EVQPIPEFULL(2117, "Replication pipe is full"),
    EVQHOLD(2118, "Server is held"),
    EVQEOQREACHED(2119, "End of query reached"),
    ERMCNACT(2201, "Remote SCSI media changer server not active or service being drained"),
    ERMCRBTERR(2202, "Remote SCSI media changer error"),
    ERMCUNREC(2203, "Remote SCSI media changer unrec. error"),
    ERMCSLOWR(2204, "Remote SCSI media changer error (slow retry)"),
    ERMCFASTR(2205, "Remote SCSI media changer error (fast retry)"),
    ERMCDFORCE(2206, "Remote SCSI media changer error (demount force)"),
    ERMCDDOWN(2207, "Remote SCSI media changer error (drive down)"),
    ERMCOMSGN(2208, "Remote SCSI media changer error (ops message)"),
    ERMCOMSGS(2209, "Remote SCSI media changer error (ops message + retry)"),
    ERMCOMSGR(2210, "Remote SCSI media changer error (ops message + wait)"),
    ERMCUNLOAD(2211, "Remote SCSI media changer error (unload + demount)"),
    EMON_SYSTEM(2301, "System error"),
    EMON_NO_HOST(2302, "Monitor Host not specified"),
    EMON_NO_PORT(2303, "Monitor Port not specified"),
    EMON_NO_CLIENTPORT(2304, "No port for client requests defined in the configuration"),
    ECUPVNACT(2401, "UPV not active or service being drained"),
    EDPMNACT(2601, "DPM not active or service being drained"),
    ESEC_SYSTEM(2701, "System error in the security package"),
    ESEC_BAD_CREDENTIALS(2702, "Bad credentials"),
    ESEC_NO_CONTEXT(2703, "Could not establish context"),
    ESEC_BAD_MAGIC(2704, "Bad magic number"),
    ESEC_NO_USER(2705, "Could not map username to uid/gid"),
    ESEC_NO_PRINC(2706, "Could not map principal to username"),
    ESEC_NO_SECMECH(2707, "Could not load security mechanism"),
    ESEC_CTX_NOT_INITIALIZED(2708, "Context not initialized"),
    ESEC_PROTNOTSUPP(2709, "Security protocol not supported"),
    ESEC_NO_SVC_NAME(2710, "Service name not set"),
    ESEC_NO_SVC_TYPE(2711, "Service type not set"),
    ESEC_NO_SECPROT(2712, "Could not lookup security protocol"),
    ESEC_BAD_CSEC_VERSION(2713, "Csec incompatability"),
    ESEC_BAD_PEER_RESP(2714, "Unexpected response from peer"),
    UNKOWN_ERROR(9999, "Unknown server error");

    private String message;
    private int errorNum;

    private DMError(int errorNum, String message) {
        this.errorNum = errorNum;
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public int getErrorNum() {
        return this.errorNum;
    }

    void setMessage(String message) {
        this.message = message;
    }

    void setErrorNum(int errorNum) {
        this.errorNum = errorNum;
    }

    public String toString() {
        return "Error " + this.errorNum + ": " + this.message;
    }

    public static DMError fromError(int errorNum) {
        DMError[] dmErrors = DMError.values();
        for (int i = 0; i < dmErrors.length; ++i) {
            if (dmErrors[i].errorNum != errorNum) continue;
            return dmErrors[i];
        }
        return null;
    }
}

