/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm.connection;

import fr.maatg.glite.dm.connection.ConnConstants;
import fr.maatg.glite.dm.connection.DMObject;
import fr.maatg.glite.dm.connection.ReceiveException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSManagerImpl;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Connection {
    protected static Logger s_logger = LoggerFactory.getLogger(Connection.class);
    protected ByteBuffer sendBuf;
    protected final ByteBuffer recvBuf;
    protected SocketChannel channel;
    protected final GSSCredential gssCredential;
    protected final String host;
    protected final int port;

    protected Connection(String host, int port, GSSCredential gssCredential) throws IOException, ReceiveException {
        this.sendBuf = ByteBuffer.allocateDirect(10240);
        this.recvBuf = ByteBuffer.allocateDirect(4100);
        this.host = host;
        this.port = port;
        this.gssCredential = gssCredential;
        this.channel = SocketChannel.open(new InetSocketAddress(host, port));
        s_logger.debug("Establishing connection with server " + host + ":" + port);
        try {
            this.authenticate(this.sendBuf);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("authenticate()");
            throw e;
        }
        s_logger.debug("Connection established with server " + host + ":" + port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    protected Connection(Connection connection) {
        this.channel = connection.channel;
        this.recvBuf = connection.recvBuf;
        this.sendBuf = connection.sendBuf;
        this.gssCredential = connection.gssCredential;
        this.host = connection.host;
        this.port = connection.port;
    }

    protected void addIDs() {
        this.addIDs(this.sendBuf);
    }

    protected void addIDs(ByteBuffer byteBuffer) {
        int uid = 0;
        int gid = 0;
        byteBuffer.putInt(uid);
        byteBuffer.putInt(gid);
    }

    protected final void authenticate(ByteBuffer byteBuffer) throws IOException, ReceiveException {
        this.preparePacket(byteBuffer, 51715, 1);
        byteBuffer.put(ConnConstants.REQUEST_GSI_TOKEN);
        this.send(byteBuffer, false);
        this.receive();
        GlobusGSSManagerImpl manager = new GlobusGSSManagerImpl();
        try {
            ExtendedGSSContext secureContext = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, this.gssCredential, 43200);
            secureContext.requestMutualAuth(true);
            secureContext.requestAnonymity(false);
            secureContext.requestConf(false);
            secureContext.requestCredDeleg(false);
            secureContext.setOption(GSSConstants.GSS_MODE, (Object)GSIConstants.MODE_GSI);
            secureContext.setOption(GSSConstants.REJECT_LIMITED_PROXY, (Object)Boolean.FALSE);
            byte[] recvToken = new byte[]{};
            while (!secureContext.isEstablished()) {
                byte[] sendToken = secureContext.initSecContext(recvToken, 0, recvToken.length);
                if (sendToken != null) {
                    this.preparePacket(byteBuffer, 51715, 3);
                    byteBuffer.put(sendToken);
                    this.send(byteBuffer, false);
                }
                if (secureContext.isEstablished()) continue;
                DMResponse response = this.receive();
                int l = response.getResponseCode();
                recvToken = new byte[l];
                response.getMsgDataRespBuffer().get(recvToken);
            }
        }
        catch (GSSException e) {
            s_logger.warn(e.toString());
            throw new IOException("Error processing credential");
        }
        s_logger.debug("Secure Context established!");
    }

    protected DMResponse sendAndReceive(boolean includeHeaderInLength) throws IOException, ReceiveException {
        this.send(this.sendBuf, includeHeaderInLength);
        return this.receive();
    }

    protected final void send(ByteBuffer byteBuffer, boolean includeHeaderInLength) throws IOException {
        int posNow = byteBuffer.position();
        byteBuffer.reset();
        if (includeHeaderInLength) {
            byteBuffer.putInt(posNow);
        } else {
            byteBuffer.putInt(posNow - 12);
        }
        byteBuffer.position(posNow);
        byteBuffer.flip();
        int writtenBites = this.channel.write(byteBuffer);
        if (writtenBites != posNow) {
            throw new IOException("Socket Error: writtenBites=" + writtenBites + " - bytesToWrite=" + posNow);
        }
    }

    protected abstract DMResponse receive() throws IOException, ReceiveException;

    protected final void readChannelData(ByteBuffer respBuffer, int dataSize) throws IOException {
        int ret = this.channel.read(respBuffer);
        if (ret == -1) {
            throw new IOException("The socket connection with the server was closed unexpectedly.");
        }
        int timeout = 10;
        int delay = 1;
        while (respBuffer.position() < dataSize && timeout-- > 0) {
            s_logger.debug("Limit: " + respBuffer.limit() + ", Pos: " + respBuffer.position() + " MinContent: " + dataSize + " Avail " + respBuffer.remaining());
            try {
                ret = this.channel.read(respBuffer);
                if (ret == -1) {
                    throw new IOException("The socket connection with the server was closed unexpectedly.");
                }
                if (delay > 3) {
                    s_logger.debug("\t DATA: waiting " + delay + " [ms]... AVAIL=" + respBuffer.position() + ", EXP=" + dataSize);
                    Thread.sleep(delay);
                }
                delay *= 2;
            }
            catch (InterruptedException exc) {
                s_logger.error("", (Throwable)exc);
            }
        }
        s_logger.debug("Limit: " + respBuffer.limit() + ", Pos: " + respBuffer.position() + " MinContent: " + dataSize + " Avail " + respBuffer.remaining());
        if (respBuffer.position() < dataSize) {
            throw new IOException("Connection timeout during data reception.");
        }
    }

    protected final void putString(String value) {
        this.putString(this.sendBuf, value);
    }

    protected final void putString(ByteBuffer byteBuffer, String value) {
        try {
            if (value != null) {
                byteBuffer.put(value.getBytes("UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            s_logger.warn(e.toString());
        }
        byteBuffer.put((byte)0);
    }

    public static final String getString(ByteBuffer byteBuffer) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte b = byteBuffer.get();
        while (b != 0) {
            builder.append((char)b);
            b = byteBuffer.get();
        }
        return builder.toString();
    }

    protected void preparePacket(int magic, int command) {
        this.preparePacket(this.sendBuf, magic, command);
    }

    protected void preparePacket(ByteBuffer byteBuffer, int magic, int command) {
        byteBuffer.clear();
        byteBuffer.putInt(magic);
        byteBuffer.putInt(command);
        byteBuffer.mark();
        byteBuffer.putInt(0);
    }

    public final void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            s_logger.warn(e.toString());
            throw e;
        }
    }

    protected class DMResponse {
        private final int responseCode;
        private ByteBuffer msgDataRespBuffer;
        private DMObject[] dmObjects;
        private Boolean dmObjectsHaveErrors;

        public DMResponse(int responseCode, ByteBuffer dataRespBuffer, DMObject[] dmObjects, Boolean dmObjectsHaveErrors) {
            this.responseCode = responseCode;
            this.msgDataRespBuffer = dataRespBuffer;
            this.dmObjects = dmObjects;
            this.dmObjectsHaveErrors = dmObjectsHaveErrors;
        }

        public ByteBuffer getMsgDataRespBuffer() {
            return this.msgDataRespBuffer;
        }

        public DMObject[] getDMObjects() {
            return this.dmObjects;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public boolean dmObjectsHaveErrors() {
            return this.dmObjectsHaveErrors == null ? false : this.dmObjectsHaveErrors;
        }
    }
}

