/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm;

import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.dpm.DPMConnection;
import fr.maatg.glite.dm.dpm.DPMFs;
import fr.maatg.glite.dm.dpm.DPMPool;
import java.io.IOException;
import org.ietf.jgss.GSSCredential;

public class DPMConnector {
    private final String server;
    private final int port;
    private final GSSCredential gssCredential;

    private DPMConnector(String host, int port, GSSCredential gssCredential) throws IOException, ReceiveException {
        this.server = host;
        this.port = port;
        this.gssCredential = gssCredential;
    }

    public static DPMConnector getInstance(String host, int port, GSSCredential gssCredential) throws IllegalArgumentException, IOException, ReceiveException {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("The DPM server host must be set.");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("The DPM server port must be greater than 0.");
        }
        return new DPMConnector(host, port, gssCredential);
    }

    public DPMConnection getNewConnection() throws IOException, ReceiveException {
        return new DPMConnection(this.server, this.port, this.gssCredential);
    }

    public void close(DPMConnection connection) throws IOException {
        connection.close();
    }

    public DPMPool[] getPools() throws IOException, ReceiveException {
        DPMConnection connection = new DPMConnection(this.server, this.port, this.gssCredential);
        try {
            DPMPool[] dPMPoolArray = connection.dpm_getpools();
            return dPMPoolArray;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getPools()");
            throw e;
        }
        finally {
            this.close(connection);
        }
    }

    public DPMFs getPoolFs(String poolName) throws IOException, ReceiveException {
        DPMConnection connection = new DPMConnection(this.server, this.port, this.gssCredential);
        try {
            DPMFs dPMFs = connection.dpm_getpoolfs(poolName);
            return dPMFs;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getPoolFs()");
            throw e;
        }
        finally {
            this.close(connection);
        }
    }
}

