/*
 * Decompiled with CFR 0.152.
 */
package fr.maatg.glite.dm;

import fr.maatg.glite.dm.connection.DMError;
import fr.maatg.glite.dm.connection.ReceiveException;
import fr.maatg.glite.dm.ns.CNSAccessType;
import fr.maatg.glite.dm.ns.CNSConnection;
import fr.maatg.glite.dm.ns.CNSDir;
import fr.maatg.glite.dm.ns.CNSDuInfos;
import fr.maatg.glite.dm.ns.CNSFileReaddir;
import fr.maatg.glite.dm.ns.CNSFileStat;
import fr.maatg.glite.dm.ns.CNSFileStatg;
import fr.maatg.glite.dm.ns.CNSLinkInfo;
import fr.maatg.glite.dm.ns.CNSReplica;
import fr.maatg.glite.dm.ns.CNSStatusesException;
import fr.maatg.glite.dm.ns.emuns.CNSChecksumType;
import fr.maatg.glite.dm.ns.emuns.CNSFileType;
import fr.maatg.glite.dm.ns.emuns.CNSReplicaStatus;
import fr.maatg.glite.dm.ns.emuns.CNSReplicaType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.ietf.jgss.GSSCredential;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CNSConnector {
    private final String vo;
    private final String server;
    private final int port;
    private final GSSCredential gssCredential;

    private CNSConnector(String host, int port, String vo, GSSCredential gssCredential) throws IOException, ReceiveException {
        this.server = host;
        this.port = port;
        this.vo = vo;
        this.gssCredential = gssCredential;
    }

    public static CNSConnector getInstance(String host, int port, String vo, GSSCredential gssCredential) throws IllegalArgumentException, IOException, ReceiveException {
        if (host == null || "".equals(host)) {
            throw new IllegalArgumentException("The CNS server host must be set.");
        }
        if (port <= 0) {
            throw new IllegalArgumentException("The CNS server port must be greater than 0.");
        }
        return new CNSConnector(host, port, vo, gssCredential);
    }

    public CNSConnection getNewConnection() throws IOException, ReceiveException {
        return new CNSConnection(this.server, this.port, this.gssCredential);
    }

    public void startSession(CNSConnection connection, String comment) throws IOException, ReceiveException {
        try {
            connection.cns_startsess(comment);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("startSession((" + comment + ")");
            throw e;
        }
    }

    public void endSession(CNSConnection connection) throws IOException, ReceiveException {
        try {
            connection.cns_endsess();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("closeSession()");
            throw e;
        }
    }

    public void startTransaction(CNSConnection connection, String comment) throws IOException, ReceiveException {
        try {
            connection.cns_starttrans(comment);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("startTransaction(" + comment + ")");
            throw e;
        }
    }

    public void endTransaction(CNSConnection connection) throws IOException, ReceiveException {
        try {
            connection.cns_endtrans();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("endTransaction()");
            throw e;
        }
    }

    public void abortTransaction(CNSConnection connection) throws IOException, ReceiveException {
        try {
            connection.cns_aborttrans();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("abortTransaction()");
            throw e;
        }
    }

    public void close(CNSConnection connection) throws IOException {
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ping() throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            String string = this.ping(connection);
            return string;
        }
        finally {
            this.close(connection);
        }
    }

    public String ping(CNSConnection connection) throws IOException, ReceiveException {
        try {
            return connection.cns_ping();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("ping()");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CNSReplica> listReplicas(String path, String guid) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            Collection<CNSReplica> collection = this.listReplicas(connection, path, guid);
            return collection;
        }
        finally {
            this.close(connection);
        }
    }

    public Collection<CNSReplica> listReplicas(CNSConnection connection, String path, String guid) throws IOException, ReceiveException {
        try {
            ArrayList<CNSReplica> replicas = new ArrayList<CNSReplica>();
            short flag = 0;
            short[] eol = new short[]{0};
            while (eol[0] != 1) {
                replicas.addAll(connection.cns_listreplica(path, guid, flag, eol));
                flag = 1;
            }
            connection.cns_listreplica(path, guid, (short)2, eol);
            return replicas;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("listReplicas(" + path + "," + guid + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CNSFileStat stat(String path, long file_uniqueid, boolean followSymbolicLink) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            CNSFileStat cNSFileStat = this.stat(connection, path, file_uniqueid, followSymbolicLink);
            return cNSFileStat;
        }
        finally {
            this.close(connection);
        }
    }

    public CNSFileStat stat(CNSConnection connection, String path, long file_uniqueid, boolean followSymbolicLink) throws IOException, ReceiveException {
        CNSFileStat file;
        try {
            file = followSymbolicLink ? connection.cns_stat(path, file_uniqueid) : connection.cns_lstat(path, file_uniqueid);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("stat(" + path + ", " + file_uniqueid + ", " + followSymbolicLink + ")");
            throw e;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CNSFileStatg statg(String path, String guid) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            CNSFileStatg cNSFileStatg = this.statg(connection, path, guid);
            return cNSFileStatg;
        }
        finally {
            this.close(connection);
        }
    }

    public CNSFileStatg statg(CNSConnection connection, String path, String guid) throws IOException, ReceiveException {
        CNSFileStatg file;
        try {
            file = connection.cns_statg(path, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("statg(" + path + ")");
            throw e;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CNSFileStatg getSfnOrPfnInfos(String sfn) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            CNSFileStatg cNSFileStatg = this.getSfnOrPfnInfos(connection, sfn);
            return cNSFileStatg;
        }
        finally {
            this.close(connection);
        }
    }

    public CNSFileStatg getSfnOrPfnInfos(CNSConnection connection, String sfn) throws IOException, ReceiveException {
        CNSFileStatg file;
        try {
            file = connection.cns_statr(sfn);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getReplicaInfos(" + sfn + ")");
            throw e;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readlink(String link) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            String string = this.readlink(connection, link);
            return string;
        }
        finally {
            this.close(connection);
        }
    }

    public String readlink(CNSConnection connection, String link) throws IOException, ReceiveException {
        String path;
        try {
            path = connection.cns_readlink(link);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("readlink(" + link + ")");
            throw e;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void symbLink(String path, String target, boolean overwrite) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.symbLink(connection, path, target, overwrite);
        }
        finally {
            this.close(connection);
        }
    }

    public void symbLink(CNSConnection connection, String path, String target, boolean overwrite) throws IOException, ReceiveException {
        block8: {
            try {
                connection.cns_symlink(path, target);
            }
            catch (IOException e) {
                throw e;
            }
            catch (ReceiveException e) {
                if (DMError.EEXIST.equals((Object)e.getDMError())) {
                    if (overwrite) {
                        boolean localTransaction = false;
                        if (!connection.isTransactionOpened()) {
                            connection.cns_starttrans(null);
                            localTransaction = true;
                        }
                        this.delete(connection, path);
                        this.symbLink(connection, path, target, false);
                        if (!localTransaction) break block8;
                        connection.cns_endtrans();
                        if (connection.isSessionOpened()) break block8;
                        CNSConnection newCnsConnection = this.getNewConnection();
                        try {
                            connection.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        connection = newCnsConnection;
                    }
                    e.setExecutedCmd("symbLink(" + path + "," + target + "," + overwrite + ")");
                    throw e;
                }
                e.setExecutedCmd("symbLink(" + path + "," + target + "," + overwrite + ")");
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAccess(String path, CNSAccessType accessType) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            boolean bl = this.checkAccess(connection, path, accessType);
            return bl;
        }
        finally {
            this.close(connection);
        }
    }

    public boolean checkAccess(CNSConnection connection, String path, CNSAccessType accessType) throws IOException, ReceiveException {
        try {
            connection.cns_access(path, accessType);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            if (DMError.EACCES.equals((Object)e.getDMError())) {
                return false;
            }
            if (DMError.ENOENT.equals((Object)e.getDMError()) && accessType.contains(CNSAccessType.EXIST_OK)) {
                return false;
            }
            e.setExecutedCmd("checkAccess(" + path + ", accessType =" + accessType + ")");
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canRead(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            boolean bl = this.canRead(connection, path);
            return bl;
        }
        finally {
            this.close(connection);
        }
    }

    public boolean canRead(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            return this.checkAccess(connection, path, CNSAccessType.READ_OK);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("canRead(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            boolean bl = this.canWrite(connection, path);
            return bl;
        }
        finally {
            this.close(connection);
        }
    }

    public boolean canWrite(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            return this.checkAccess(connection, path, CNSAccessType.WRITE_OK);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("canWrite(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exist(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            boolean bl = this.exist(connection, path);
            return bl;
        }
        finally {
            this.close(connection);
        }
    }

    public boolean exist(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            this.stat(connection, path, 0L, false);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            if (DMError.ENOENT.equals((Object)e.getDMError())) {
                return false;
            }
            e.setExecutedCmd("exist(" + path + ")");
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getGrpByGids(int[] gids) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            Collection<String> collection = this.getGrpByGids(connection, gids);
            return collection;
        }
        finally {
            this.close(connection);
        }
    }

    public Collection<String> getGrpByGids(CNSConnection connection, int[] gids) throws IOException, ReceiveException {
        try {
            return connection.cns_getgrpnames(gids);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getGrpByGids(" + Arrays.toString(gids) + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUsrByUid(int uid) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            String string = this.getUsrByUid(connection, uid);
            return string;
        }
        finally {
            this.close(connection);
        }
    }

    public String getUsrByUid(CNSConnection connection, int uid) throws IOException, ReceiveException {
        try {
            return connection.cns_getusrnam(uid);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getUsrByUid(" + uid + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUsrByName(String username) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            int n = this.getUsrByName(connection, username);
            return n;
        }
        finally {
            this.close(connection);
        }
    }

    public int getUsrByName(CNSConnection connection, String username) throws IOException, ReceiveException {
        try {
            return connection.cns_getusrid(username);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getUsrByName(" + username + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CNSFileReaddir> list(String path, boolean followSymbolicLink) throws IOException, ReceiveException {
        if (followSymbolicLink) {
            throw new UnsupportedOperationException("followSymbolicLink is not implemented in list yet...");
        }
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            Collection<CNSFileReaddir> collection = this.list(connection, path, followSymbolicLink);
            return collection;
        }
        finally {
            this.close(connection);
        }
    }

    public Collection<CNSFileReaddir> list(CNSConnection connection, String path, boolean followSymbolicLink) throws IOException, ReceiveException {
        if (followSymbolicLink) {
            throw new UnsupportedOperationException("followSymbolicLink is not implemented in list yet...");
        }
        try {
            CNSDir cnsDir = connection.cns_opendir(path);
            ArrayList<CNSFileReaddir> entries = new ArrayList<CNSFileReaddir>();
            while (cnsDir.getEod() != 1) {
                entries.addAll(connection.cns_readdir(cnsDir));
                cnsDir.setBod((short)0);
            }
            try {
                connection.cns_closedir();
            }
            catch (Exception e) {
                // empty catch block
            }
            return entries;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("list(" + path + ") - followSymbolicLink=" + followSymbolicLink);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(String path, int mode) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.mkdir(connection, path, mode);
        }
        finally {
            this.close(connection);
        }
    }

    public void mkdir(CNSConnection connection, String path, int mode) throws IOException, ReceiveException {
        try {
            connection.cns_mkdir(path, UUID.randomUUID().toString(), mode);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("mkdir(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteDir(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            boolean bl = this.deleteDir(connection, path);
            return bl;
        }
        finally {
            this.close(connection);
        }
    }

    public boolean deleteDir(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            connection.cns_rmdir(path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("deleteFile(" + path + ")");
            throw e;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.delete(connection, path);
        }
        finally {
            this.close(connection);
        }
    }

    public void delete(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            connection.cns_unlink(path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("delete(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logical_delete(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.logical_delete(connection, path);
        }
        finally {
            this.close(connection);
        }
    }

    public void logical_delete(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            connection.cns_delete(path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("logical_delete(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logical_undelete(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.logical_undelete(connection, path);
        }
        finally {
            this.close(connection);
        }
    }

    public void logical_undelete(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            connection.cns_undelete(path);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("logical_undelete(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteReplica(long file_uniqueid, String guid, String sfn) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.deleteReplica(connection, file_uniqueid, guid, sfn);
        }
        finally {
            this.close(connection);
        }
    }

    public void deleteReplica(CNSConnection connection, long file_uniqueid, String guid, String sfn) throws IOException, ReceiveException, RuntimeException {
        try {
            connection.cns_delreplica(file_uniqueid, guid, sfn);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("deleteReplica(" + file_uniqueid + "," + guid + "," + sfn + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFilesByGuid(String[] guids, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.deleteFilesByGuid(connection, guids, force);
        }
        finally {
            this.close(connection);
        }
    }

    public void deleteFilesByGuid(CNSConnection connection, String[] guids, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        try {
            connection.cns_delfilesbyguid(guids, force);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("deleteFilesByGuids(" + Arrays.toString(guids) + "," + force + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFilesByName(String[] filenames, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.deleteFilesByGuid(connection, filenames, force);
        }
        finally {
            this.close(connection);
        }
    }

    public void deleteFilesByName(CNSConnection connection, String[] filenames, boolean force) throws IOException, ReceiveException, CNSStatusesException, RuntimeException {
        try {
            connection.cns_delfilesbyname(filenames, force);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("deleteFilesByName(" + Arrays.toString(filenames) + "," + force + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmod(String path, int mode) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.chmod(connection, path, mode);
        }
        finally {
            this.close(connection);
        }
    }

    public void chmod(CNSConnection connection, String path, int mode) throws IOException, ReceiveException {
        try {
            connection.cns_chmod(path, mode);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("chmod(" + path + "," + mode + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chown(String path, boolean recursive, boolean followSymbolicLinks, String usrName, String grpName) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.chown(connection, path, recursive, followSymbolicLinks, usrName, grpName);
        }
        finally {
            this.close(connection);
        }
    }

    public void chown(CNSConnection connection, String path, boolean recursive, boolean followSymbolicLinks, String owner, String group) throws IOException, ReceiveException {
        int new_uid = -1;
        int new_gid = -1;
        if (owner != null) {
            if (owner.equals("root")) {
                new_uid = 0;
            } else {
                try {
                    new_uid = connection.cns_getusrid(owner);
                }
                catch (IOException e) {
                    throw new IOException("Unable to find the uid of " + owner + " in the CNS");
                }
            }
        }
        if (group != null) {
            if (group.equals("root")) {
                new_gid = 0;
            } else {
                try {
                    new_gid = connection.cns_getgrpid(group);
                }
                catch (IOException e) {
                    throw new IOException("Unable to find the gid of " + group + " in the CNS");
                }
            }
        }
        this.chown(connection, path, recursive, followSymbolicLinks, new_uid, new_gid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chown(String path, boolean recursive, boolean followSymbolicLinks, int owner, int group) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.chown(connection, path, recursive, followSymbolicLinks, owner, group);
        }
        finally {
            this.close(connection);
        }
    }

    public void chown(CNSConnection connection, String path, boolean recursive, boolean followSymbolicLinks, int owner, int group) throws IOException, ReceiveException {
        if (recursive) {
            throw new UnsupportedOperationException("Recurcive chown is not implemented yet...");
        }
        if (owner < 0 && group < 0) {
            throw new IllegalArgumentException("You must specify at least a new owner or a new group");
        }
        try {
            if (followSymbolicLinks) {
                connection.cns_chown(path, owner, group);
            } else {
                connection.cns_lchown(path, owner, group);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("chown(" + path + " - owner uid=" + owner + ", group gid=" + group + ", followSymbolicLinks=" + followSymbolicLinks + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldPath, String newPath) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.rename(connection, oldPath, newPath);
        }
        finally {
            this.close(connection);
        }
    }

    public void rename(CNSConnection connection, String oldPath, String newPath) throws IOException, ReceiveException {
        try {
            connection.cns_rename(oldPath, newPath);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("rename(" + oldPath + ", " + newPath + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(long fileSize, int mode) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            String string = this.create(connection, fileSize, mode);
            return string;
        }
        finally {
            this.close(connection);
        }
    }

    public String create(CNSConnection connection, long fileSize, int mode) throws IOException, ReceiveException {
        String parent;
        String guid;
        block4: {
            Calendar c = GregorianCalendar.getInstance();
            StringBuilder b = new StringBuilder();
            b.append(c.get(1));
            b.append('-');
            int month = c.get(2) + 1;
            if (month < 10) {
                b.append('0');
            }
            b.append(month);
            b.append('-');
            int day = c.get(5);
            if (day < 10) {
                b.append('0');
            }
            b.append(day);
            String date = b.toString();
            guid = UUID.randomUUID().toString();
            parent = "/grid/" + this.vo + "/generated/" + date;
            try {
                int permssions = 511;
                connection.cns_mkdir(parent, UUID.randomUUID().toString(), permssions);
            }
            catch (ReceiveException e) {
                if (DMError.EEXIST.equals((Object)e.getDMError())) break block4;
                e.setExecutedCmd("create(/grid/" + this.vo + "/generated/" + date + ")");
                throw e;
            }
        }
        String path = parent + "/file-" + guid;
        return this.create(connection, path, guid, fileSize, mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(String path, String guid, long fileSize, int mode) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            String string = this.create(connection, path, guid, fileSize, mode);
            return string;
        }
        finally {
            this.close(connection);
        }
    }

    public String create(CNSConnection connection, String path, String guid, long fileSize, int mode) throws IOException, ReceiveException {
        block6: {
            boolean localTransaction = false;
            try {
                if (fileSize > 0L && !connection.isTransactionOpened()) {
                    connection.cns_starttrans(null);
                    localTransaction = true;
                }
                connection.cns_creat(path, guid, mode);
                if (fileSize <= 0L) break block6;
                connection.cns_setfsize(path, 0L, fileSize, null, null);
                if (!localTransaction) break block6;
                connection.cns_endtrans();
                if (connection.isSessionOpened()) break block6;
                CNSConnection newCnsConnection = this.getNewConnection();
                try {
                    connection.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                connection = newCnsConnection;
            }
            catch (IOException e) {
                throw e;
            }
            catch (ReceiveException e) {
                e.setExecutedCmd("create(" + path + ", " + guid + ")");
                throw e;
            }
        }
        return guid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReplica(String guid, URI sfn) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.addReplica(connection, guid, sfn);
        }
        finally {
            this.close(connection);
        }
    }

    public void addReplica(CNSConnection connection, String guid, URI sfn) throws IOException, ReceiveException {
        try {
            connection.cns_addreplica(0L, guid, sfn, CNSReplicaStatus.AVAILABLE, CNSFileType.PERMANENT, null, null, CNSReplicaType.PRIMARY, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("create(" + guid + ", " + sfn + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileSize(String path, long file_uniqueid, long fileSize, CNSChecksumType checksumType, String checksumValue) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            this.setFileSize(connection, path, file_uniqueid, fileSize, checksumType, checksumValue);
        }
        finally {
            this.close(connection);
        }
    }

    public void setFileSize(CNSConnection connection, String path, long file_uniqueid, long fileSize, CNSChecksumType checksumType, String checksumValue) throws IOException, ReceiveException {
        try {
            connection.cns_setfsize(path, 0L, fileSize, checksumType, checksumValue);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("setFileSize(" + path + ", " + fileSize + ", " + (Object)((Object)checksumType) + ", " + checksumValue + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CNSDuInfos getFileSpaceUSage(String path, boolean detailed) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            CNSDuInfos cNSDuInfos = this.getFileSpaceUSage(connection, path, detailed);
            return cNSDuInfos;
        }
        finally {
            this.close(connection);
        }
    }

    public CNSDuInfos getFileSpaceUSage(CNSConnection connection, String path, boolean detailed) throws IOException, ReceiveException {
        try {
            return connection.cns_du(path, detailed);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getFileSpaceUSage(" + path + ", " + detailed + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CNSLinkInfo[] getlinksByPath(String path) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            CNSLinkInfo[] cNSLinkInfoArray = this.getlinksByPath(connection, path);
            return cNSLinkInfoArray;
        }
        finally {
            this.close(connection);
        }
    }

    public CNSLinkInfo[] getlinksByPath(CNSConnection connection, String path) throws IOException, ReceiveException {
        try {
            return this.getlinks(connection, path, null);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getlinksByPath(" + path + ")");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CNSLinkInfo[] getlinksByGuid(String guid) throws IOException, ReceiveException {
        CNSConnection connection = new CNSConnection(this.server, this.port, this.gssCredential);
        try {
            CNSLinkInfo[] cNSLinkInfoArray = this.getlinksByGuid(connection, guid);
            return cNSLinkInfoArray;
        }
        finally {
            this.close(connection);
        }
    }

    public CNSLinkInfo[] getlinksByGuid(CNSConnection connection, String guid) throws IOException, ReceiveException {
        try {
            return this.getlinks(connection, null, guid);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ReceiveException e) {
            e.setExecutedCmd("getlinksByGuid(" + guid + ")");
            throw e;
        }
    }

    private CNSLinkInfo[] getlinks(CNSConnection connection, String path, String guid) throws IOException, ReceiveException {
        return connection.cns_getlinks(path, guid);
    }
}

