/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.uftp;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UFTPProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unicore.services", UFTPProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "coreServices.uftp.";
    public static final String PARAM_CLIENT_LOCAL = "client.local";
    public static final String PARAM_CLIENT_EXECUTABLE = "client.executable";
    public static final String PARAM_COMMAND_SSL_DISABLE = "command.sslDisable";
    public static final String PARAM_COMMAND_HOST = "command.host";
    public static final String PARAM_COMMAND_PORT = "command.port";
    public static final String PARAM_COMMAND_TIMEOUT = "command.socketTimeout";
    public static final String PARAM_BUFFERSIZE = "buffersize";
    public static final String PARAM_STREAMS_LIMIT = "streamsLimit";
    public static final String PARAM_CLIENT_HOST = "client.host";
    public static final String PARAM_STREAMS = "streams";
    public static final String PARAM_SERVER_HOST = "server.host";
    public static final String PARAM_SERVER_PORT = "server.port";
    public static final String PARAM_ENABLE_ENCRYPTION = "encryption";
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public UFTPProperties(Properties properties) throws ConfigurationException {
        super(PREFIX, properties, META, log);
    }

    static {
        META.put(PARAM_CLIENT_LOCAL, new PropertyMD("false").setDescription("Controls whether, the Java UFTP client code should be run directly within the JVM, which will work only if the UNICORE/X has access to the target file system, or, if set to false, in the TSI."));
        META.put(PARAM_CLIENT_EXECUTABLE, new PropertyMD("uftp.sh").setDescription("Configures the path to the client executable (location of 'uftp.sh')."));
        META.put(PARAM_COMMAND_SSL_DISABLE, new PropertyMD("false").setDescription("Allows to disable SSL on the command port (useful for testing)."));
        META.put(PARAM_COMMAND_HOST, new PropertyMD("localhost").setDescription("The UFTPD command host."));
        META.put(PARAM_COMMAND_PORT, new PropertyMD("64434").setBounds(1L, 65535L).setDescription("The UFTPD command port."));
        META.put(PARAM_COMMAND_TIMEOUT, new PropertyMD("10").setBounds(0L, 300L).setDescription("The timeout (in seconds) for communicating with the command port."));
        META.put(PARAM_BUFFERSIZE, new PropertyMD("128").setPositive().setDescription("File read/write buffer size in kbytes."));
        META.put(PARAM_STREAMS_LIMIT, new PropertyMD("4").setPositive().setDescription("Server limit for number of streams."));
        META.put(PARAM_CLIENT_HOST, new PropertyMD((String)null).setDescription("Client host. If not set and UFTP client is set to local, then the local interface address will be determined at runtime. If not set and non-local mode is configured, then the server's host (as configured) will be used."));
        META.put(PARAM_STREAMS, new PropertyMD("1").setDescription("Requested number of parallel data streams."));
        META.put(PARAM_SERVER_HOST, new PropertyMD("localhost").setDescription("UFTPD listen host."));
        META.put(PARAM_SERVER_PORT, new PropertyMD("64434").setBounds(1L, 65535L).setDescription("UFTPD listen port."));
        META.put(PARAM_ENABLE_ENCRYPTION, new PropertyMD("false").setDescription("Controls whether encryption should be enabled for server-server transfers."));
    }
}

