/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.fts.uftp;

import de.fzj.unicore.uas.fts.uftp.UFTPExport;
import de.fzj.unicore.uas.fts.uftp.UFTPImport;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import eu.unicore.security.Client;
import java.net.URI;
import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.ProtocolType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class UFTPCreator
implements IFileTransferCreator {
    private static final Logger log = LogUtil.getLogger((String)"unicore.services", UFTPCreator.class);
    private final Configuration configuration;

    public UFTPCreator(Configuration config) {
        this.configuration = config;
    }

    public IFileTransfer createFileExport(Client client, String workdir, String source, URI target, DataStagingCredentials creds) {
        log.info((Object)("+++ creating file export " + source + " -> " + target));
        if ("uftp".equalsIgnoreCase(target.getScheme())) {
            IFileTransfer t = this.createExport(client, workdir, source, target);
            return t;
        }
        return null;
    }

    public IFileTransfer createFileImport(Client client, String workdir, URI source, String target, DataStagingCredentials creds) {
        log.info((Object)("+++ creating file import " + source + " -> " + target));
        if ("uftp".equalsIgnoreCase(source.getScheme())) {
            IFileTransfer t = this.createImport(client, workdir, source, target);
            return t;
        }
        return null;
    }

    public String getProtocol() {
        return ProtocolType.UDT.toString();
    }

    protected IFileTransfer createExport(Client client, String workdir, String sourceFile, URI target) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        String tgt = target.getSchemeSpecificPart();
        String targetFile = this.urlDecode(target.getFragment());
        epr.addNewAddress().setStringValue(tgt);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr);
        try {
            UFTPExport ft = new UFTPExport(this.configuration);
            ft.setClient(client);
            ft.setWorkdir(workdir);
            ft.setSource(sourceFile);
            ft.setTarget(targetFile);
            ft.setSmsEPR(epr);
            ft.setExport(true);
            return ft;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error creating UFTP Export", (Throwable)e, (Logger)log);
            return null;
        }
    }

    protected IFileTransfer createImport(Client client, String workdir, URI source, String targetFile) {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        String src = source.getSchemeSpecificPart();
        epr.addNewAddress().setStringValue(src);
        WSServerUtilities.addUGSRefparamToEpr((EndpointReferenceType)epr);
        String sourceFile = this.urlDecode(source.getFragment());
        try {
            UFTPImport ft = new UFTPImport(this.configuration);
            ft.setWorkdir(workdir);
            ft.setClient(client);
            ft.setSource(sourceFile);
            ft.setTarget(targetFile);
            ft.setSmsEPR(epr);
            ft.setExport(false);
            return ft;
        }
        catch (Exception e) {
            LogUtil.logException((String)"Error creating UFTP Import", (Throwable)e, (Logger)log);
            return null;
        }
    }

    protected String urlDecode(String orig) {
        try {
            return orig.replaceAll("%20", " ");
        }
        catch (Exception e) {
            return orig;
        }
    }
}

