/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.paranamer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.picocontainer.paranamer.ParameterNamesNotFoundException;
import org.picocontainer.paranamer.Paranamer;

public class JavadocParanamer
implements Paranamer {
    private static final String IE = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1; .NET CLR 2.0.50727)";
    private static final ParameterNamesNotFoundException CLASS_NOT_SUPPORTED = new ParameterNamesNotFoundException("class not supported");
    private String base;
    private final boolean isArchive;
    private final boolean isDirectory;
    private final boolean isURI;
    private final URI location;
    private final Set packages;
    public static final String __PARANAMER_DATA = "<init> java.io.File archiveOrDirectory \n<init> java.net.URL url \nareParameterNamesAvailable java.lang.Class,java.lang.String clazz,constructorOrMethodName \nlookupParameterNames java.lang.reflect.AccessibleObject methodOrConstructor \n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavadocParanamer(File archiveOrDirectory) throws IOException {
        block17: {
            this.base = null;
            this.packages = new HashSet();
            if (archiveOrDirectory == null) {
                throw new NullPointerException();
            }
            if (!archiveOrDirectory.exists()) {
                throw new FileNotFoundException(archiveOrDirectory.getAbsolutePath());
            }
            this.isURI = false;
            this.location = archiveOrDirectory.toURI();
            if (archiveOrDirectory.isDirectory()) {
                this.isArchive = false;
                this.isDirectory = true;
                File dir = archiveOrDirectory;
                File packageList = new File(dir.getAbsolutePath() + "/package-list");
                if (!packageList.isFile()) {
                    throw new FileNotFoundException("No package-list found at " + dir.getAbsolutePath() + ". Not a valid Javadoc directory.");
                }
                FileInputStream input = new FileInputStream(packageList);
                try {
                    String packageListString = this.streamToString(input);
                    this.parsePackageList(packageListString);
                }
                finally {
                    input.close();
                }
            }
            if (archiveOrDirectory.isFile()) {
                this.isArchive = true;
                this.isDirectory = false;
                File archive = archiveOrDirectory;
                if (!archive.getAbsolutePath().toLowerCase().endsWith(".zip")) {
                    throw new IllegalArgumentException(archive.getAbsolutePath() + " is not a zip file.");
                }
                ZipFile zip = new ZipFile(archive);
                try {
                    String name;
                    ZipEntry entry;
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    TreeMap<Long, ZipEntry> packageLists = new TreeMap<Long, ZipEntry>();
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        name = entry.getName();
                        if (!name.endsWith("package-list")) continue;
                        Long size = new Long(entry.getSize());
                        packageLists.put(size, entry);
                    }
                    if (packageLists.size() == 0) {
                        throw new FileNotFoundException("no package-list found in archive");
                    }
                    entry = (ZipEntry)packageLists.get(packageLists.lastKey());
                    name = entry.getName();
                    this.base = name.substring(0, name.length() - "package-list".length());
                    InputStream input = zip.getInputStream(entry);
                    try {
                        String packageListString = this.streamToString(input);
                        this.parsePackageList(packageListString);
                        break block17;
                    }
                    finally {
                        input.close();
                    }
                }
                finally {
                    zip.close();
                }
            }
            throw new IllegalArgumentException(archiveOrDirectory.getAbsolutePath() + " is neither a directory nor a file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavadocParanamer(URL url) throws IOException {
        this.base = null;
        this.packages = new HashSet();
        if (url == null) {
            throw new NullPointerException();
        }
        this.isArchive = false;
        this.isDirectory = false;
        this.isURI = true;
        try {
            this.location = new URI(url.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        URL packageListURL = new URL(url.toString() + "/package-list");
        InputStream input = this.urlToInputStream(packageListURL);
        try {
            String packageList = this.streamToString(input);
            this.parsePackageList(packageList);
        }
        finally {
            input.close();
        }
    }

    public int areParameterNamesAvailable(Class clazz, String constructorOrMethodName) {
        if (clazz == null || constructorOrMethodName == null) {
            throw new NullPointerException();
        }
        Executable accessible = null;
        if (constructorOrMethodName.equals("<init>")) {
            accessible = clazz.getDeclaredConstructors()[0];
        } else {
            Method[] methods = clazz.getMethods();
            if (methods == null) {
                return 3;
            }
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(constructorOrMethodName)) continue;
                accessible = methods[i];
                break;
            }
        }
        if (accessible == null) {
            return 3;
        }
        try {
            this.lookupParameterNames(accessible);
            return 0;
        }
        catch (ParameterNamesNotFoundException e) {
            if (e == CLASS_NOT_SUPPORTED) {
                return 2;
            }
            return 3;
        }
    }

    public String[] lookupParameterNames(AccessibleObject methodOrConstructor) {
        Class[] types;
        String name;
        Class<Object> klass;
        if (methodOrConstructor == null) {
            throw new NullPointerException();
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            klass = constructor.getDeclaringClass();
            name = constructor.getName();
            types = constructor.getParameterTypes();
        } else if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            klass = method.getDeclaringClass();
            name = method.getName();
            types = method.getParameterTypes();
        } else {
            throw new IllegalArgumentException();
        }
        if (!this.packages.contains(klass.getPackage().getName())) {
            throw CLASS_NOT_SUPPORTED;
        }
        try {
            String[] names = this.getParameterNames(klass, name, types);
            if (names == null) {
                throw new ParameterNamesNotFoundException(methodOrConstructor.toString());
            }
            return names;
        }
        catch (IOException e) {
            throw new ParameterNamesNotFoundException(methodOrConstructor.toString() + " due to an I/O error: " + e.getMessage());
        }
    }

    private String[] getParameterNames(Class klass, String constructorOrMethodName, Class[] types) throws IOException {
        if (types != null && types.length == 0) {
            return new String[0];
        }
        String path = this.getCanonicalName(klass).replace('.', '/');
        if (this.isArchive) {
            ZipFile archive = new ZipFile(new File(this.location));
            ZipEntry entry = archive.getEntry(this.base + path + ".html");
            if (entry == null) {
                throw CLASS_NOT_SUPPORTED;
            }
            InputStream input = archive.getInputStream(entry);
            return this.getParameterNames2(input, constructorOrMethodName, types);
        }
        if (this.isDirectory) {
            File file = new File(this.location.getPath() + "/" + path + ".html");
            if (!file.isFile()) {
                throw CLASS_NOT_SUPPORTED;
            }
            FileInputStream input = new FileInputStream(file);
            return this.getParameterNames2(input, constructorOrMethodName, types);
        }
        if (this.isURI) {
            try {
                URL url = new URL(this.location.toString() + "/" + path + ".html");
                InputStream input = this.urlToInputStream(url);
                return this.getParameterNames2(input, constructorOrMethodName, types);
            }
            catch (FileNotFoundException e) {
                throw CLASS_NOT_SUPPORTED;
            }
        }
        throw new RuntimeException("bug in JavadocParanamer. Should not reach here.");
    }

    private String[] getParameterNames2(InputStream input, String constructorOrMethodName, Class[] types) throws IOException {
        String javadoc = this.streamToString(input);
        input.close();
        StringBuffer regex = new StringBuffer();
        regex.append("NAME=\"");
        regex.append(constructorOrMethodName);
        regex.append("\\(\\Q");
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                regex.append(", ");
            }
            regex.append(this.getCanonicalName(types[i]));
        }
        regex.append("\\E\\)\"");
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(javadoc);
        if (!matcher.find()) {
            return null;
        }
        String[] names = new String[types.length];
        String regexParams = "<DD><CODE>([^<]*)</CODE>";
        Pattern patternParams = Pattern.compile(regexParams);
        int start = matcher.end();
        Matcher matcherParams = patternParams.matcher(javadoc);
        for (int i = 0; i < types.length; ++i) {
            boolean find = matcherParams.find(start);
            if (!find) {
                return null;
            }
            start = matcherParams.end();
            names[i] = matcherParams.group(1);
        }
        return names;
    }

    private String getCanonicalName(Class klass) {
        if (klass.isArray()) {
            return this.getCanonicalName(klass.getComponentType()) + "[]";
        }
        return klass.getName();
    }

    private void parsePackageList(String packageList) throws IOException {
        String line;
        StringReader reader = new StringReader(packageList);
        BufferedReader breader = new BufferedReader(reader);
        while ((line = breader.readLine()) != null) {
            this.packages.add(line);
        }
    }

    private String streamToString(InputStream input) throws IOException {
        String line;
        InputStreamReader reader;
        try {
            reader = new InputStreamReader(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            reader = new InputStreamReader(input);
        }
        BufferedReader breader = new BufferedReader(reader);
        StringBuffer builder = new StringBuffer();
        while ((line = breader.readLine()) != null) {
            builder.append(line);
            builder.append("\n");
        }
        return builder.toString();
    }

    private InputStream urlToInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setRequestProperty("User-Agent", IE);
        conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        conn.connect();
        String encoding = conn.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
            return new GZIPInputStream(conn.getInputStream());
        }
        if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
            return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
        }
        return conn.getInputStream();
    }
}

