/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.parameters;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.NameBinding;
import org.picocontainer.Parameter;
import org.picocontainer.PicoCompositionException;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantParameter
implements Parameter,
Serializable {
    private final Object value;

    public ConstantParameter(Object value) {
        this.value = value;
    }

    @Override
    public Object resolveInstance(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        return this.value;
    }

    @Override
    public boolean isResolvable(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) {
        if (expectedType instanceof Class) {
            return this.isAssignable((Class)expectedType);
        }
        if (expectedType instanceof ParameterizedType) {
            return this.isAssignable(((ParameterizedType)expectedType).getRawType());
        }
        return false;
    }

    @Override
    public void verify(PicoContainer container, ComponentAdapter<?> adapter, Type expectedType, NameBinding expectedNameBinding, boolean useNames, Annotation binding) throws PicoException {
        if (!this.isAssignable(expectedType)) {
            throw new PicoCompositionException(expectedType + " is not assignable from " + (this.value != null ? this.value.getClass().getName() : "null"));
        }
    }

    protected boolean isAssignable(Type expectedType) {
        Class expectedClass;
        return expectedType instanceof Class && (this.checkPrimitive(expectedClass = (Class)expectedType) || expectedClass.isInstance(this.value));
    }

    @Override
    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private boolean checkPrimitive(Class expectedType) {
        try {
            if (expectedType.isPrimitive()) {
                Field field = this.value.getClass().getField("TYPE");
                Class type = (Class)field.get(this.value);
                return expectedType.isAssignableFrom(type);
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }
}

