/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.hadoop;

import de.fzj.unicore.uas.hadoop.HadoopProperties;
import de.fzj.unicore.uas.hadoop.HadoopStorageAdapter;
import de.fzj.unicore.uas.impl.UASWSResourceImpl;
import de.fzj.unicore.uas.xnjs.StorageAdapterFactory;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import eu.unicore.security.Client;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopStorageAdapterFactory
implements StorageAdapterFactory {
    private static final long serialVersionUID = 1L;
    private final String storageRoot;

    public HadoopStorageAdapterFactory(String storageRoot) {
        this.storageRoot = storageRoot;
    }

    public IStorageAdapter createStorageAdapter(UASWSResourceImpl parent) throws IOException {
        Client client = parent.getClient();
        Kernel kernel = parent.getKernel();
        Configuration conf = HadoopStorageAdapterFactory.getHadoopConfiguration(kernel);
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.setWorkingDirectory(new Path(this.storageRoot));
        HadoopStorageAdapter storageAdapter = new HadoopStorageAdapter(fs, client);
        return storageAdapter;
    }

    public static Configuration getHadoopConfiguration(Kernel kernel) {
        HadoopProperties hadoopCfg = (HadoopProperties)((Object)kernel.getAttribute(HadoopProperties.class));
        Configuration conf = new Configuration();
        String core = hadoopCfg.getValue("core");
        String hdfs = hadoopCfg.getValue("hdfs");
        String mapred = hadoopCfg.getValue("mapred");
        conf.addResource(new Path(new File(core).toURI().toString()));
        conf.addResource(new Path(new File(hdfs).toURI().toString()));
        if (mapred != null) {
            conf.addResource(new Path(new File(mapred).toURI().toString()));
        }
        return conf;
    }
}

