/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.hadoop;

import de.fzj.unicore.uas.hadoop.ChmodParser2;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileImpl;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import eu.unicore.security.Client;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.unigrids.services.atomic.types.GridFileType;

public class HadoopStorageAdapter
implements IStorageAdapter {
    private final FileSystem fs;
    private final Client client;
    private Path storageRoot = new Path("/");
    private FsPermission umask = new FsPermission(63);
    private static final FsPermission DEFAULT_DIR_PERMS = new FsPermission(511);
    private static final FsPermission DEFAULT_FILE_PERMS = new FsPermission(438);

    public HadoopStorageAdapter(FileSystem fs, Client client) {
        this.fs = fs;
        this.client = client;
    }

    public void chmod(String file, Permissions perm) throws ExecutionException {
        try {
            Path tgt = this.makePath(file);
            this.fs.setPermission(tgt, this.convert(perm));
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public void cp(String source, String target) throws ExecutionException {
        try {
            Path src = this.makePath(source);
            Path tgt = this.makePath(target);
            FileUtil.copy((FileSystem)this.fs, (Path)src, (FileSystem)this.fs, (Path)tgt, (boolean)false, (boolean)false, (Configuration)this.fs.getConf());
            FileStatus srcStat = this.fs.getFileStatus(src);
            this.fs.setPermission(tgt, srcStat.getPermission().applyUMask(this.umask));
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public XnjsFile[] find(String base, FileFilter options, int offset, int limit) throws ExecutionException {
        throw new ExecutionException("Not implemented yet.");
    }

    public InputStream getInputStream(String resource) throws ExecutionException {
        try {
            FSDataInputStream is = this.fs.open(this.makePath(resource));
            return is;
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public OutputStream getOutputStream(String resource) throws ExecutionException {
        return this.getOutputStream(resource, true);
    }

    public OutputStream getOutputStream(String resource, boolean append) throws ExecutionException {
        try {
            Path target = this.makePath(resource);
            FSDataOutputStream os = this.fs.create(target, !append);
            this.fs.setPermission(target, DEFAULT_FILE_PERMS.applyUMask(this.umask));
            return os;
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public XnjsFileWithACL getProperties(String file) throws ExecutionException {
        try {
            FileStatus fStatus = this.fs.getFileStatus(this.makePath(file));
            return this.convert(fStatus);
        }
        catch (FileNotFoundException fex) {
            return null;
        }
        catch (IOException ioe) {
            throw new ExecutionException((Throwable)ioe);
        }
    }

    public XnjsFile[] ls(String base) throws ExecutionException {
        return this.ls(base, 0, Integer.MAX_VALUE, false);
    }

    public XnjsFile[] ls(String base, int offset, int limit, boolean filter) throws ExecutionException {
        try {
            Path basePath = this.makePath(base);
            FileStatus[] files = this.fs.listStatus(basePath);
            if (offset > files.length) {
                throw new IllegalArgumentException("Specified offset <" + offset + "> is larger than the total number of results <" + files.length + ">");
            }
            int numResults = Math.min(files.length, limit);
            XnjsFileImpl[] res = new XnjsFileImpl[numResults];
            for (int i = 0; i < numResults; ++i) {
                FileStatus f = files[offset + i];
                res[i] = this.convert(f);
            }
            return res;
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public void mkdir(String dir) throws ExecutionException {
        boolean created = true;
        try {
            Path path = this.makePath(dir);
            created = this.fs.mkdirs(path);
            this.fs.setPermission(path, DEFAULT_DIR_PERMS.applyUMask(this.umask));
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
        if (!created) {
            throw new ExecutionException();
        }
    }

    public void rename(String source, String target) throws ExecutionException {
        try {
            this.fs.rename(this.makePath(source), this.makePath(target));
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public void rm(String target) throws ExecutionException {
        try {
            this.fs.delete(this.makePath(target), false);
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public void rmdir(String target) throws ExecutionException {
        this.rm(target);
    }

    public String getFileSeparator() throws ExecutionException {
        return "/";
    }

    public Path makePath(String path) {
        return new Path(this.storageRoot, path);
    }

    public String getRelativePath(Path path) {
        String rel = path.toUri().getPath();
        return rel.startsWith("/") ? rel : "/" + rel;
    }

    public String getFileSystemIdentifier() {
        return "Apache Hadoop " + String.valueOf(this.fs.getUri());
    }

    public XnjsStorageInfo getAvailableDiskSpace(String path) {
        XnjsStorageInfo info = new XnjsStorageInfo();
        return info;
    }

    public void setStorageRoot(String root) {
        this.storageRoot = new Path(root);
    }

    public String getStorageRoot() {
        return this.storageRoot.getName();
    }

    public boolean isACLSupported() {
        return false;
    }

    public void chgrp(String file, String newGroup, boolean recursive) throws ExecutionException {
        try {
            Path tgt = this.makePath(file);
            FileStatus status = this.fs.getFileStatus(tgt);
            this.fs.setOwner(tgt, status.getOwner(), newGroup);
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public void chmod2(String file, ChangePermissions[] perm, boolean recursive) throws ExecutionException {
        try {
            Path tgt = this.makePath(file);
            FileStatus fStatus = this.fs.getFileStatus(tgt);
            this.fs.setPermission(tgt, this.computeChmodPerms(perm, fStatus));
        }
        catch (Exception ex) {
            throw new ExecutionException((Throwable)ex);
        }
    }

    public boolean isACLSupported(String path) throws ExecutionException {
        return false;
    }

    public void setfacl(String file, boolean clearAll, ChangeACL[] changeACL, boolean recursive) throws ExecutionException {
        throw new ExecutionException("Not implemented");
    }

    protected XnjsFileWithACL convert(FileStatus f) {
        XnjsFileImpl xFile = new XnjsFileImpl();
        xFile.setPath(this.getRelativePath(f.getPath()));
        xFile.setSize(f.getLen());
        xFile.setDirectory(f.isDirectory());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(f.getModificationTime());
        xFile.setLastModified(cal);
        Permissions permissions = new Permissions();
        permissions.setExecutable(true);
        permissions.setReadable(true);
        permissions.setWritable(true);
        xFile.setPermissions(permissions);
        xFile.setOwnedByCaller(this.isOwner(f));
        return xFile;
    }

    private boolean isOwner(FileStatus f) {
        if (this.client != null) {
            try {
                String owner = f.getOwner();
                if (this.client.getXlogin() != null) {
                    return owner.equals(this.client.getXlogin().getUserName());
                }
            }
            catch (Exception ex) {
                LogUtil.logException((String)"error checking file ownership", (Throwable)ex);
            }
        }
        return false;
    }

    protected void convert(FileStatus f, GridFileType gf) {
        gf.setPath(this.getRelativePath(f.getPath()));
        gf.setSize(f.getLen());
        gf.setIsDirectory(f.isDirectory());
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(f.getModificationTime());
        gf.setLastModified(cal);
        gf.setIsOwner(this.isOwner(f));
        FsPermission p = f.getPermission();
        boolean exec = p.getUserAction().implies(FsAction.EXECUTE);
        boolean write = p.getUserAction().implies(FsAction.WRITE);
        boolean read = p.getUserAction().implies(FsAction.READ);
        gf.addNewPermissions().setReadable(read);
        gf.getPermissions().setWritable(write);
        gf.getPermissions().setExecutable(exec);
        StringBuilder perms = new StringBuilder();
        this.appendRwxPerms(perms, p.getUserAction());
        this.appendRwxPerms(perms, p.getGroupAction());
        this.appendRwxPerms(perms, p.getOtherAction());
        gf.setFilePermissions(perms.toString());
        gf.setGroup(f.getGroup());
        gf.setOwner(f.getOwner());
    }

    protected void appendRwxPerms(StringBuilder sb, FsAction action) {
        if (action.implies(FsAction.READ)) {
            sb.append("r");
        } else {
            sb.append("-");
        }
        if (action.implies(FsAction.WRITE)) {
            sb.append("w");
        } else {
            sb.append("-");
        }
        if (action.implies(FsAction.EXECUTE)) {
            sb.append("x");
        } else {
            sb.append("-");
        }
    }

    protected FsPermission convert(Permissions perm) {
        FsAction userAction = FsAction.READ;
        if (perm.isWritable()) {
            userAction = userAction.or(FsAction.WRITE);
        }
        if (perm.isExecutable()) {
            userAction = userAction.or(FsAction.EXECUTE);
        }
        FsPermission res = new FsPermission(userAction, FsAction.NONE, FsAction.NONE);
        return res;
    }

    protected Permissions convert(FsPermission perm) {
        Permissions res = new Permissions();
        FsAction userAction = perm.getUserAction();
        res.setReadable(userAction.implies(FsAction.READ));
        res.setWritable(userAction.implies(FsAction.WRITE));
        res.setExecutable(userAction.implies(FsAction.EXECUTE));
        return res;
    }

    protected FsPermission computeChmodPerms(ChangePermissions[] perm, FileStatus fs) {
        FsPermission working = fs.getPermission();
        for (ChangePermissions pSpec : perm) {
            ChmodParser2 chmodParser = new ChmodParser2(pSpec.getClazzSymbol() + pSpec.getModeOperator() + pSpec.getPermissions());
            short res = chmodParser.applyNewPermission(working, fs.isDirectory());
            working = new FsPermission(res);
        }
        return working;
    }

    protected String urlDecode(String p) {
        return SMSBaseImpl.urlDecode((String)p);
    }

    public void setUmask(String umask) {
        while (umask.length() < 3) {
            umask = "0" + umask;
        }
        this.umask = new FsPermission(umask);
    }

    public String getUmask() {
        return Integer.toOctalString(this.umask.toShort());
    }
}

