/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class GetImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7669068179452648952L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map pmap = request.getParameterMap();
        try {
            ServletContext context = this.getServletContext();
            FSImage nnImage = (FSImage)context.getAttribute("name.system.image");
            TransferFsImage ff = new TransferFsImage(pmap, request, response);
            if (ff.getImage()) {
                response.setHeader("Content-Length", String.valueOf(nnImage.getFsImageName().length()));
                TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nnImage.getFsImageName());
            } else if (ff.getEdit()) {
                response.setHeader("Content-Length", String.valueOf(nnImage.getFsEditName().length()));
                TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), nnImage.getFsEditName());
            } else if (ff.putImage()) {
                nnImage.validateCheckpointUpload(ff.getToken());
                TransferFsImage.getFileClient(ff.getInfoServer(), "getimage=1", nnImage.getFsImageNameCheckpoint());
                nnImage.checkpointUploadDone();
            }
        }
        catch (Exception ie) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException((Throwable)ie);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }
}

