/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.JournalStream;

class EditLogFileInputStream
extends EditLogInputStream {
    private File file;
    private FileInputStream fStream;

    EditLogFileInputStream(File name) throws IOException {
        this.file = name;
        this.fStream = new FileInputStream(name);
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    public JournalStream.JournalType getType() {
        return JournalStream.JournalType.FILE;
    }

    @Override
    public int available() throws IOException {
        return this.fStream.available();
    }

    @Override
    public int read() throws IOException {
        return this.fStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.fStream.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.fStream.close();
    }

    @Override
    long length() throws IOException {
        return this.file.length();
    }
}

