/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.BlockInfo;
import org.apache.hadoop.hdfs.server.namenode.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

class BlockInfoUnderConstruction
extends BlockInfo {
    private HdfsConstants.BlockUCState blockUCState;
    private List<ReplicaUnderConstruction> replicas;
    private int primaryNodeIndex = -1;
    private long blockRecoveryId = 0L;

    BlockInfoUnderConstruction(Block blk, int replication) {
        this(blk, replication, HdfsConstants.BlockUCState.UNDER_CONSTRUCTION, null);
    }

    BlockInfoUnderConstruction(Block blk, int replication, HdfsConstants.BlockUCState state, DatanodeDescriptor[] targets) {
        super(blk, replication);
        assert (this.getBlockUCState() != HdfsConstants.BlockUCState.COMPLETE) : "BlockInfoUnderConstruction cannot be in COMPLETE state";
        this.blockUCState = state;
        this.setExpectedLocations(targets);
    }

    BlockInfo convertToCompleteBlock() throws IOException {
        assert (this.getBlockUCState() != HdfsConstants.BlockUCState.COMPLETE) : "Trying to convert a COMPLETE block";
        if (this.getBlockUCState() != HdfsConstants.BlockUCState.COMMITTED) {
            throw new IOException("Cannot complete block: block has not been COMMITTED by the client");
        }
        return new BlockInfo(this);
    }

    void setExpectedLocations(DatanodeDescriptor[] targets) {
        int numLocations = targets == null ? 0 : targets.length;
        this.replicas = new ArrayList<ReplicaUnderConstruction>(numLocations);
        for (int i = 0; i < numLocations; ++i) {
            this.replicas.add(new ReplicaUnderConstruction(this, targets[i], HdfsConstants.ReplicaState.RBW));
        }
    }

    DatanodeDescriptor[] getExpectedLocations() {
        int numLocations = this.replicas == null ? 0 : this.replicas.size();
        DatanodeDescriptor[] locations = new DatanodeDescriptor[numLocations];
        for (int i = 0; i < numLocations; ++i) {
            locations[i] = this.replicas.get(i).getExpectedLocation();
        }
        return locations;
    }

    int getNumExpectedLocations() {
        return this.replicas == null ? 0 : this.replicas.size();
    }

    @Override
    HdfsConstants.BlockUCState getBlockUCState() {
        return this.blockUCState;
    }

    void setBlockUCState(HdfsConstants.BlockUCState s) {
        this.blockUCState = s;
    }

    long getBlockRecoveryId() {
        return this.blockRecoveryId;
    }

    void commitBlock(Block block) throws IOException {
        if (this.getBlockId() != block.getBlockId()) {
            throw new IOException("Trying to commit inconsistent block: id = " + block.getBlockId() + ", expected id = " + this.getBlockId());
        }
        this.blockUCState = HdfsConstants.BlockUCState.COMMITTED;
        this.set(this.getBlockId(), block.getNumBytes(), block.getGenerationStamp());
    }

    void initializeBlockRecovery(long recoveryId) {
        this.setBlockUCState(HdfsConstants.BlockUCState.UNDER_RECOVERY);
        this.blockRecoveryId = recoveryId;
        if (this.replicas.size() == 0) {
            NameNode.stateChangeLog.warn((Object)"BLOCK* INodeFileUnderConstruction.initLeaseRecovery: No blocks found, lease removed.");
        }
        int previous = this.primaryNodeIndex;
        for (int i = 1; i <= this.replicas.size(); ++i) {
            int j = (previous + i) % this.replicas.size();
            if (!this.replicas.get(j).isAlive()) continue;
            this.primaryNodeIndex = j;
            DatanodeDescriptor primary = this.replicas.get(j).getExpectedLocation();
            primary.addBlockToBeRecovered(this);
            NameNode.stateChangeLog.info((Object)("BLOCK* " + this + " recovery started, primary=" + primary));
            return;
        }
    }

    void addReplicaIfNotPresent(DatanodeDescriptor dn, Block block, HdfsConstants.ReplicaState rState) {
        for (ReplicaUnderConstruction r : this.replicas) {
            if (r.getExpectedLocation() != dn) continue;
            return;
        }
        this.replicas.add(new ReplicaUnderConstruction(block, dn, rState));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("{blockUCState=").append((Object)this.blockUCState).append(", primaryNodeIndex=").append(this.primaryNodeIndex).append(", replicas=").append(this.replicas).append("}");
        return b.toString();
    }

    static class ReplicaUnderConstruction
    extends Block {
        private DatanodeDescriptor expectedLocation;
        private HdfsConstants.ReplicaState state;

        ReplicaUnderConstruction(Block block, DatanodeDescriptor target, HdfsConstants.ReplicaState state) {
            super(block);
            this.expectedLocation = target;
            this.state = state;
        }

        DatanodeDescriptor getExpectedLocation() {
            return this.expectedLocation;
        }

        HdfsConstants.ReplicaState getState() {
            return this.state;
        }

        void setState(HdfsConstants.ReplicaState s) {
            this.state = s;
        }

        boolean isAlive() {
            return this.expectedLocation.isAlive;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || super.equals(obj);
        }

        @Override
        public String toString() {
            StringBuilder b = new StringBuilder(this.getClass().getSimpleName());
            b.append("[").append(this.expectedLocation).append("|").append((Object)this.state).append("]");
            return b.toString();
        }
    }
}

