/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.common.HdfsConstants;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.BackupStorage;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.Checkpointer;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class BackupNode
extends NameNode {
    private static final String BN_ADDRESS_NAME_KEY = "dfs.namenode.backup.address";
    private static final String BN_ADDRESS_DEFAULT = "localhost:50100";
    private static final String BN_HTTP_ADDRESS_NAME_KEY = "dfs.namenode.backup.http-address";
    private static final String BN_HTTP_ADDRESS_DEFAULT = "0.0.0.0:50105";
    NamenodeProtocol namenode;
    String nnRpcAddress;
    String nnHttpAddress;
    Checkpointer checkpointManager;

    BackupNode(Configuration conf, HdfsConstants.NamenodeRole role) throws IOException {
        super(conf, role);
    }

    @Override
    protected InetSocketAddress getRpcServerAddress(Configuration conf) throws IOException {
        String addr = conf.get(BN_ADDRESS_NAME_KEY, BN_ADDRESS_DEFAULT);
        int port = NetUtils.createSocketAddr((String)addr).getPort();
        String hostName = DNS.getDefaultHost((String)"default");
        return new InetSocketAddress(hostName, port);
    }

    @Override
    protected void setRpcServerAddress(Configuration conf) {
        conf.set(BN_ADDRESS_NAME_KEY, BackupNode.getHostPortString(this.rpcAddress));
    }

    @Override
    protected InetSocketAddress getHttpServerAddress(Configuration conf) {
        assert (this.rpcAddress != null) : "rpcAddress should be calculated first";
        String addr = conf.get(BN_HTTP_ADDRESS_NAME_KEY, BN_HTTP_ADDRESS_DEFAULT);
        int port = NetUtils.createSocketAddr((String)addr).getPort();
        String hostName = this.rpcAddress.getHostName();
        return new InetSocketAddress(hostName, port);
    }

    @Override
    protected void setHttpServerAddress(Configuration conf) {
        conf.set(BN_HTTP_ADDRESS_NAME_KEY, BackupNode.getHostPortString(this.httpAddress));
    }

    @Override
    protected void loadNamesystem(Configuration conf) throws IOException {
        BackupStorage bnImage = new BackupStorage();
        this.namesystem = new FSNamesystem(conf, bnImage);
        bnImage.recoverCreateRead(FSNamesystem.getNamespaceDirs(conf), FSNamesystem.getNamespaceEditsDirs(conf));
    }

    @Override
    protected void initialize(Configuration conf) throws IOException {
        conf.setLong("fs.trash.interval", 0L);
        NamespaceInfo nsInfo = this.handshake(conf);
        super.initialize(conf);
        this.namesystem.leaseManager.setLeasePeriod(60000L, Long.MAX_VALUE);
        this.registerWith(nsInfo);
        this.runCheckpointDaemon(conf);
    }

    @Override
    public void stop() {
        if (this.checkpointManager != null) {
            this.checkpointManager.shouldRun = false;
        }
        if (this.namenode != null && this.getRegistration() != null) {
            try {
                this.namenode.errorReport(this.getRegistration(), 1, "Shutting down.");
            }
            catch (IOException e) {
                LOG.error((Object)"Failed to report to name-node.", (Throwable)e);
            }
        }
        RPC.stopProxy((Object)this.namenode);
        this.namenode = null;
        if (this.checkpointManager != null) {
            this.checkpointManager.interrupt();
            this.checkpointManager = null;
        }
        super.stop();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        throw new UnsupportedActionException("getBlocks");
    }

    @Override
    public NamenodeRegistration register(NamenodeRegistration registration) throws IOException {
        throw new UnsupportedActionException("journal");
    }

    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        throw new UnsupportedActionException("startCheckpoint");
    }

    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        throw new UnsupportedActionException("endCheckpoint");
    }

    @Override
    public void journal(NamenodeRegistration nnReg, int jAction, int length, byte[] args) throws IOException {
        this.verifyRequest(nnReg);
        if (!this.nnRpcAddress.equals(nnReg.getAddress())) {
            throw new IOException("Journal request from unexpected name-node: " + nnReg.getAddress() + " expecting " + this.nnRpcAddress);
        }
        BackupStorage bnImage = (BackupStorage)this.getFSImage();
        switch (jAction) {
            case 100: {
                return;
            }
            case 101: {
                bnImage.journal(length, args);
                return;
            }
            case 102: {
                bnImage.startJournalSpool(nnReg);
                return;
            }
            case 103: {
                bnImage.setCheckpointTime(length, args);
                this.setRegistration();
                return;
            }
        }
        throw new IOException("Unexpected journal action: " + jAction);
    }

    boolean shouldCheckpointAtStartup() {
        FSImage fsImage = this.getFSImage();
        if (this.isRole(HdfsConstants.NamenodeRole.CHECKPOINT)) {
            assert (fsImage.getNumStorageDirs() > 0);
            return !fsImage.getStorageDir(0).getVersionFile().exists();
        }
        if (this.namesystem == null || this.namesystem.dir == null || this.getFSImage() == null) {
            return true;
        }
        return fsImage.getEditLog().getNumEditStreams() == 0;
    }

    private NamespaceInfo handshake(Configuration conf) throws IOException {
        InetSocketAddress nnAddress = super.getRpcServerAddress(conf);
        this.namenode = (NamenodeProtocol)RPC.waitForProxy(NamenodeProtocol.class, (long)4L, (InetSocketAddress)nnAddress, (Configuration)conf);
        this.nnRpcAddress = BackupNode.getHostPortString(nnAddress);
        this.nnHttpAddress = BackupNode.getHostPortString(super.getHttpServerAddress(conf));
        NamespaceInfo nsInfo = null;
        while (!this.isStopRequested()) {
            try {
                nsInfo = BackupNode.handshake(this.namenode);
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to server: " + nnAddress));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        return nsInfo;
    }

    private void runCheckpointDaemon(Configuration conf) throws IOException {
        this.checkpointManager = new Checkpointer(conf, this);
        this.checkpointManager.start();
    }

    void doCheckpoint() throws IOException {
        this.checkpointManager.doCheckpoint();
    }

    FSImage.CheckpointStates getCheckpointState() {
        return this.getFSImage().getCheckpointState();
    }

    void setCheckpointState(FSImage.CheckpointStates cs) {
        this.getFSImage().setCheckpointState(cs);
    }

    private void registerWith(NamespaceInfo nsInfo) throws IOException {
        BackupStorage bnImage = (BackupStorage)this.getFSImage();
        if (bnImage.getNamespaceID() == 0) {
            bnImage.setStorageInfo(nsInfo);
        } else if (bnImage.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs: active node namespaceID = " + nsInfo.getNamespaceID() + "; backup node namespaceID = " + bnImage.getNamespaceID());
        }
        this.setRegistration();
        NamenodeRegistration nnReg = null;
        while (!this.isStopRequested()) {
            try {
                nnReg = this.namenode.register(this.getRegistration());
                break;
            }
            catch (SocketTimeoutException e) {
                LOG.info((Object)("Problem connecting to name-node: " + this.nnRpcAddress));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {}
            }
        }
        String msg = null;
        if (nnReg == null) {
            msg = "Registration rejected by " + this.nnRpcAddress;
        } else if (!nnReg.isRole(HdfsConstants.NamenodeRole.ACTIVE)) {
            msg = "Name-node " + this.nnRpcAddress + " is not active";
        }
        if (msg != null) {
            msg = msg + ". Shutting down.";
            LOG.error((Object)msg);
            throw new IOException(msg);
        }
        this.nnRpcAddress = nnReg.getAddress();
    }

    void resetNamespace() throws IOException {
        ((BackupStorage)this.getFSImage()).reset();
    }

    long journalSize() throws IOException {
        return this.namesystem.getEditLogSize();
    }

    private static NamespaceInfo handshake(NamenodeProtocol namenode) throws IOException, SocketTimeoutException {
        NamespaceInfo nsInfo = namenode.versionRequest();
        String errorMsg = null;
        if (!nsInfo.getBuildVersion().equals(Storage.getBuildVersion())) {
            errorMsg = "Incompatible build versions: active name-node BV = " + nsInfo.getBuildVersion() + "; backup node BV = " + Storage.getBuildVersion();
            LOG.fatal((Object)errorMsg);
            throw new IOException(errorMsg);
        }
        assert (-24 == nsInfo.getLayoutVersion()) : "Active and backup node layout versions must be the same. Expected: -24 actual " + nsInfo.getLayoutVersion();
        return nsInfo;
    }
}

