/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class Hdfs
extends AbstractFileSystem {
    DFSClient dfs;
    private boolean verifyChecksum = true;

    Hdfs(URI theUri, Configuration conf) throws IOException, URISyntaxException {
        super(theUri, "hdfs", true, 8020);
        if (!theUri.getScheme().equalsIgnoreCase("hdfs")) {
            throw new IllegalArgumentException("Passed URI's scheme is not for Hdfs");
        }
        String host = theUri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + theUri);
        }
        InetSocketAddress namenode = NameNode.getAddress(theUri.getAuthority());
        this.dfs = new DFSClient(namenode, conf, this.getStatistics());
    }

    protected int getUriDefaultPort() {
        return 8020;
    }

    protected FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> createFlag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, int bytesPerChecksum, boolean createParent) throws IOException {
        return new FSDataOutputStream(this.dfs.primitiveCreate(this.getUriPath(f), absolutePermission, createFlag, createParent, replication, blockSize, progress, bufferSize, bytesPerChecksum), this.getStatistics());
    }

    protected boolean delete(Path f, boolean recursive) throws IOException, UnresolvedLinkException {
        return this.dfs.delete(this.getUriPath(f), recursive);
    }

    protected BlockLocation[] getFileBlockLocations(Path p, long start, long len) throws IOException, UnresolvedLinkException {
        return this.dfs.getBlockLocations(this.getUriPath(p), start, len);
    }

    protected FileChecksum getFileChecksum(Path f) throws IOException, UnresolvedLinkException {
        return this.dfs.getFileChecksum(this.getUriPath(f));
    }

    protected FileStatus getFileStatus(Path f) throws IOException, UnresolvedLinkException {
        HdfsFileStatus fi = this.dfs.getFileInfo(this.getUriPath(f));
        if (fi != null) {
            return this.makeQualified(fi, f);
        }
        throw new FileNotFoundException("File does not exist: " + f.toString());
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException, UnresolvedLinkException {
        HdfsFileStatus fi = this.dfs.getFileLinkInfo(this.getUriPath(f));
        if (fi != null) {
            return this.makeQualified(fi, f);
        }
        throw new FileNotFoundException("File does not exist: " + f);
    }

    private FileStatus makeQualified(HdfsFileStatus f, Path parent) {
        return new FileStatus(f.getLen(), f.isDir(), (int)f.getReplication(), f.getBlockSize(), f.getModificationTime(), f.getAccessTime(), f.getPermission(), f.getOwner(), f.getGroup(), f.isSymlink() ? new Path(f.getSymlink()) : null, f.getFullPath(parent).makeQualified(this.getUri(), null));
    }

    protected FsStatus getFsStatus() throws IOException {
        return this.dfs.getDiskStatus();
    }

    protected FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    protected Iterator<FileStatus> listStatusIterator(final Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return new Iterator<FileStatus>(){
            private DirectoryListing thisListing;
            private int i;
            private String src;
            {
                this.src = Hdfs.this.getUriPath(f);
                this.thisListing = Hdfs.this.dfs.listPaths(this.src, HdfsFileStatus.EMPTY_NAME);
                if (this.thisListing == null) {
                    throw new FileNotFoundException("File " + f + " does not exist.");
                }
            }

            @Override
            public boolean hasNext() {
                if (this.thisListing == null) {
                    return false;
                }
                try {
                    if (this.i >= this.thisListing.getPartialListing().length && this.thisListing.hasMore()) {
                        this.thisListing = Hdfs.this.dfs.listPaths(this.src, this.thisListing.getLastName());
                        if (this.thisListing == null) {
                            return false;
                        }
                        this.i = 0;
                    }
                    return this.i < this.thisListing.getPartialListing().length;
                }
                catch (IOException ioe) {
                    return false;
                }
            }

            @Override
            public FileStatus next() {
                if (this.hasNext()) {
                    return Hdfs.this.makeQualified(this.thisListing.getPartialListing()[this.i++], f);
                }
                throw new NoSuchElementException("No more entry in " + f);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove is not supported");
            }
        };
    }

    protected FileStatus[] listStatus(Path f) throws IOException, UnresolvedLinkException {
        String src = this.getUriPath(f);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + f + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = this.makeQualified(partialListing[i], f);
            }
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(this.makeQualified(fileStatus, f));
        }
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + f + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(this.makeQualified(fileStatus, f));
            }
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    protected void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException, UnresolvedLinkException {
        this.dfs.mkdirs(this.getUriPath(dir), permission, createParent);
    }

    protected FSDataInputStream open(Path f, int bufferSize) throws IOException, UnresolvedLinkException {
        return new DFSClient.DFSDataInputStream(this.dfs.open(this.getUriPath(f), bufferSize, this.verifyChecksum));
    }

    protected void renameInternal(Path src, Path dst) throws IOException, UnresolvedLinkException {
        this.dfs.rename(this.getUriPath(src), this.getUriPath(dst));
    }

    protected void renameInternal(Path src, Path dst, boolean overwrite) throws IOException, UnresolvedLinkException {
        this.dfs.rename(this.getUriPath(src), this.getUriPath(dst), overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE);
    }

    protected void setOwner(Path f, String username, String groupname) throws IOException, UnresolvedLinkException {
        this.dfs.setOwner(this.getUriPath(f), username, groupname);
    }

    protected void setPermission(Path f, FsPermission permission) throws IOException, UnresolvedLinkException {
        this.dfs.setPermission(this.getUriPath(f), permission);
    }

    protected boolean setReplication(Path f, short replication) throws IOException, UnresolvedLinkException {
        return this.dfs.setReplication(this.getUriPath(f), replication);
    }

    protected void setTimes(Path f, long mtime, long atime) throws IOException, UnresolvedLinkException {
        this.dfs.setTimes(this.getUriPath(f), mtime, atime);
    }

    protected void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        this.verifyChecksum = verifyChecksum;
    }

    protected boolean supportsSymlinks() {
        return true;
    }

    protected void createSymlink(Path target, Path link, boolean createParent) throws IOException, UnresolvedLinkException {
        this.dfs.createSymlink(target.toString(), this.getUriPath(link), createParent);
    }

    protected Path getLinkTarget(Path p) throws IOException {
        return new Path(this.dfs.getLinkTarget(this.getUriPath(p)));
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
    }
}

