/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.samlapi;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.elements.SAMLAttribute;
import eu.unicore.samly2.elements.Subject;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.samly2.proto.AssertionResponse;
import eu.unicore.samly2.proto.AttributeQuery;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import pl.edu.icm.unicore.uvos.api.Attribute;
import pl.edu.icm.unicore.uvos.api.Group;
import pl.edu.icm.unicore.uvos.api.Identity;
import pl.edu.icm.unicore.uvos.api.exceptions.AttributeNotFoundException;
import pl.edu.icm.unicore.uvos.api.exceptions.InvalidValueException;
import pl.edu.icm.unicore.uvos.util.AttributeFilter;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLQueryInterface;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.SAMLXMLBeansMapper;
import pl.edu.icm.unicore.uvos.wsapi.xmlbeans.UnsupportedSAMLException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvocationException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLErrorResponseException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOClient;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SAMLVOQueryClientInterface;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;
import xmlbeans.org.oasis.saml2.assertion.AttributeStatementType;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryType;
import xmlbeans.org.oasis.saml2.protocol.ResponseDocument;
import xmlbeans.pl.edu.icm.samlvo.attrext.RequestedGroupScopeDocument;

public class SAMLVOQueryClient
extends SAMLVOClient
implements SAMLVOQueryClientInterface {
    private SAMLQueryInterface queryProxy;

    public SAMLVOQueryClient(String address, IClientConfiguration secProv) throws SecuritySetupException, MalformedURLException {
        super(address, secProv);
        this.initProxy();
    }

    public SAMLVOQueryClient(String address, IClientConfiguration secProv, URI issuer) throws SecuritySetupException, MalformedURLException {
        super(address, secProv, issuer);
        this.initProxy();
    }

    private void initProxy() {
        try {
            if (this.queryProxy == null) {
                this.queryProxy = this.fact.getSAMLQueryClient(this.address);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public List<Attribute> getAttributes(Identity whose, String attributeName) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAttributesGeneric(whose, attributeName, null, null, null);
    }

    @Override
    public Attribute getAttribute(Identity whose, Group scope, String attributeName) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        List<Attribute> list = this.getAttributesGeneric(whose, attributeName, null, scope, "urn:SAML:voprofile:ScopedValue");
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Attribute> getAttributes(Identity whose, Attribute attribute) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAttributesGeneric(whose, attribute.getName(), attribute.getValues(), null, null);
    }

    @Override
    public Attribute getAttribute(Identity whose, Group scope, Attribute attribute) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        List<Attribute> list = this.getAttributesGeneric(whose, attribute.getName(), attribute.getValues(), scope, "urn:SAML:voprofile:ScopedValue");
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<Attribute> getAttributes(Identity whose) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAttributesGeneric(whose, null, null, null, null);
    }

    @Override
    public List<Attribute> getAttributes(Identity whose, Group scope) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAttributesGeneric(whose, null, null, scope, null);
    }

    @Override
    public List<Attribute> getSimpleScopedAttribute(Identity whose, Attribute attribute) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException, InvalidValueException {
        List vals = attribute.getValues();
        if (vals == null || vals.size() == 0) {
            throw new InvalidValueException("No values set in attribute");
        }
        for (String val : vals) {
            if (val.contains("@/")) continue;
            throw new InvalidValueException("Values invalid: " + val);
        }
        return this.getAttributesGeneric(whose, attribute.getName(), attribute.getValues(), null, "urn:SAML:voprofile:SimpleScopedString");
    }

    @Override
    public Assertion getAssertion(Identity whose, String attributeName) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAssertionGeneric(whose, attributeName, null, null, null);
    }

    @Override
    public Assertion getAssertion(Identity whose) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAssertionGeneric(whose, null, null, null, null);
    }

    @Override
    public Assertion getAssertion(Identity whose, Group scope) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAssertionGeneric(whose, null, null, scope, null);
    }

    @Override
    public Assertion getAssertion(Identity whose, Attribute attribute) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAssertionGeneric(whose, attribute.getName(), attribute.getValues(), null, null);
    }

    @Override
    public Assertion getAssertionSimpleScoped(Identity whose, List<Attribute> attributes) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAssertionGenericMulti(whose, attributes, null, "urn:SAML:voprofile:SimpleScopedString");
    }

    @Override
    public Assertion getAssertion(Identity whose, List<Attribute> attributes, Group scope) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        return this.getAssertionGenericMulti(whose, attributes, scope, null);
    }

    @Override
    public Assertion getFilteredAssertion(Identity whose, Group scope, boolean matchSubgroups, AttributeFilter filter) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException, AttributeNotFoundException {
        Assertion fullA = this.getAssertion(whose);
        if (scope == null && (filter == null || filter.allowsEverything())) {
            return fullA;
        }
        List<Attribute> attributes = SAMLXMLBeansMapper.convertSAMLAttributes2API((Assertion)fullA);
        if (attributes.size() == 0) {
            return fullA;
        }
        if (filter != null && !filter.allowsEverything()) {
            attributes = filter.filter((List)attributes);
        }
        if (scope != null) {
            attributes = SAMLVOQueryClient.filterByGroup(scope, matchSubgroups, attributes);
        }
        if (attributes.size() == 0) {
            throw new AttributeNotFoundException("ANY");
        }
        List<AttributeType> queryFilter = this.filterAttributes(fullA, attributes);
        Assertion finalAnswer = this.getAssertionWithSAMLAttributes(whose, queryFilter);
        return finalAnswer;
    }

    protected List<AttributeType> filterAttributes(Assertion fullA, List<Attribute> filteringAttributes) throws UnsupportedSAMLException, SAMLParseException {
        AttributeStatementType[] xmlAttrStatements = fullA.getAttributes();
        ArrayList<AttributeType> queryFilter = new ArrayList<AttributeType>();
        for (AttributeStatementType xmlAttrStatement : xmlAttrStatements) {
            AttributeType[] xmlAttrs;
            for (AttributeType xmlAttr : xmlAttrs = xmlAttrStatement.getAttributeArray()) {
                AttributeType filtered = null;
                for (int i = 0; i < xmlAttr.sizeOfAttributeValueArray(); ++i) {
                    AttributeType copy = (AttributeType)xmlAttr.copy();
                    copy.setAttributeValueArray(new XmlObject[]{xmlAttr.getAttributeValueArray()[i]});
                    List attr = SAMLXMLBeansMapper.map2APIAttributes((AttributeType)copy);
                    if (attr.size() != 1) {
                        throw new IllegalStateException("BUG: an attribute with a single value was converted into: " + attr.size());
                    }
                    if (!this.isInList((Attribute)attr.get(0), filteringAttributes)) continue;
                    if (filtered == null) {
                        filtered = (AttributeType)xmlAttr.copy();
                        filtered.setAttributeValueArray(new XmlObject[0]);
                    }
                    filtered.addNewAttributeValue();
                    filtered.setAttributeValueArray(filtered.getAttributeValueArray().length - 1, xmlAttr.getAttributeValueArray()[i]);
                }
                if (filtered == null) continue;
                queryFilter.add(filtered);
            }
        }
        return queryFilter;
    }

    protected boolean isInList(Attribute searched, List<Attribute> list) {
        for (Attribute cmp : list) {
            if (!cmp.getName().equals(searched.getName()) || !cmp.equalScope(searched)) continue;
            if (searched.getValues().size() == 0) {
                return true;
            }
            for (String value : searched.getValues()) {
                for (String value2 : cmp.getValues()) {
                    if (value != null && value.equals(value2)) {
                        return true;
                    }
                    if (value != null || value2 != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected Assertion getAssertionGeneric(Identity whose, String attributeName, List<String> attrValues, Group scope, String scopingType) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        List<Attribute> a = null;
        if (attributeName != null) {
            a = Collections.singletonList(new Attribute(attributeName, attrValues, null));
        }
        return this.getAssertionGenericMulti(whose, a, scope, scopingType);
    }

    protected List<Attribute> getAttributesGeneric(Identity whose, String attributeName, List<String> attrValues, Group scope, String scopingType) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        Assertion assertion = this.getAssertionGeneric(whose, attributeName, attrValues, scope, scopingType);
        return SAMLXMLBeansMapper.convertSAMLAttributes2API((Assertion)assertion);
    }

    protected Assertion getAssertionGenericMulti(Identity whose, List<Attribute> attributes, Group scope, String scopingType) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        String strScope;
        AttributeQuery attrQuery = this.createQuery(whose);
        String string = strScope = scope == null ? null : scope.toString();
        if (attributes != null && attributes.size() > 0) {
            SAMLAttribute[] samlAttrs = new SAMLAttribute[attributes.size()];
            for (int i = 0; i < attributes.size(); ++i) {
                List attrValues;
                Attribute a = attributes.get(i);
                samlAttrs[i] = new SAMLAttribute(a.getName(), "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
                if (scopingType == null && scope != null) {
                    scopingType = "urn:SAML:voprofile:ScopedValue";
                }
                if (scopingType != null) {
                    samlAttrs[i].setScopingType(scopingType);
                }
                if ((attrValues = a.getValues()) != null && attrValues.size() > 0) {
                    for (String aV : attrValues) {
                        this.addValue(samlAttrs[i], aV, scopingType, strScope);
                    }
                    continue;
                }
                if (scopingType == null || scopingType.equals("urn:SAML:voprofile:NonScopedValue")) continue;
                samlAttrs[i].setAttributeWideScope(strScope);
            }
            attrQuery.setAttributes(samlAttrs);
        }
        if (scope != null && (attributes == null || attributes.size() == 0)) {
            RequestedGroupScopeDocument scopeDoc = RequestedGroupScopeDocument.Factory.newInstance();
            scopeDoc.addNewRequestedGroupScope().addGroup(strScope);
            attrQuery.setExtensions((XmlObject)scopeDoc);
        }
        return this.performSAMLQuery(attrQuery);
    }

    protected Assertion getAssertionWithSAMLAttributes(Identity whose, List<AttributeType> samlAttrs) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        AttributeQuery attrQuery = this.createQuery(whose);
        if (samlAttrs != null && samlAttrs.size() > 0) {
            AttributeQueryType aQuery = attrQuery.getDoc().getAttributeQuery();
            for (int i = 0; i < samlAttrs.size(); ++i) {
                aQuery.insertNewAttribute(i);
                aQuery.setAttributeArray(i, samlAttrs.get(i));
            }
        }
        return this.performSAMLQuery(attrQuery);
    }

    protected Assertion performSAMLQuery(AttributeQuery attrQuery) throws SAMLParseException, UnsupportedSAMLException, InvalidSignatureException, InvocationException, SAMLErrorResponseException {
        Assertion[] assertions;
        ResponseDocument xmlRespDoc;
        this.signIfNeeded((AbstractRequest)attrQuery);
        try {
            xmlRespDoc = this.queryProxy.attributeQuery(attrQuery.getDoc());
            this.lastResponse = xmlRespDoc;
        }
        catch (Exception e) {
            throw new InvocationException(e);
        }
        AssertionResponse resp = new AssertionResponse(xmlRespDoc);
        resp.parse();
        if (!resp.isStatusOK()) {
            throw new SAMLErrorResponseException(resp.getErrorMessage(), resp.getErrorStatus(), resp.getSubErrorStatus());
        }
        this.checkResponseSignature((AbstractStatusResponse)resp);
        try {
            assertions = resp.getAssertions();
        }
        catch (Exception e) {
            throw new SAMLParseException(e.toString());
        }
        if (assertions.length == 0) {
            return null;
        }
        if (assertions.length > 1) {
            throw new UnsupportedSAMLException("More than one assertion was returned. It is OK,however this implementation supports only responses with a single assertion.");
        }
        Assertion assertion = assertions[0];
        this.checkAssertionSignature((AbstractStatusResponse)resp, assertion);
        return assertion;
    }

    private void addValue(SAMLAttribute samlA, String value, String scopingType, String scope) {
        if (value != null) {
            if (!"urn:SAML:voprofile:ScopedValue".equals(scopingType)) {
                samlA.addStringAttributeValue(value);
            } else {
                samlA.addScopedStringAttributeValue(value, scope);
            }
        } else {
            if (scopingType.equals("urn:SAML:voprofile:SimpleScopedString")) {
                samlA.addStringAttributeValue("@/" + (scope != null ? scope : ""));
            }
            if (scopingType.equals("urn:SAML:voprofile:ScopedValue")) {
                samlA.addScopedStringAttributeValue(null, scope);
            }
        }
    }

    public static List<Attribute> filterByGroup(Group scope, boolean includeSubgroups, List<Attribute> toFilter) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        String scopeS = scope.toString();
        for (int i = 0; i < toFilter.size(); ++i) {
            Attribute tested = toFilter.get(i);
            if (!SAMLVOQueryClient.isInScope(tested, scope, includeSubgroups, scopeS)) continue;
            ret.add(tested);
        }
        return ret;
    }

    public static boolean isInScope(Attribute tested, Group scope, boolean includeSubgroups, String scopeS) {
        Group testedScope;
        if (tested.getScope() == null || tested.equalScope(scopeS)) {
            return true;
        }
        return includeSubgroups && (testedScope = new Group(tested.getScope())).isChild(scope);
    }

    protected AttributeQuery createQuery(Identity whose) {
        Subject subject = new Subject(whose.getValue(), whose.getType().getName().toString());
        return new AttributeQuery(this.issuer, subject);
    }

    @Override
    public Object getProxy() {
        return this.queryProxy;
    }
}

