/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.samlapi;

import eu.unicore.samly2.elements.NameID;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.xmlbeans.XmlObject;
import pl.edu.icm.unicore.uvos.wsclient.api.UVOSClientFactory;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.AbstractSAMLBase;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;

public abstract class SAMLVOClient
extends AbstractSAMLBase {
    protected String address;
    protected NameID issuer;
    protected boolean autoIssuer;
    protected UVOSClientFactory fact;
    protected XmlObject lastResponse;

    public SAMLVOClient(String address, IClientConfiguration secProv) throws SecuritySetupException, MalformedURLException {
        this(address, secProv, (NameID)null);
    }

    public SAMLVOClient(String address, IClientConfiguration secProv, URI issuerURI) throws SecuritySetupException, MalformedURLException {
        this(address, secProv, new NameID(issuerURI.toString(), "urn:oasis:names:tc:SAML:2.0:nameid-format:entity"));
    }

    protected SAMLVOClient(String address, IClientConfiguration secCfg, NameID issuer) throws SecuritySetupException, MalformedURLException {
        new URL(address);
        this.address = address;
        this.fact = new UVOSClientFactory(secCfg);
        if (issuer != null) {
            this.issuer = issuer;
            this.autoIssuer = false;
        } else {
            if (secCfg.getCredential() != null) {
                this.certificateC = secCfg.getCredential().getCertificateChain();
            }
            if (this.certificateC == null || this.certificateC.length == 0) {
                throw new SecuritySetupException("No issuer was provided and keystore doesn't provide user's identity so it is impossible to generate one.", null);
            }
            this.issuer = new NameID(this.certificateC[0].getSubjectX500Principal().getName(), "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
            this.autoIssuer = true;
        }
    }

    public XmlObject getLastResponse() {
        return this.lastResponse;
    }

    public void setIssuer(NameID issuer) {
        this.issuer = issuer;
        this.autoIssuer = false;
    }

    public abstract Object getProxy();
}

