/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.unicore.uvos.wsclient.samlapi;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.samly2.proto.AbstractRequest;
import eu.unicore.samly2.proto.AbstractStatusResponse;
import eu.unicore.security.dsig.DSigException;
import java.net.MalformedURLException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.InvalidSignatureException;
import pl.edu.icm.unicore.uvos.wsclient.samlapi.SecuritySetupException;

public abstract class AbstractSAMLBase {
    protected boolean requireSignedResp = false;
    protected boolean requireSignedAssertion = false;
    protected boolean doSignRequest = false;
    protected PublicKey publicKey;
    private transient PrivateKey privKey;
    protected X509Certificate[] certificateC;
    private transient X509CertChainValidator validator;

    protected AbstractSAMLBase() throws SecuritySetupException, MalformedURLException {
    }

    public void setDSigPolicy(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential, PublicKey publicKey) {
        if (publicKey == null && (requireSignedAssertion || requireSignedReqResp)) {
            throw new IllegalArgumentException("Public key can not be null if signature checking is required.");
        }
        this.setDSigPolicyCommon(requireSignedReqResp, requireSignedAssertion, credential);
        this.publicKey = publicKey;
        this.validator = null;
    }

    public void setDSigPolicy(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential, X509CertChainValidator validator) {
        if (validator == null && (requireSignedAssertion || requireSignedReqResp)) {
            throw new IllegalArgumentException("Validator can not be null if signature checking is required.");
        }
        this.setDSigPolicyCommon(requireSignedReqResp, requireSignedAssertion, credential);
        this.publicKey = null;
        this.validator = validator;
    }

    protected void setDSigPolicyCommon(boolean requireSignedReqResp, boolean requireSignedAssertion, X509Credential credential) {
        if (credential == null && requireSignedReqResp) {
            throw new IllegalArgumentException("Credential can not be null if request signing is required.");
        }
        this.requireSignedAssertion = requireSignedAssertion;
        this.requireSignedResp = requireSignedReqResp;
        this.doSignRequest = requireSignedReqResp;
        if (credential != null) {
            this.certificateC = credential.getCertificateChain();
            this.privKey = credential.getKey();
        } else {
            this.certificateC = null;
            this.privKey = null;
        }
    }

    protected void signIfNeeded(AbstractRequest req) throws InvalidSignatureException {
        if (this.doSignRequest) {
            try {
                req.sign(this.privKey, this.certificateC);
            }
            catch (DSigException e) {
                throw new InvalidSignatureException("Can't sign request: " + (Object)((Object)e));
            }
        }
    }

    protected void checkResponseSignature(AbstractStatusResponse resp) throws InvalidSignatureException {
        block9: {
            if (!this.requireSignedResp) {
                return;
            }
            if (this.publicKey != null) {
                try {
                    if (!resp.isCorrectlySigned(this.publicKey)) {
                        throw new InvalidSignatureException("Response is incorrectly signed");
                    }
                    break block9;
                }
                catch (DSigException e) {
                    throw new InvalidSignatureException("Problem when checking response signature with given pub key: " + (Object)((Object)e));
                }
            }
            X509Certificate[] issuersCC = resp.getIssuerFromSignature();
            if (issuersCC == null || issuersCC.length == 0) {
                throw new InvalidSignatureException("Response doesn't contain issuer's certificate and public key for verification wasn't specified");
            }
            try {
                this.checkIfTrusted(issuersCC, "Response");
                if (!resp.isCorrectlySigned(issuersCC[0].getPublicKey())) {
                    throw new InvalidSignatureException("Response is incorrectly signed");
                }
            }
            catch (DSigException e) {
                throw new InvalidSignatureException("Problem when checking response signature with extracted pub key: " + (Object)((Object)e));
            }
        }
    }

    protected void checkAssertionSignature(AbstractStatusResponse resp, Assertion assertion) throws InvalidSignatureException {
        block9: {
            if (!this.requireSignedAssertion) {
                return;
            }
            if (this.publicKey != null) {
                try {
                    if (!assertion.isCorrectlySigned(this.publicKey)) {
                        throw new InvalidSignatureException("Assertion is incorrectly signed");
                    }
                    break block9;
                }
                catch (DSigException e) {
                    throw new InvalidSignatureException("Problem when checking response assertion signature with given pub key: " + (Object)((Object)e));
                }
            }
            X509Certificate[] issuersCC = assertion.getIssuerFromSignature();
            if (!(issuersCC != null && issuersCC.length != 0 || (issuersCC = resp.getIssuerFromSignature()) != null && issuersCC.length != 0)) {
                throw new InvalidSignatureException("Assertion doesn't contain issuer's certificate and public key for verification wasn't specified");
            }
            try {
                this.checkIfTrusted(issuersCC, "Assertion");
                if (!assertion.isCorrectlySigned(issuersCC[0].getPublicKey())) {
                    throw new InvalidSignatureException("Response is incorrectly signed");
                }
            }
            catch (DSigException e) {
                throw new InvalidSignatureException("Problem when checking response assertion signature with extracted pub key: " + (Object)((Object)e));
            }
        }
    }

    private void checkIfTrusted(X509Certificate[] issuersCC, String msg) throws InvalidSignatureException {
        X509Certificate[] trustedIssuers = this.validator.getTrustedIssuers();
        boolean found = false;
        for (X509Certificate trusted : trustedIssuers) {
            if (!trusted.equals(issuersCC[0])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InvalidSignatureException(msg + " is signed by an issuer is not among trusted issuers" + " and verification key was not set automaticvally. Untrusted issuer is " + X500NameUtils.getReadableForm((X500Principal)issuersCC[0].getSubjectX500Principal()));
        }
    }
}

